/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.event.client;

import epicsquid.mysticallib.item.tool.IEffectiveTool;
import epicsquid.mysticallib.item.tool.ISizedTool;
import epicsquid.mysticallib.util.BreakUtil;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="mysticallib")
public class ToolOverlayRenderer {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderExtraBlockStuff(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        PlayerControllerMP controller = mc.field_71442_b;
        if (controller == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_70093_af()) {
            return;
        }
        ItemStack tool = player.func_184614_ca();
        Item toolItem = tool.func_77973_b();
        if (toolItem instanceof ISizedTool) {
            boolean drawDamage;
            Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
            if (renderEntity == null) {
                return;
            }
            RayTraceResult ray = BreakUtil.rayTrace(player.field_70170_p, (EntityPlayer)player);
            if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            Set<BlockPos> positions = BreakUtil.nearbyBlocks(tool, ray.func_178782_a(), (EntityPlayer)player);
            if (positions.isEmpty()) {
                return;
            }
            for (BlockPos position : positions) {
                event.getContext().func_72731_b((EntityPlayer)player, new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d(0.0, 0.0, 0.0), ray.field_178784_b, position), 0, mc.func_184121_ak());
            }
            boolean bl = drawDamage = toolItem instanceof IEffectiveTool && ((IEffectiveTool)toolItem).displayBreak();
            if (controller.func_181040_m() && drawDamage) {
                ToolOverlayRenderer.drawBlockDamage(player.field_70170_p, Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), (EntityPlayer)player, positions, ray.func_178782_a());
            }
        }
    }

    private static void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-1.0f, (float)-10.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private static void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static void drawBlockDamage(World world, Tessellator tessellator, BufferBuilder bufferBuilder, EntityPlayer player, Set<BlockPos> positions, BlockPos origin) {
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_184121_ak();
        DestroyBlockProgress progress = null;
        for (Map.Entry entry : mc.field_71438_f.field_72738_E.entrySet()) {
            if (!((DestroyBlockProgress)entry.getValue()).func_180246_b().equals((Object)origin)) continue;
            progress = (DestroyBlockProgress)entry.getValue();
            break;
        }
        if (progress == null) {
            return;
        }
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        ToolOverlayRenderer.preRenderDamagedBlocks();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilder.func_178969_c(-d0, -d1, -d2);
        bufferBuilder.func_78914_f();
        for (BlockPos blockpos : positions) {
            IBlockState state;
            TileEntity te = world.func_175625_s(blockpos);
            boolean hasBreak = te != null && te.canRenderBreaking();
            if (hasBreak || (state = world.func_180495_p(blockpos)).func_185904_a() == Material.field_151579_a) continue;
            mc.func_175602_ab().func_175020_a(state, blockpos, mc.field_71438_f.field_94141_F[progress.func_73106_e()], (IBlockAccess)world);
        }
        tessellator.func_78381_a();
        bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
        ToolOverlayRenderer.postRenderDamagedBlocks();
    }
}

