/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.model.IModeledObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFenceGateBase
extends BlockFenceGate
implements IBlock,
IModeledObject {
    @Nonnull
    private Item itemBlock;
    public List<ItemStack> drops = null;
    private boolean isOpaque = false;
    private boolean hasCustomModel = false;
    private boolean isFlammable = false;
    private BlockRenderLayer layer = BlockRenderLayer.SOLID;
    private Block parent;
    public String name = "";

    public BlockFenceGateBase(@Nonnull Block base, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(BlockPlanks.EnumType.OAK);
        this.parent = base;
        this.name = name;
        this.func_149647_a(null);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(type);
        this.func_149713_g(0);
        this.func_149711_c(hardness);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
    }

    @Nonnull
    public BlockFenceGateBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockFenceGateBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockFenceGateBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockFenceGateBase setHarvestReqs(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockFenceGateBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    @Nonnull
    public BlockFenceGateBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{field_176465_b}).func_178441_a());
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    @Nonnull
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public ItemBlock setItemBlock(ItemBlock block) {
        this.itemBlock = block;
        return block;
    }

    @Nonnull
    public Block getParent() {
        return this.parent;
    }
}

