/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.cave;

import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseTuple;
import com.yungnickyoung.minecraft.bettercaves.world.cave.AbstractBC;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class TestCave
extends AbstractBC {
    private NoiseGen noiseGen;

    public TestCave(World world, int fOctaves, float fGain, float fFreq, int numGens, float threshold, int tOctaves, float tGain, float tFreq, boolean enableTurbulence, float yComp, float xzComp, boolean yAdj, float yAdjF1, float yAdjF2) {
        super(world, fOctaves, fGain, fFreq, numGens, threshold, tOctaves, tGain, tFreq, enableTurbulence, yComp, xzComp, yAdj, yAdjF1, yAdjF2, Blocks.field_150346_d.func_176223_P());
        this.noiseGen = new NoiseGen(Configuration.testSettings.testnoiseType, world, this.fractalOctaves, this.fractalGain, this.fractalFreq, this.turbOctaves, this.turbGain, this.turbFreq, this.enableTurbulence, this.yCompression, this.xzCompression);
    }

    @Override
    public void generateColumn(int chunkX, int chunkZ, ChunkPrimer primer, int localX, int localZ, int bottomY, int topY, int maxSurfaceHeight, int minSurfaceHeight, int surfaceCutoff, IBlockState lavaBlock) {
        int transitionBoundary = maxSurfaceHeight - surfaceCutoff;
        Map<Integer, NoiseTuple> noises = this.noiseGen.generateNoiseCol(chunkX, chunkZ, bottomY, topY, this.numGens, localX, localZ);
        Map<Integer, Float> thresholds = this.generateThresholds(topY, bottomY, transitionBoundary);
        if (this.enableYAdjust) {
            this.preprocessCaveNoiseCol(noises, topY, bottomY, thresholds, this.numGens);
        }
        for (int realY = topY; realY >= bottomY; --realY) {
            List<Float> noiseBlock = noises.get(realY).getNoiseValues();
            boolean digBlock = true;
            for (float noise : noiseBlock) {
                if (!(noise < thresholds.get(realY).floatValue())) continue;
                digBlock = false;
                break;
            }
            if (Configuration.debugsettings.debugVisualizer) {
                this.visualizeDigBlock(digBlock, this.vBlock, primer, localX, realY, localZ);
                continue;
            }
            if (!digBlock) continue;
            this.digBlock(primer, chunkX, chunkZ, localX, localZ, realY);
        }
    }
}

