/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.cave;

import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseTuple;
import com.yungnickyoung.minecraft.bettercaves.world.cave.AbstractBC;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class CavernBC
extends AbstractBC {
    private NoiseGen noiseGen;
    private CavernType cavernType;

    public CavernBC(World world, CavernType cavernType, int fOctaves, float fGain, float fFreq, int numGens, float threshold, float yComp, float xzComp, IBlockState vBlock) {
        super(world, fOctaves, fGain, fFreq, numGens, threshold, 0, 0.0f, 0.0f, false, yComp, xzComp, false, 1.0f, 1.0f, vBlock);
        this.cavernType = cavernType;
        switch (cavernType) {
            case LAVA: {
                this.noiseType = FastNoise.NoiseType.PerlinFractal;
                break;
            }
            case FLOORED: {
                this.noiseType = FastNoise.NoiseType.PerlinFractal;
                break;
            }
            default: {
                this.noiseType = FastNoise.NoiseType.PerlinFractal;
            }
        }
        this.noiseGen = new NoiseGen(FastNoise.NoiseType.PerlinFractal, world, this.fractalOctaves, this.fractalGain, this.fractalFreq, this.turbOctaves, this.turbGain, this.turbFreq, this.enableTurbulence, this.yCompression, this.xzCompression);
    }

    @Override
    public void generateColumn(int chunkX, int chunkZ, ChunkPrimer primer, int localX, int localZ, int bottomY, int topY, int maxSurfaceHeight, int minSurfaceHeight, int surfaceCutoff, IBlockState lavaBlock, float smoothAmp) {
        if (localX < 0 || localX > 15) {
            return;
        }
        if (localZ < 0 || localZ > 15) {
            return;
        }
        if (bottomY < 0) {
            return;
        }
        if (topY > 255) {
            return;
        }
        int topTransitionBoundary = topY - 7;
        if (topTransitionBoundary < 1) {
            topTransitionBoundary = 1;
        }
        int bottomTransitionBoundary = 0;
        if (this.cavernType == CavernType.FLOORED) {
            bottomTransitionBoundary = bottomY <= 10 ? Configuration.lavaDepth + 4 : bottomY + 7;
        } else if (this.cavernType == CavernType.WATER) {
            bottomTransitionBoundary = bottomY + 3;
        }
        Map<Integer, NoiseTuple> noises = this.noiseGen.generateNoiseCol(chunkX, chunkZ, bottomY, topY, this.numGens, localX, localZ);
        for (int realY = topY; realY >= bottomY; --realY) {
            boolean digBlock = false;
            float noise = 1.0f;
            List<Float> noiseBlock = noises.get(realY).getNoiseValues();
            for (float n : noiseBlock) {
                noise *= n;
            }
            float noiseThreshold = this.noiseThreshold;
            if (realY >= topTransitionBoundary) {
                noiseThreshold *= Math.max((float)(realY - topY) / (float)(topTransitionBoundary - topY), 0.5f);
            }
            if (realY >= minSurfaceHeight - 5) {
                noiseThreshold *= (float)(realY - topY) / (float)(minSurfaceHeight - 5 - topY);
            }
            if ((this.cavernType == CavernType.FLOORED || this.cavernType == CavernType.WATER) && realY <= bottomTransitionBoundary) {
                noiseThreshold *= Math.max((float)(realY - bottomY) / (float)(bottomTransitionBoundary - bottomY), 0.5f);
            }
            if (smoothAmp < 1.0f) {
                noiseThreshold *= smoothAmp;
            }
            if (noise < noiseThreshold) {
                digBlock = true;
            }
            if (Configuration.debugsettings.debugVisualizer) {
                this.visualizeDigBlock(digBlock, this.vBlock, primer, localX, realY, localZ);
                continue;
            }
            if (!digBlock) continue;
            if (this.cavernType == CavernType.WATER) {
                if (primer.func_177856_a(localX, realY, localZ).func_185904_a() == Material.field_151587_i && realY <= Configuration.lavaDepth) {
                    primer.func_177855_a(localX, realY, localZ, Blocks.field_150355_j.func_176223_P());
                    continue;
                }
                this.digBlock(primer, lavaBlock, chunkX, chunkZ, localX, localZ, realY);
                continue;
            }
            this.digBlock(primer, lavaBlock, chunkX, chunkZ, localX, localZ, realY);
        }
    }

    @Override
    public void generateColumn(int chunkX, int chunkZ, ChunkPrimer primer, int localX, int localZ, int bottomY, int topY, int maxSurfaceHeight, int minSurfaceHeight, int surfaceCutoff, IBlockState lavaBlock) {
        this.generateColumn(chunkX, chunkZ, primer, localX, localZ, bottomY, topY, maxSurfaceHeight, minSurfaceHeight, surfaceCutoff, lavaBlock, 1.0f);
    }
}

