/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.cave;

import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseTuple;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCaveUtil;
import com.yungnickyoung.minecraft.bettercaves.util.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.world.cave.BetterCave;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class CaveSimplex
extends BetterCave {
    private NoiseGen simplexNoiseGen;

    public CaveSimplex(World world, int fOctaves, float fGain, float fFreq, int numGens, float threshold, int tOctaves, float tGain, float tFreq, boolean enableTurbulence, float yComp, float xzComp, boolean yAdj, float yAdjF1, float yAdjF2) {
        super(world, fOctaves, fGain, fFreq, numGens, threshold, tOctaves, tGain, tFreq, enableTurbulence, yComp, xzComp, yAdj, yAdjF1, yAdjF2);
        this.simplexNoiseGen = new NoiseGen(FastNoise.NoiseType.SimplexFractal, world, this.fractalOctaves, this.fractalGain, this.fractalFreq, this.turbOctaves, this.turbGain, this.turbFreq, this.enableTurbulence, this.yCompression, this.xzCompression);
    }

    public void generateColumn(int chunkX, int chunkZ, ChunkPrimer primer, int localX, int localZ, int bottomY, int topY, int maxSurfaceHeight, int minSurfaceHeight) {
        int simplexCaveTransitionBoundary = maxSurfaceHeight - 20;
        int simplexNumGens = this.numGens;
        Map<Integer, NoiseTuple> simplexNoises = this.simplexNoiseGen.generateNoiseCol(chunkX, chunkZ, bottomY, topY, simplexNumGens, localX, localZ);
        this.preprocessCaveNoiseCol(simplexNoises, topY, bottomY, simplexNumGens);
        for (int realY = topY; realY >= bottomY; --realY) {
            boolean digBlock = false;
            float simplexNoise = 0.0f;
            List<Float> simplexNoiseBlock = simplexNoises.get(realY).getNoiseValues();
            for (float noise : simplexNoiseBlock) {
                simplexNoise += noise;
            }
            simplexNoise /= (float)simplexNoiseBlock.size();
            float noiseThreshold = this.noiseThreshold;
            if (realY >= simplexCaveTransitionBoundary) {
                noiseThreshold *= 1.0f + 0.3f * ((float)(realY - simplexCaveTransitionBoundary) / (float)(topY - simplexCaveTransitionBoundary));
            }
            if (simplexNoise > noiseThreshold) {
                digBlock = true;
            }
            if (!digBlock || primer.func_177856_a(localX, realY + 1, localZ).func_185904_a() == Material.field_151586_h || localX < 15 && primer.func_177856_a(localX + 1, realY, localZ).func_185904_a() == Material.field_151586_h || localX > 0 && primer.func_177856_a(localX - 1, realY, localZ).func_185904_a() == Material.field_151586_h || localZ < 15 && primer.func_177856_a(localX, realY, localZ + 1).func_185904_a() == Material.field_151586_h || localZ > 0 && primer.func_177856_a(localX, realY, localZ - 1).func_185904_a() == Material.field_151586_h) continue;
            BetterCaveUtil.digBlock((World)this.getWorld(), (ChunkPrimer)primer, (int)localX, (int)realY, (int)localZ, (int)chunkX, (int)chunkZ);
        }
        IBlockState BlockStateAir = Blocks.field_150350_a.func_176223_P();
        for (int realY = simplexCaveTransitionBoundary + 1; realY < topY - 1; ++realY) {
            IBlockState currBlock = primer.func_177856_a(localX, realY, localZ);
            if (!BetterCaveUtil.canReplaceBlock((IBlockState)currBlock, (IBlockState)BlockStateAir) || primer.func_177856_a(localX, realY + 1, localZ) != BlockStateAir || primer.func_177856_a(localX, realY - 1, localZ) != BlockStateAir) continue;
            BetterCaveUtil.digBlock((World)this.getWorld(), (ChunkPrimer)primer, (int)localX, (int)realY, (int)localZ, (int)chunkX, (int)chunkZ);
        }
    }
}

