/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.cave;

import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseTuple;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class AbstractBC {
    private World world;
    private long seed;
    FastNoise.NoiseType noiseType;
    int fractalOctaves;
    float fractalGain;
    float fractalFreq;
    int numGens;
    int turbOctaves;
    float turbGain;
    float turbFreq;
    boolean enableTurbulence;
    protected float yCompression;
    protected float xzCompression;
    private float yAdjustF1;
    private float yAdjustF2;
    float noiseThreshold;
    boolean enableYAdjust;
    IBlockState vBlock;

    public AbstractBC(World world, int fOctaves, float fGain, float fFreq, int numGens, float threshold, int tOctaves, float tGain, float tFreq, boolean enableTurbulence, float yComp, float xzComp, boolean yAdj, float yAdjF1, float yAdjF2, IBlockState vBlock) {
        this.world = world;
        this.seed = world.func_72905_C();
        this.fractalOctaves = fOctaves;
        this.fractalGain = fGain;
        this.fractalFreq = fFreq;
        this.numGens = numGens;
        this.noiseThreshold = threshold;
        this.turbOctaves = tOctaves;
        this.turbGain = tGain;
        this.turbFreq = tFreq;
        this.enableTurbulence = enableTurbulence;
        this.yCompression = yComp;
        this.xzCompression = xzComp;
        this.enableYAdjust = yAdj;
        this.yAdjustF1 = yAdjF1;
        this.yAdjustF2 = yAdjF2;
        this.vBlock = vBlock;
    }

    public abstract void generateColumn(int var1, int var2, ChunkPrimer var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, IBlockState var11);

    public void generateColumn(int chunkX, int chunkZ, ChunkPrimer primer, int localX, int localZ, int bottomY, int topY, int maxSurfaceHeight, int minSurfaceHeight, int surfaceCutoff, IBlockState lavaBlock, float smoothAmp) {
    }

    protected void preprocessCaveNoiseCol(Map<Integer, NoiseTuple> noises, int topY, int bottomY, Map<Integer, Float> thresholds, int numGens) {
        for (int realY = topY; realY >= bottomY; --realY) {
            int i;
            NoiseTuple noiseBlock = noises.get(realY);
            float threshold = thresholds.get(realY).floatValue();
            boolean valid = true;
            for (float noise : noiseBlock.getNoiseValues()) {
                if (!(noise < threshold)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            float f1 = this.yAdjustF1;
            float f2 = this.yAdjustF2;
            if (realY < topY) {
                NoiseTuple tupleAbove = noises.get(realY + 1);
                for (i = 0; i < numGens; ++i) {
                    tupleAbove.set(i, (1.0f - f1) * tupleAbove.get(i) + f1 * noiseBlock.get(i));
                }
            }
            if (realY >= topY - 1) continue;
            NoiseTuple tupleTwoAbove = noises.get(realY + 2);
            for (i = 0; i < numGens; ++i) {
                tupleTwoAbove.set(i, (1.0f - f2) * tupleTwoAbove.get(i) + f2 * noiseBlock.get(i));
            }
        }
    }

    protected void digBlock(ChunkPrimer primer, IBlockState lavaBlock, int chunkX, int chunkZ, int localX, int localZ, int realY) {
        if (lavaBlock.func_185904_a() != Material.field_151586_h) {
            if (primer.func_177856_a(localX, realY + 1, localZ).func_185904_a() == Material.field_151586_h) {
                return;
            }
            if (localX < 15 && primer.func_177856_a(localX + 1, realY, localZ).func_185904_a() == Material.field_151586_h) {
                return;
            }
            if (localX > 0 && primer.func_177856_a(localX - 1, realY, localZ).func_185904_a() == Material.field_151586_h) {
                return;
            }
            if (localZ < 15 && primer.func_177856_a(localX, realY, localZ + 1).func_185904_a() == Material.field_151586_h) {
                return;
            }
            if (localZ > 0 && primer.func_177856_a(localX, realY, localZ - 1).func_185904_a() == Material.field_151586_h) {
                return;
            }
        }
        BetterCavesUtil.digBlock(this.getWorld(), primer, lavaBlock, localX, realY, localZ, chunkX, chunkZ);
    }

    protected void digBlock(ChunkPrimer primer, int chunkX, int chunkZ, int localX, int localZ, int realY) {
        this.digBlock(primer, Blocks.field_150353_l.func_176223_P(), chunkX, chunkZ, localX, localZ, realY);
    }

    protected Map<Integer, Float> generateThresholds(int topY, int bottomY, int transitionBoundary) {
        HashMap<Integer, Float> thresholds = new HashMap<Integer, Float>();
        for (int realY = bottomY; realY <= topY; ++realY) {
            float noiseThreshold = this.noiseThreshold;
            if (realY >= transitionBoundary) {
                noiseThreshold *= 1.0f + 0.3f * ((float)(realY - transitionBoundary) / (float)(topY - transitionBoundary));
            }
            thresholds.put(realY, Float.valueOf(noiseThreshold));
        }
        return thresholds;
    }

    protected void visualizeDigBlock(boolean digBlock, IBlockState blockState, ChunkPrimer primer, int localX, int realY, int localZ) {
        if (digBlock) {
            primer.func_177855_a(localX, realY, localZ, blockState);
        } else {
            primer.func_177855_a(localX, realY, localZ, Blocks.field_150350_a.func_176223_P());
        }
    }

    public World getWorld() {
        return this.world;
    }

    public long getSeed() {
        return this.seed;
    }
}

