/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world;

import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.config.Settings;
import com.yungnickyoung.minecraft.bettercaves.enums.CaveType;
import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtil;
import com.yungnickyoung.minecraft.bettercaves.world.bedrock.FlattenBedrock;
import com.yungnickyoung.minecraft.bettercaves.world.cave.AbstractBC;
import com.yungnickyoung.minecraft.bettercaves.world.cave.CaveBC;
import com.yungnickyoung.minecraft.bettercaves.world.cave.CavernBC;
import com.yungnickyoung.minecraft.bettercaves.world.cave.TestCave;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenCaves;

public class MapGenBetterCaves
extends MapGenCaves {
    private AbstractBC caveCubic;
    private AbstractBC caveSimplex;
    private AbstractBC cavernLava;
    private AbstractBC cavernFloored;
    private AbstractBC cavernWater;
    private int surfaceCutoff;
    private MapGenCaves defaultCaveGen;
    private FastNoise waterCavernController;
    private FastNoise cavernRegionController;
    private FastNoise caveRegionController;
    private float cubicCaveThreshold;
    private float simplexCaveThreshold;
    private float lavaCavernThreshold;
    private float flooredCavernThreshold;
    private float waterRegionThreshold;
    private float transitionRange = 0.15f;
    private boolean enableVanillaCaves;
    private boolean enableWaterRegions;
    private IBlockState lavaBlock;
    private IBlockState waterBlock;
    private AbstractBC testCave;

    private void debugGenerate(World worldIn, int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        int maxSurfaceHeight = BetterCavesUtil.getMaxSurfaceAltitudeChunk(primer);
        int minSurfaceHeight = BetterCavesUtil.getMinSurfaceAltitudeChunk(primer);
        if (worldIn.field_73011_w.getDimension() == 0) {
            for (int localX = 0; localX < 16; ++localX) {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    this.testCave.generateColumn(chunkX, chunkZ, primer, localX, localZ, 1, maxSurfaceHeight, maxSurfaceHeight, minSurfaceHeight, this.surfaceCutoff, Blocks.field_150356_k.func_176223_P());
                }
            }
        }
    }

    public void func_186125_a(World worldIn, int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        if (this.field_75039_c == null) {
            this.initialize(worldIn);
        }
        int maxSurfaceHeight = 128;
        int minSurfaceHeight = 60;
        int dimensionID = worldIn.field_73011_w.getDimension();
        boolean isWhitelisted = false;
        if (Configuration.caveSettings.enableGlobalWhitelist) {
            isWhitelisted = true;
        }
        for (int dim : Configuration.caveSettings.whitelistedDimensionIDs) {
            if (dimensionID != dim) continue;
            isWhitelisted = true;
            break;
        }
        if (!isWhitelisted) {
            this.defaultCaveGen.func_186125_a(worldIn, chunkX, chunkZ, primer);
            return;
        }
        FlattenBedrock.flattenBedrock(primer);
        for (int subX = 0; subX < 8; ++subX) {
            for (int subZ = 0; subZ < 8; ++subZ) {
                if (!Configuration.debugsettings.debugVisualizer) {
                    maxSurfaceHeight = BetterCavesUtil.getMaxSurfaceAltitudeSubChunk(primer, subX, subZ);
                }
                maxSurfaceHeight = Math.min(maxSurfaceHeight, Configuration.caveSettings.caves.maxCaveAltitude);
                for (int offsetX = 0; offsetX < 2; ++offsetX) {
                    for (int offsetZ = 0; offsetZ < 2; ++offsetZ) {
                        int cavernTopY;
                        int cavernBottomY;
                        AbstractBC cavernGen;
                        int caveBottomY;
                        AbstractBC caveGen;
                        int localX = subX * 2 + offsetX;
                        int realX = chunkX * 16 + localX;
                        int localZ = subZ * 2 + offsetZ;
                        int realZ = chunkZ * 16 + localZ;
                        float caveRegionNoise = this.caveRegionController.GetNoise(realX, realZ);
                        if (caveRegionNoise < this.cubicCaveThreshold) {
                            caveGen = this.caveCubic;
                            caveBottomY = Configuration.caveSettings.caves.cubicCave.caveBottom;
                        } else if (caveRegionNoise >= this.simplexCaveThreshold) {
                            caveGen = this.caveSimplex;
                            caveBottomY = Configuration.caveSettings.caves.simplexCave.caveBottom;
                        } else {
                            if (this.enableVanillaCaves) {
                                this.defaultCaveGen.func_186125_a(worldIn, chunkX, chunkZ, primer);
                                return;
                            }
                            caveGen = null;
                            caveBottomY = 255;
                        }
                        float cavernRegionNoise = this.cavernRegionController.GetNoise(realX, realZ);
                        float waterRegionNoise = 99.0f;
                        if (this.enableWaterRegions) {
                            waterRegionNoise = this.waterCavernController.GetNoise(realX, realZ);
                        }
                        IBlockState liquidBlock = this.lavaBlock;
                        if (waterRegionNoise < this.waterRegionThreshold) {
                            liquidBlock = this.waterBlock;
                        }
                        if (cavernRegionNoise < this.lavaCavernThreshold) {
                            cavernGen = this.enableWaterRegions && waterRegionNoise < this.waterRegionThreshold ? this.cavernWater : this.cavernLava;
                            cavernBottomY = Configuration.caveSettings.caverns.lavaCavern.caveBottom;
                            cavernTopY = Configuration.caveSettings.caverns.lavaCavern.caveTop;
                        } else if (cavernRegionNoise >= this.lavaCavernThreshold && cavernRegionNoise <= this.flooredCavernThreshold) {
                            cavernGen = caveGen;
                            cavernBottomY = caveBottomY;
                            cavernTopY = caveBottomY;
                        } else {
                            cavernGen = this.cavernFloored;
                            cavernBottomY = Configuration.caveSettings.caverns.flooredCavern.caveBottom;
                            cavernTopY = Configuration.caveSettings.caverns.flooredCavern.caveTop;
                        }
                        if (Configuration.caveSettings.caverns.enableBoundarySmoothing) {
                            float smoothAmp;
                            if (cavernRegionNoise >= this.lavaCavernThreshold && cavernRegionNoise <= this.lavaCavernThreshold + this.transitionRange) {
                                smoothAmp = Math.abs((cavernRegionNoise - (this.lavaCavernThreshold + this.transitionRange)) / this.transitionRange);
                                if (this.enableWaterRegions && waterRegionNoise < this.waterRegionThreshold) {
                                    this.cavernWater.generateColumn(chunkX, chunkZ, primer, localX, localZ, Configuration.caveSettings.caverns.lavaCavern.caveBottom, Configuration.caveSettings.caverns.lavaCavern.caveTop, maxSurfaceHeight, minSurfaceHeight, this.surfaceCutoff, liquidBlock, smoothAmp);
                                } else {
                                    this.cavernLava.generateColumn(chunkX, chunkZ, primer, localX, localZ, Configuration.caveSettings.caverns.lavaCavern.caveBottom, Configuration.caveSettings.caverns.lavaCavern.caveTop, maxSurfaceHeight, minSurfaceHeight, this.surfaceCutoff, liquidBlock, smoothAmp);
                                }
                            } else if (cavernRegionNoise <= this.flooredCavernThreshold && cavernRegionNoise >= this.flooredCavernThreshold - this.transitionRange) {
                                smoothAmp = Math.abs((cavernRegionNoise - (this.flooredCavernThreshold - this.transitionRange)) / this.transitionRange);
                                this.cavernFloored.generateColumn(chunkX, chunkZ, primer, localX, localZ, Configuration.caveSettings.caverns.flooredCavern.caveBottom, Configuration.caveSettings.caverns.flooredCavern.caveTop, maxSurfaceHeight, minSurfaceHeight, this.surfaceCutoff, liquidBlock, smoothAmp);
                            }
                        }
                        if (caveGen != null) {
                            caveGen.generateColumn(chunkX, chunkZ, primer, localX, localZ, caveBottomY, maxSurfaceHeight, maxSurfaceHeight, minSurfaceHeight, this.surfaceCutoff, liquidBlock);
                        }
                        if (cavernGen == null) continue;
                        cavernGen.generateColumn(chunkX, chunkZ, primer, localX, localZ, cavernBottomY, cavernTopY, maxSurfaceHeight, minSurfaceHeight, this.surfaceCutoff, liquidBlock);
                    }
                }
            }
        }
    }

    private float calcCubicCaveThreshold() {
        switch (Configuration.caveSettings.caves.cubicCave.caveFrequency) {
            case None: {
                return -99.0f;
            }
            case Rare: {
                return -0.6f;
            }
            case Common: {
                return -0.2f;
            }
            case Custom: {
                return -1.0f + Configuration.caveSettings.caves.cubicCave.customFrequency;
            }
        }
        return 0.0f;
    }

    private float calcSimplexCaveThreshold() {
        switch (Configuration.caveSettings.caves.simplexCave.caveFrequency) {
            case None: {
                return 99.0f;
            }
            case Rare: {
                return 0.6f;
            }
            case Common: {
                return 0.2f;
            }
            case Custom: {
                return 1.0f - Configuration.caveSettings.caves.simplexCave.customFrequency;
            }
        }
        return 0.0f;
    }

    private float calcLavaCavernThreshold() {
        switch (Configuration.caveSettings.caverns.lavaCavern.caveFrequency) {
            case None: {
                return -99.0f;
            }
            case Rare: {
                return -0.8f;
            }
            case Common: {
                return -0.3f;
            }
            case VeryCommon: {
                return -0.1f;
            }
            case Custom: {
                return -1.0f + Configuration.caveSettings.caverns.lavaCavern.customFrequency;
            }
        }
        return -0.4f;
    }

    private float calcFlooredCavernThreshold() {
        switch (Configuration.caveSettings.caverns.flooredCavern.caveFrequency) {
            case None: {
                return 99.0f;
            }
            case Rare: {
                return 0.8f;
            }
            case Common: {
                return 0.3f;
            }
            case VeryCommon: {
                return 0.1f;
            }
            case Custom: {
                return 1.0f - Configuration.caveSettings.caverns.flooredCavern.customFrequency;
            }
        }
        return 0.4f;
    }

    private float calcWaterRegionThreshold() {
        switch (Configuration.caveSettings.waterRegions.waterRegionFrequency) {
            case Rare: {
                return -0.4f;
            }
            case Common: {
                return 0.1f;
            }
            case VeryCommon: {
                return 0.3f;
            }
            case Always: {
                return 99.0f;
            }
            case Custom: {
                return 2.0f * Configuration.caveSettings.waterRegions.customFrequency - 1.0f;
            }
        }
        return -0.15f;
    }

    private void initialize(World worldIn) {
        float cavernRegionSize;
        float caveRegionSize;
        this.field_75039_c = worldIn;
        this.defaultCaveGen = new MapGenCaves();
        this.enableVanillaCaves = Configuration.caveSettings.caves.vanillaCave.enableVanillaCaves;
        this.enableWaterRegions = Configuration.caveSettings.waterRegions.enableWaterRegions;
        this.lavaCavernThreshold = this.calcLavaCavernThreshold();
        this.flooredCavernThreshold = this.calcFlooredCavernThreshold();
        this.waterRegionThreshold = this.calcWaterRegionThreshold();
        this.cubicCaveThreshold = this.calcCubicCaveThreshold();
        this.simplexCaveThreshold = this.calcSimplexCaveThreshold();
        this.surfaceCutoff = Configuration.caveSettings.caves.surfaceCutoff;
        switch (Configuration.caveSettings.caves.caveRegionSize) {
            case Small: {
                caveRegionSize = 0.007f;
                break;
            }
            case Large: {
                caveRegionSize = 0.0032f;
                break;
            }
            case ExtraLarge: {
                caveRegionSize = 0.001f;
                break;
            }
            default: {
                caveRegionSize = 0.005f;
            }
        }
        float waterCavernRegionSize = 0.003f;
        switch (Configuration.caveSettings.caverns.cavernRegionSize) {
            case Small: {
                cavernRegionSize = 0.01f;
                break;
            }
            case Large: {
                cavernRegionSize = 0.005f;
                break;
            }
            case ExtraLarge: {
                cavernRegionSize = 0.001f;
                waterCavernRegionSize = 5.0E-4f;
                break;
            }
            default: {
                cavernRegionSize = 0.007f;
            }
        }
        this.caveRegionController = new FastNoise();
        this.caveRegionController.SetSeed((int)worldIn.func_72905_C() + 222);
        this.caveRegionController.SetFrequency(caveRegionSize);
        this.caveRegionController.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.caveRegionController.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        this.cavernRegionController = new FastNoise();
        this.cavernRegionController.SetSeed((int)worldIn.func_72905_C() + 333);
        this.cavernRegionController.SetFrequency(cavernRegionSize);
        this.waterCavernController = new FastNoise();
        this.waterCavernController.SetSeed((int)worldIn.func_72905_C() + 444);
        this.waterCavernController.SetFrequency(waterCavernRegionSize);
        this.waterCavernController.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.waterCavernController.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        try {
            this.lavaBlock = Block.func_149684_b((String)Configuration.lavaBlock).func_176223_P();
            Settings.LOGGER.info("Using block '" + Configuration.lavaBlock + "' as lava in cave generation...");
        }
        catch (Exception e) {
            Settings.LOGGER.warn("Unable to use block '" + Configuration.lavaBlock + "': " + e);
            Settings.LOGGER.warn("Using vanilla lava instead...");
            this.lavaBlock = Blocks.field_150356_k.func_176223_P();
        }
        if (this.lavaBlock == null) {
            Settings.LOGGER.warn("Unable to use block '" + Configuration.lavaBlock + "': null block returned.\n Using vanilla lava instead...");
            this.lavaBlock = Blocks.field_150356_k.func_176223_P();
        }
        try {
            this.waterBlock = Block.func_149684_b((String)Configuration.waterblock).func_176223_P();
            Settings.LOGGER.info("Using block '" + Configuration.waterblock + "' as water in cave generation...");
        }
        catch (Exception e) {
            Settings.LOGGER.warn("Unable to use block '" + Configuration.waterblock + "': " + e);
            Settings.LOGGER.warn("Using vanilla water instead...");
            this.waterBlock = Blocks.field_150358_i.func_176223_P();
        }
        if (this.waterBlock == null) {
            Settings.LOGGER.warn("Unable to use block '" + Configuration.waterblock + "': null block returned.\n Using vanilla water instead...");
            this.waterBlock = Blocks.field_150358_i.func_176223_P();
        }
        this.caveCubic = new CaveBC(this.field_75039_c, CaveType.CUBIC, Configuration.caveSettings.caves.cubicCave.fractalOctaves, Configuration.caveSettings.caves.cubicCave.fractalGain, Configuration.caveSettings.caves.cubicCave.fractalFrequency, Configuration.caveSettings.caves.cubicCave.numGenerators, Configuration.caveSettings.caves.cubicCave.noiseThreshold, Configuration.caveSettings.caves.cubicCave.turbulenceOctaves, Configuration.caveSettings.caves.cubicCave.turbulenceGain, Configuration.caveSettings.caves.cubicCave.turbulenceFrequency, Configuration.caveSettings.caves.cubicCave.enableTurbulence, Configuration.caveSettings.caves.cubicCave.yCompression, Configuration.caveSettings.caves.cubicCave.xzCompression, Configuration.caveSettings.caves.cubicCave.yAdjust, Configuration.caveSettings.caves.cubicCave.yAdjustF1, Configuration.caveSettings.caves.cubicCave.yAdjustF2, Blocks.field_150344_f.func_176223_P());
        this.caveSimplex = new CaveBC(this.field_75039_c, CaveType.SIMPLEX, Configuration.caveSettings.caves.simplexCave.fractalOctaves, Configuration.caveSettings.caves.simplexCave.fractalGain, Configuration.caveSettings.caves.simplexCave.fractalFrequency, Configuration.caveSettings.caves.simplexCave.numGenerators, Configuration.caveSettings.caves.simplexCave.noiseThreshold, Configuration.caveSettings.caves.simplexCave.turbulenceOctaves, Configuration.caveSettings.caves.simplexCave.turbulenceGain, Configuration.caveSettings.caves.simplexCave.turbulenceFrequency, Configuration.caveSettings.caves.simplexCave.enableTurbulence, Configuration.caveSettings.caves.simplexCave.yCompression, Configuration.caveSettings.caves.simplexCave.xzCompression, Configuration.caveSettings.caves.simplexCave.yAdjust, Configuration.caveSettings.caves.simplexCave.yAdjustF1, Configuration.caveSettings.caves.simplexCave.yAdjustF2, Blocks.field_150347_e.func_176223_P());
        this.cavernLava = new CavernBC(this.field_75039_c, CavernType.LAVA, Configuration.caveSettings.caverns.lavaCavern.fractalOctaves, Configuration.caveSettings.caverns.lavaCavern.fractalGain, Configuration.caveSettings.caverns.lavaCavern.fractalFrequency, Configuration.caveSettings.caverns.lavaCavern.numGenerators, Configuration.caveSettings.caverns.lavaCavern.noiseThreshold, Configuration.caveSettings.caverns.lavaCavern.yCompression, Configuration.caveSettings.caverns.lavaCavern.xzCompression, Blocks.field_150451_bX.func_176223_P());
        this.cavernFloored = new CavernBC(this.field_75039_c, CavernType.FLOORED, Configuration.caveSettings.caverns.flooredCavern.fractalOctaves, Configuration.caveSettings.caverns.flooredCavern.fractalGain, Configuration.caveSettings.caverns.flooredCavern.fractalFrequency, Configuration.caveSettings.caverns.flooredCavern.numGenerators, Configuration.caveSettings.caverns.flooredCavern.noiseThreshold, Configuration.caveSettings.caverns.flooredCavern.yCompression, Configuration.caveSettings.caverns.flooredCavern.xzCompression, Blocks.field_150340_R.func_176223_P());
        this.cavernWater = new CavernBC(this.field_75039_c, CavernType.WATER, Configuration.caveSettings.waterRegions.waterCavern.fractalOctaves, Configuration.caveSettings.waterRegions.waterCavern.fractalGain, Configuration.caveSettings.waterRegions.waterCavern.fractalFrequency, Configuration.caveSettings.waterRegions.waterCavern.numGenerators, Configuration.caveSettings.waterRegions.waterCavern.noiseThreshold, Configuration.caveSettings.waterRegions.waterCavern.yCompression, Configuration.caveSettings.waterRegions.waterCavern.xzCompression, Blocks.field_150368_y.func_176223_P());
        this.testCave = new TestCave(this.field_75039_c, Configuration.testSettings.fractalOctaves, Configuration.testSettings.fractalGain, Configuration.testSettings.fractalFrequency, Configuration.testSettings.numGenerators, Configuration.testSettings.noiseThreshold, Configuration.testSettings.turbulenceOctaves, Configuration.testSettings.turbulenceGain, Configuration.testSettings.turbulenceFrequency, Configuration.testSettings.enableTurbulence, Configuration.testSettings.yCompression, Configuration.testSettings.xzCompression, Configuration.testSettings.yAdjust, Configuration.testSettings.yAdjustF1, Configuration.testSettings.yAdjustF2);
    }
}

