/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.util;

import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BetterCavesUtil {
    private static final IBlockState BLOCKSTATE_AIR = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState BLOCKSTATE_LAVA = Blocks.field_150353_l.func_176223_P();
    private static final IBlockState BLOCKSTATE_SAND = Blocks.field_150354_m.func_176223_P();
    private static final IBlockState BLOCKSTATE_SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private static final IBlockState BLOCKSTATE_REDSANDSTONE = Blocks.field_180395_cM.func_176223_P();

    private BetterCavesUtil() {
    }

    public static boolean isTopBlock(World world, ChunkPrimer primer, int localX, int y, int localZ, int chunkX, int chunkZ) {
        int realX = chunkX * 16 + localX;
        int realZ = chunkZ * 16 + localZ;
        Biome biome = world.func_180494_b(new BlockPos(realX, y, realZ));
        IBlockState blockState = primer.func_177856_a(localX, y, localZ);
        return blockState == biome.field_76752_A;
    }

    public static void digBlock(World world, ChunkPrimer primer, IBlockState lavaBlockState, int localX, int y, int localZ, int chunkX, int chunkZ) {
        IBlockState blockState = primer.func_177856_a(localX, y, localZ);
        IBlockState blockStateAbove = primer.func_177856_a(localX, y + 1, localZ);
        int realX = chunkX * 16 + localX;
        int realZ = chunkZ * 16 + localZ;
        Biome biome = world.func_180494_b(new BlockPos(realX, y, realZ));
        Block biomeTopBlock = biome.field_76752_A.func_177230_c();
        Block biomeFillerBlock = biome.field_76753_B.func_177230_c();
        if (BetterCavesUtil.canReplaceBlock(blockState, blockStateAbove) || blockState.func_177230_c() == biomeTopBlock || blockState.func_177230_c() == biomeFillerBlock) {
            if (y <= Configuration.lavaDepth) {
                primer.func_177855_a(localX, y, localZ, lavaBlockState);
            } else {
                if (BetterCavesUtil.isTopBlock(world, primer, localX, y, localZ, chunkX, chunkZ) && BetterCavesUtil.canReplaceBlock(primer.func_177856_a(localX, y - 1, localZ), BLOCKSTATE_AIR)) {
                    primer.func_177855_a(localX, y - 1, localZ, biome.field_76752_A);
                }
                primer.func_177855_a(localX, y, localZ, BLOCKSTATE_AIR);
                if (blockStateAbove == BLOCKSTATE_SAND) {
                    primer.func_177855_a(localX, y + 1, localZ, BLOCKSTATE_SANDSTONE);
                } else if (blockStateAbove == BLOCKSTATE_SAND.func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND)) {
                    primer.func_177855_a(localX, y + 1, localZ, BLOCKSTATE_REDSANDSTONE);
                }
            }
        }
    }

    public static void digBlock(World world, ChunkPrimer primer, int localX, int y, int localZ, int chunkX, int chunkZ) {
        BetterCavesUtil.digBlock(world, primer, BLOCKSTATE_LAVA, localX, y, localZ, chunkX, chunkZ);
    }

    public static boolean canReplaceBlock(IBlockState blockState, IBlockState blockStateAbove) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
            return false;
        }
        if (blockStateAbove == Blocks.field_150364_r.func_176223_P() || blockStateAbove == Blocks.field_150363_s.func_176223_P()) {
            return false;
        }
        if (blockState == Blocks.field_150357_h.func_176223_P()) {
            return false;
        }
        if (blockState.func_185904_a() == Material.field_151576_e) {
            return true;
        }
        if (block == Blocks.field_150348_b || block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce || block == Blocks.field_150322_A || block == Blocks.field_180395_cM || block == Blocks.field_150391_bh || block == Blocks.field_150431_aC) {
            return true;
        }
        return (block == Blocks.field_150354_m || block == Blocks.field_150351_n) && blockStateAbove.func_185904_a() != Material.field_151586_h;
    }

    public static int getMaxSurfaceAltitudeChunk(ChunkPrimer primer) {
        int[] testCoords;
        int maxHeight = 0;
        for (int x : testCoords = new int[]{0, 7, 15}) {
            for (int z : testCoords) {
                maxHeight = Math.max(maxHeight, BetterCavesUtil.getSurfaceAltitudeForColumn(primer, x, z));
            }
        }
        return maxHeight;
    }

    public static int getMinSurfaceAltitudeChunk(ChunkPrimer primer) {
        int[] testCoords;
        int minHeight = 256;
        for (int x : testCoords = new int[]{0, 7, 15}) {
            for (int z : testCoords) {
                minHeight = Math.min(minHeight, BetterCavesUtil.getSurfaceAltitudeForColumn(primer, x, z));
            }
        }
        return minHeight;
    }

    public static int getMaxSurfaceAltitudeSubChunk(ChunkPrimer primer, int subX, int subZ) {
        int[] testCoords;
        int maxHeight = 0;
        for (int x : testCoords = new int[]{0, 1}) {
            for (int z : testCoords) {
                maxHeight = Math.max(maxHeight, BetterCavesUtil.getSurfaceAltitudeForColumn(primer, subX * 2 + x, subZ * 2 + z));
            }
        }
        return maxHeight;
    }

    public static int getSurfaceAltitudeForColumn(ChunkPrimer primer, int localX, int localZ) {
        return BetterCavesUtil.searchSurfaceAltitudeInRangeForColumn(primer, localX, localZ, 255, 0);
    }

    public static int searchSurfaceAltitudeInRangeForColumn(ChunkPrimer primer, int localX, int localZ, int topY, int bottomY) {
        if (topY == 255 && primer.func_177856_a(localX, 255, localZ) != Blocks.field_150350_a.func_176223_P() && primer.func_177856_a(localX, 255, localZ).func_185904_a() != Material.field_151586_h) {
            return 255;
        }
        for (int y = bottomY; y <= topY; ++y) {
            if (primer.func_177856_a(localX, y, localZ) != Blocks.field_150350_a.func_176223_P() && primer.func_177856_a(localX, y, localZ).func_185904_a() != Material.field_151586_h) continue;
            return y;
        }
        return -1;
    }
}

