/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.noise;

import java.util.ArrayList;
import java.util.List;

public class NoiseTuple {
    private List<Float> noiseValues = new ArrayList<Float>();
    private int length = 0;

    public NoiseTuple(float ... vals) {
        for (float val : vals) {
            this.noiseValues.add(Float.valueOf(val));
            ++this.length;
        }
    }

    public void put(float val) {
        this.noiseValues.add(Float.valueOf(val));
        ++this.length;
    }

    public float get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("No corresponding noise value in Noise Tuple for index: " + index);
        }
        return this.noiseValues.get(index).floatValue();
    }

    public void set(int index, float newValue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("No corresponding noise value in Noise Tuple for index: " + index);
        }
        this.noiseValues.set(index, Float.valueOf(newValue));
    }

    public List<Float> getNoiseValues() {
        return this.noiseValues;
    }

    public int size() {
        return this.length;
    }
}

