/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.noise;

import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseTuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.world.World;

public class NoiseGen {
    private long seed;
    private FastNoise.NoiseType noiseType;
    private int fractalOctaves;
    private float fractalGain;
    private float fractalFrequency;
    private int turbulenceOctaves;
    private float turbulenceGain;
    private float turbulenceFrequency;
    private boolean enableTurbulence;
    private float yCompression;
    private float xzCompression;
    private List<FastNoise> listNoiseGens = new ArrayList<FastNoise>();
    private FastNoise turbulenceGen = new FastNoise();

    public NoiseGen(FastNoise.NoiseType noiseType, World world, int fOctaves, float fGain, float fFreq, int tOctaves, float tGain, float tFreq, boolean useTurb, float yComp, float xzComp) {
        this.noiseType = noiseType;
        this.seed = world.func_72905_C();
        this.fractalOctaves = fOctaves;
        this.fractalGain = fGain;
        this.fractalFrequency = fFreq;
        this.turbulenceOctaves = tOctaves;
        this.turbulenceGain = tGain;
        this.turbulenceFrequency = tFreq;
        this.enableTurbulence = useTurb;
        this.yCompression = yComp;
        this.xzCompression = xzComp;
        this.initializeTurbulenceGen();
    }

    public Map<Integer, NoiseTuple> generateNoiseCol(int chunkX, int chunkZ, int minHeight, int maxHeight, int numGenerators, int localX, int localZ) {
        this.initializeNoiseGens(numGenerators);
        HashMap<Integer, NoiseTuple> altitudeToNoiseMap = new HashMap<Integer, NoiseTuple>();
        for (int y = minHeight; y <= maxHeight; ++y) {
            int realX = localX + 16 * chunkX;
            int realZ = localZ + 16 * chunkZ;
            Vector3f f = new Vector3f((float)realX * this.xzCompression, (float)y * this.yCompression, (float)realZ * this.xzCompression);
            if (this.enableTurbulence) {
                this.turbulenceGen.GradientPerturbFractal(f);
            }
            NoiseTuple newTuple = new NoiseTuple(new float[0]);
            for (int i = 0; i < numGenerators; ++i) {
                newTuple.put(this.listNoiseGens.get(i).GetNoise(f.x, f.y, f.z));
            }
            altitudeToNoiseMap.put(y, newTuple);
        }
        return altitudeToNoiseMap;
    }

    public long getSeed() {
        return this.seed;
    }

    public FastNoise.NoiseType getNoiseType() {
        return this.noiseType;
    }

    private void initializeNoiseGens(int numGenerators) {
        if (numGenerators <= this.listNoiseGens.size()) {
            return;
        }
        int numGensNeeded = numGenerators - this.listNoiseGens.size();
        int seedModifier = this.listNoiseGens.size();
        for (int i = 0; i < numGensNeeded; ++i) {
            FastNoise noiseGen = new FastNoise();
            noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            noiseGen.SetSeed((int)this.seed + 1111 * seedModifier);
            noiseGen.SetNoiseType(this.noiseType);
            noiseGen.SetFractalOctaves(this.fractalOctaves);
            noiseGen.SetFractalGain(this.fractalGain);
            noiseGen.SetFrequency(this.fractalFrequency);
            this.listNoiseGens.add(noiseGen);
            ++seedModifier;
        }
    }

    private void initializeTurbulenceGen() {
        this.turbulenceGen.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
        this.turbulenceGen.SetFractalType(FastNoise.FractalType.FBM);
        this.turbulenceGen.SetSeed((int)this.seed + 69);
        this.turbulenceGen.SetFractalOctaves(this.turbulenceOctaves);
        this.turbulenceGen.SetFractalGain(this.turbulenceGain);
        this.turbulenceGen.SetFrequency(this.turbulenceFrequency);
    }
}

