/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cavern;

import com.yungnickyoung.minecraft.bettercaves.enums.CavernFrequency;
import net.minecraftforge.common.config.Config;

public class ConfigFlooredCavern {
    @Config.Name(value="Cavern Top Altitude")
    @Config.Comment(value={"The top cutoff y-coordinate of Floored Caverns. Note that caverns will attempt to close off anyway if this value is greater than the surface y-coordinate."})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int caveTop = 30;
    @Config.Name(value="Cavern Bottom Altitude")
    @Config.Comment(value={"The bottom cutoff y-coordinate at which Floored Caverns stop generating."})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int caveBottom = 1;
    @Config.Name(value="Floored Cavern Frequency")
    @Config.Comment(value={"Determines how frequently Floored Caverns spawn."})
    @Config.RequiresWorldRestart
    public CavernFrequency caveFrequency = CavernFrequency.Normal;
    @Config.Name(value="Floored Cavern Frequency Custom Value")
    @Config.Comment(value={"Custom value for cavern frequency. Only works if Floored Cavern Frequency is set to Custom. 0 = 0% chance of spawning, 1.0 = 50% chance of spawning (which is the max value). The value does not scale linearly. \nProvided values:\nNone: 0\nRare: 0.2\nNormal: 0.6\nCommon: 0.7\nVeryCommon: 0.9"})
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.RequiresWorldRestart
    public float customFrequency = 1.0f;
    @Config.Name(value="Compression - Vertical")
    @Config.Comment(value={"Changes height of formations in caverns. Lower value = more open caverns with larger features."})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float yCompression = 1.0f;
    @Config.Name(value="Compression - Horizontal")
    @Config.Comment(value={"Changes width of formations in caverns. Lower value = more open caverns with larger features."})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float xzCompression = 1.0f;
    @Config.Ignore
    @Config.Name(value="Noise Threshold")
    @Config.Comment(value={"Threshold for determining which blocks get mined out as part of cave generation. Higher value = less caves."})
    @Config.RangeDouble(min=-1.0, max=1.0)
    @Config.RequiresWorldRestart
    public float noiseThreshold = 0.7f;
    @Config.Ignore
    @Config.Name(value="Fractal Octaves")
    @Config.Comment(value={"The number of octaves used for ridged multi-fractal noise generation."})
    @Config.RequiresWorldRestart
    public int fractalOctaves = 1;
    @Config.Ignore
    @Config.Name(value="Fractal Gain")
    @Config.Comment(value={"The gain for ridged multi-fractal noise generation."})
    @Config.RequiresWorldRestart
    public float fractalGain = 0.3f;
    @Config.Ignore
    @Config.Name(value="Fractal Frequency")
    @Config.Comment(value={"The frequency for ridged multi-fractal noise generation."})
    @Config.RequiresWorldRestart
    public float fractalFrequency = 0.03f;
    @Config.Ignore
    @Config.Name(value="Number of Generators")
    @Config.Comment(value={"The number of noise generation functions used. The intersection of these functions isused to calculate a single noise value."})
    @Config.RequiresWorldRestart
    public int numGenerators = 2;
}

