/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cave;

import com.yungnickyoung.minecraft.bettercaves.enums.WaterRegionFrequency;
import net.minecraftforge.common.config.Config;

public class ConfigWaterRegions {
    @Config.Name(value="Enable Water Regions")
    @Config.Comment(value={"Set to true for caves & caverns to have a chance of spawning as their water-based variants, instead of having lava"})
    @Config.RequiresWorldRestart
    public boolean enableWaterRegions = true;
    @Config.Name(value="Water Caverns")
    @Config.Comment(value={"Settings for Water Caverns (similar in structure to Lava Caverns)."})
    @Config.RequiresWorldRestart
    public WaterCavern waterCavern = new WaterCavern();
    @Config.Name(value="Water Region Frequency")
    @Config.Comment(value={"Determines how frequently water regions spawn. Only has an effect if Enable Water Regions is true."})
    @Config.RequiresWorldRestart
    public WaterRegionFrequency waterRegionFrequency = WaterRegionFrequency.Normal;
    @Config.Name(value="Water Region Frequency Custom Value")
    @Config.Comment(value={"Custom value for water region frequency. Only works if Water Region Frequency is set to Custom. 0 = 0% chance of spawning, 1.0 = 100% chance of spawning. The value may not scale linearly. \nProvided values:\nRare: 0.3\nNormal: 0.425\nCommon: 0.55\nVeryCommon: 0.65\nAlways: 1.0"})
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.RequiresWorldRestart
    public float customFrequency = 1.0f;

    public static class WaterCavern {
        @Config.Name(value="Vertical Compression")
        @Config.Comment(value={"Changes height of formations in caverns. Lower value = more open caverns with larger features."})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresWorldRestart
        public float yCompression = 1.0f;
        @Config.Name(value="Horizontal Compression")
        @Config.Comment(value={"Changes width of formations in caverns. Lower value = more open caverns with larger features."})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresWorldRestart
        public float xzCompression = 1.0f;
        @Config.Ignore
        @Config.Name(value="Noise Threshold")
        @Config.Comment(value={"Threshold for determining which blocks get mined out as part of cave generation. Higher value = less caves."})
        @Config.RangeDouble(min=-1.0, max=1.0)
        @Config.RequiresWorldRestart
        public float noiseThreshold = 0.75f;
        @Config.Ignore
        @Config.Name(value="Fractal Octaves")
        @Config.Comment(value={"The number of octaves used for ridged multi-fractal noise generation."})
        @Config.RequiresWorldRestart
        public int fractalOctaves = 1;
        @Config.Ignore
        @Config.Name(value="Fractal Gain")
        @Config.Comment(value={"The gain for ridged multi-fractal noise generation."})
        @Config.RequiresWorldRestart
        public float fractalGain = 0.3f;
        @Config.Ignore
        @Config.Name(value="Fractal Frequency")
        @Config.Comment(value={"The frequency for ridged multi-fractal noise generation."})
        @Config.RequiresWorldRestart
        public float fractalFrequency = 0.03f;
        @Config.Ignore
        @Config.Name(value="Number of Generators")
        @Config.Comment(value={"The number of noise generation functions used. The intersection of these functions isused to calculate a single noise value."})
        @Config.RequiresWorldRestart
        public int numGenerators = 2;
    }
}

