/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cave;

import com.yungnickyoung.minecraft.bettercaves.enums.CaveFrequency;
import net.minecraftforge.common.config.Config;

public class ConfigCubicCave {
    @Config.Name(value="Cave Bottom Altitude")
    @Config.Comment(value={"The minimum y-coordinate at which caves start generating."})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int caveBottom = 1;
    @Config.Name(value="Compression - Vertical")
    @Config.Comment(value={"Changes height of caves. Lower value = taller caves with steeper drops."})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float yCompression = 3.0f;
    @Config.Name(value="Compression - Horizontal")
    @Config.Comment(value={"Changes width of caves. Lower value = wider caves."})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float xzCompression = 1.0f;
    @Config.Name(value="Type 1 Cave Frequency")
    @Config.Comment(value={"Determines how frequently Type 1 Caves spawn. If this is anything but VeryCommon (the default), vanilla caves will replace some of the areas where Type 1 Caves would have generated. However, if vanilla caves are disabled, then these areas will instead not have any caves at all."})
    @Config.RequiresWorldRestart
    public CaveFrequency caveFrequency = CaveFrequency.VeryCommon;
    @Config.Name(value="Type 1 Cave Frequency Custom Value")
    @Config.Comment(value={"Custom value for cave frequency. Only works if Type 1 Cave Frequency is set to Custom. 0 = 0% chance of spawning, 1.0 = 50% chance of spawning (which is the max value). The value may not scale linearly. \nProvided values:\nNone: 0\nRare: 0.4\nCommon: 0.8\nVeryCommon: 1.0"})
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.RequiresWorldRestart
    public float customFrequency = 1.0f;
    @Config.Ignore
    @Config.Name(value="Noise Threshold")
    @Config.Comment(value={"Threshold for determining which blocks get mined out as part of cave generation. Higher value = less caves."})
    @Config.RangeDouble(min=-1.0, max=1.0)
    @Config.RequiresWorldRestart
    public float noiseThreshold = 0.95f;
    @Config.Ignore
    @Config.Name(value="Fractal Octaves")
    @Config.Comment(value={"The number of octaves used for ridged multi-fractal noise generation."})
    @Config.RequiresWorldRestart
    public int fractalOctaves = 1;
    @Config.Ignore
    @Config.Name(value="Fractal Gain")
    @Config.Comment(value={"The gain for ridged multi-fractal noise generation."})
    @Config.RequiresWorldRestart
    public float fractalGain = 0.3f;
    @Config.Ignore
    @Config.Name(value="Fractal Frequency")
    @Config.Comment(value={"The frequency for ridged multi-fractal noise generation. This determines how spread out or tightly knit cave systems are."})
    @Config.RequiresWorldRestart
    public float fractalFrequency = 0.03f;
    @Config.Ignore
    @Config.Name(value="Use Turbulence")
    @Config.Comment(value={"Enable to apply turbulence. Turbulence will add some more random variation to cave structure. Will negatively impact performance and probably not do much anyway."})
    @Config.RequiresWorldRestart
    public boolean enableTurbulence = false;
    @Config.Ignore
    @Config.Name(value="Turbulence Octaves")
    @Config.Comment(value={"The number of octaves used for the fBM turbulence function."})
    @Config.RequiresWorldRestart
    public int turbulenceOctaves = 3;
    @Config.Ignore
    @Config.Name(value="Turbulence Gain")
    @Config.Comment(value={"The gain for the fBM turbulence function."})
    @Config.RequiresWorldRestart
    public float turbulenceGain = 45.0f;
    @Config.Ignore
    @Config.Name(value="Turbulence Frequency")
    @Config.Comment(value={"The frequency for the fBM turbulence function."})
    @Config.RequiresWorldRestart
    public float turbulenceFrequency = 0.01f;
    @Config.Ignore
    @Config.Name(value="Number of Generators")
    @Config.Comment(value={"The number of noise generation functions used. The intersection of these functions isused to calculate a single noise value."})
    @Config.RequiresWorldRestart
    public int numGenerators = 2;
    @Config.Ignore
    @Config.Name(value="Enable y-adjustment")
    @Config.Comment(value={"Enable y-adjustment, giving players more headroom in caves."})
    public boolean yAdjust = true;
    @Config.Ignore
    @Config.Name(value="y-adjustment Variable 1")
    @Config.Comment(value={"Factor affecting the block immediately above a given block."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public float yAdjustF1 = 0.9f;
    @Config.Ignore
    @Config.Name(value="y-adjustment Variable 2")
    @Config.Comment(value={"Factor affecting the block two blocks above a given block."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public float yAdjustF2 = 0.8f;
}

