/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.spider;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.spider.Entity_SpecialSpider;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityWebSpider
extends Entity_SpecialSpider {
    private static final String TAG_WEB_COUNT = "WebCount";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityWebSpider.GET_TEXTURE_PATH("web")), new ResourceLocation(EntityWebSpider.GET_TEXTURE_PATH("web_eyes"))};
    public static ResourceLocation LOOT_TABLE;
    private int webCount;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0xE7E7E7);
        info.weight = 50;
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_FOREST;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityWebSpider.ADD_BASE_LOOT(loot);
        loot.addUncommonDrop("uncommon", "Cobwebs", Blocks.field_150321_G);
    }

    public EntityWebSpider(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void applyTypeAttributes() {
        this.webCount = this.field_70146_Z.nextInt(5) + 2;
        ++this.field_70728_aV;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.2);
    }

    @Override
    public void onTypeAttack(Entity target) {
        BlockPos pos;
        boolean placed;
        if (!this.field_70170_p.field_72995_K && this.webCount > 0 && !(target instanceof EntitySpider) && target instanceof EntityLivingBase && !(placed = this.tryPlaceWeb(pos = new BlockPos(target))) && target.field_70131_O > 1.0f) {
            this.tryPlaceWeb(pos.func_177982_a(0, 1, 0));
        }
    }

    private boolean tryPlaceWeb(BlockPos pos) {
        IBlockState block = this.field_70170_p.func_180495_p(pos);
        if (block.func_177230_c().isAir(block, (IBlockAccess)this.field_70170_p, pos) || block.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
            this.field_70170_p.func_180501_a(pos, Blocks.field_150321_G.func_176223_P(), 2);
            --this.webCount;
            return true;
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_WEB_COUNT, (byte)this.webCount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_WEB_COUNT, 99)) {
            this.webCount = saveTag.func_74771_c(TAG_WEB_COUNT);
        }
    }
}

