/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.projectile;

import fathertoast.specialmobs.ai.IAngler;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.SpecialMobData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpecialFishHook
extends Entity {
    private static final DataParameter<Integer> ANGLER_ID = EntityDataManager.func_187226_a(EntitySpecialFishHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLiving angler;
    private final int maxLifetime;

    public EntitySpecialFishHook(World world) {
        super(world);
        this.maxLifetime = 60;
    }

    public EntitySpecialFishHook(World world, EntityLiving entity, Entity target) {
        super(world);
        this.setAngler(entity);
        ((IAngler)entity).setFishHook(this);
        SpecialMobData data = ((ISpecialMob)entity).getSpecialData();
        this.maxLifetime = Math.max(data.rangedAttackMaxCooldown, 30);
        this.func_70012_b(entity.field_70165_t - (double)MathHelper.func_76126_a((float)(entity.field_70177_z * (float)Math.PI / 180.0f)) * 0.3, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v + (double)MathHelper.func_76134_b((float)(entity.field_70177_z * (float)Math.PI / 180.0f)) * 0.3, entity.field_70177_z, entity.field_70125_A);
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u;
        double dZ = target.field_70161_v - this.field_70161_v;
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        this.shoot(dX, dY + dH * 0.2, dZ, 1.0f, data.rangedAttackSpread);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ANGLER_ID, (Object)0);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
    }

    public EntityLiving getAngler() {
        Entity entity;
        int anglerId;
        if (this.angler == null && (anglerId = ((Integer)this.func_184212_Q().func_187225_a(ANGLER_ID)).intValue()) > 0 && (entity = this.field_70170_p.func_73045_a(anglerId - 1)) instanceof EntityLiving) {
            this.angler = (EntityLiving)entity;
        }
        return this.angler;
    }

    public void setAngler(EntityLiving entity) {
        this.angler = entity;
        if (this.angler == null) {
            this.func_184212_Q().func_187227_b(ANGLER_ID, (Object)0);
        } else {
            this.func_184212_Q().func_187227_b(ANGLER_ID, (Object)(this.angler.func_145782_y() + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distanceSq) {
        return distanceSq < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void shoot(double dX, double dY, double dZ, float velocity, float variance) {
        this.shoot(new Vec3d(dX, dY, dZ).func_72432_b(), velocity, variance);
    }

    public void shoot(Vec3d direction, float velocity, float variance) {
        Vec3d motion = direction.func_178787_e(new Vec3d(this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian()).func_186678_a((double)variance * 0.0075)).func_186678_a((double)velocity);
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        float motionH = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)motionH) * 180.0 / Math.PI);
    }

    public void func_70016_h(double vX, double vY, double vZ) {
        this.field_70159_w = vX;
        this.field_70181_x = vY;
        this.field_70179_y = vZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa < this.maxLifetime && this.getAngler() != null && (this.field_70170_p.field_72995_K || !this.getAngler().field_70128_L && this.getAngler().func_70089_S() && this.func_70068_e((Entity)this.getAngler()) <= 2304.0)) {
            if (!this.field_70170_p.field_72995_K) {
                this.checkCollision();
            }
            this.field_70181_x -= 0.03;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            double accelFactor = 0.92;
            this.field_70159_w *= accelFactor;
            this.field_70181_x *= accelFactor;
            this.field_70179_y *= accelFactor;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
    }

    private void checkCollision() {
        Vec3d pos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPos = pos.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        RayTraceResult hit = this.field_70170_p.func_147447_a(pos, nextPos, false, true, false);
        if (hit != null) {
            nextPos = hit.field_72307_f;
        }
        Entity closestEntityHit = null;
        double closestDistanceSq = Double.POSITIVE_INFINITY;
        List entitiesHit = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        for (Entity entityHit : entitiesHit) {
            double distanceSq;
            AxisAlignedBB boundingBox;
            RayTraceResult boundingBoxCollision;
            if ((entityHit == null || entityHit == this.getAngler() || !entityHit.func_70067_L()) && !(entityHit instanceof EntityItem) || (boundingBoxCollision = (boundingBox = entityHit.func_174813_aQ().func_186662_g(0.3)).func_72327_a(pos, nextPos)) == null || !((distanceSq = pos.func_72436_e(boundingBoxCollision.field_72307_f)) < closestDistanceSq)) continue;
            closestEntityHit = entityHit;
            closestDistanceSq = distanceSq;
        }
        if (closestEntityHit != null) {
            hit = new RayTraceResult(closestEntityHit);
        }
        if (hit != null) {
            this.onImpact(hit);
        }
    }

    private void onImpact(RayTraceResult hit) {
        if (hit.field_72313_a == RayTraceResult.Type.ENTITY && hit.field_72308_g != null && this.getAngler() != null) {
            this.func_184185_a(SoundEvents.field_193780_J, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            Vec3d pullVec = new Vec3d(this.getAngler().field_70165_t - this.field_70165_t, this.getAngler().field_70163_u + (double)this.getAngler().func_70047_e() - this.field_70163_u, this.getAngler().field_70161_v - this.field_70161_v);
            double distance = pullVec.func_72433_c();
            pullVec = pullVec.func_186678_a(0.42);
            hit.field_72308_g.field_70159_w = pullVec.field_72450_a;
            hit.field_72308_g.field_70181_x = pullVec.field_72448_b + Math.sqrt(distance) * 0.1;
            hit.field_72308_g.field_70179_y = pullVec.field_72449_c;
            hit.field_72308_g.field_70122_E = false;
            if (hit.field_72308_g instanceof EntityPlayerMP) {
                try {
                    ((EntityPlayerMP)hit.field_72308_g).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(hit.field_72308_g));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.func_70106_y();
    }

    private void updateRotation() {
        float vH = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)vH) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.getAngler() != null) {
            ((IAngler)this.getAngler()).setFishHook(null);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70037_a(NBTTagCompound tag) {
    }
}

