/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity;

import fathertoast.specialmobs.MessageTexture;
import fathertoast.specialmobs.SpecialMobsMod;
import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.entity.ISpecialMob;
import java.util.HashSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpecialMobData<T extends EntityLiving> {
    private static final String TAG_RENDER_SCALE = "RenderScale";
    private static final String TAG_EXPERIENCE = "Experience";
    private static final String TAG_REGENERATION = "Regeneration";
    private static final String TAG_TEXTURE = "Texture";
    private static final String TAG_TEXTURE_EYES = "TextureEyes";
    private static final String TAG_TEXTURE_OVER = "TextureOverlay";
    private static final String TAG_ARROW_DAMAGE = "ArrowDamage";
    private static final String TAG_ARROW_SPREAD = "ArrowSpread";
    private static final String TAG_ARROW_WALK_SPEED = "ArrowWalkSpeed";
    private static final String TAG_ARROW_REFIRE_MIN = "ArrowRefireMin";
    private static final String TAG_ARROW_REFIRE_MAX = "ArrowRefireMax";
    private static final String TAG_ARROW_RANGE = "ArrowRange";
    private static final String TAG_FALL_MULTI = "FallMulti";
    private static final String TAG_FIRE_IMMUNE = "FireImmune";
    private static final String TAG_BURN_IMMUNE = "BurningImmune";
    private static final String TAG_LEASHABLE = "Leashable";
    private static final String TAG_WEB_IMMUNE = "WebImmune";
    private static final String TAG_TRAP_IMMUNE = "UnderPressure";
    private static final String TAG_DROWN_IMMUNE = "DrownImmune";
    private static final String TAG_WATER_PUSH_IMMUNE = "WaterPushImmune";
    private static final String TAG_WATER_DAMAGE = "WaterDamage";
    private static final String TAG_POTION_IMMUNE = "PotionImmune";
    public static final int NBT_TYPE_PRIMITIVE = 99;
    private final T theEntity;
    private final DataParameter<Float> renderScale;
    private final float familyScale;
    private float baseScale;
    private ResourceLocation texture;
    private ResourceLocation textureEyes;
    private ResourceLocation textureOverlay;
    private boolean updateTextures;
    public float rangedAttackDamage;
    public float rangedAttackSpread;
    public float rangedWalkSpeed = 1.0f;
    public int rangedAttackCooldown;
    public int rangedAttackMaxCooldown;
    public float rangedAttackMaxRange;
    private int healTimeMax;
    private int healTime;
    private float fallDamageMultiplier = 1.0f;
    private boolean isImmuneToBurning;
    private boolean allowLeashing;
    private boolean isImmuneToWebs;
    private boolean ignorePressurePlates;
    private boolean canBreatheInWater;
    private boolean ignoreWaterPush;
    private boolean isDamagedByWater;
    private HashSet<String> immuneToPotions = new HashSet();

    public static NBTTagCompound getSaveLocation(NBTTagCompound tag) {
        String TAG_FORGE = "ForgeData";
        String TAG_MOD = "SpecialMobsData";
        if (!tag.func_150297_b("ForgeData", (int)tag.func_74732_a())) {
            tag.func_74782_a("ForgeData", (NBTBase)new NBTTagCompound());
        }
        if (!(tag = tag.func_74775_l("ForgeData")).func_150297_b("SpecialMobsData", (int)tag.func_74732_a())) {
            tag.func_74782_a("SpecialMobsData", (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l("SpecialMobsData");
    }

    public SpecialMobData(T entity, DataParameter<Float> scale) {
        this(entity, scale, 1.0f);
    }

    public SpecialMobData(T entity, DataParameter<Float> scale, float familyBaseScale) {
        this.theEntity = entity;
        this.renderScale = scale;
        this.familyScale = this.baseScale = familyBaseScale;
        this.setTextures(((ISpecialMob)entity).getDefaultTextures());
        this.theEntity.func_184212_Q().func_187214_a(this.renderScale, (Object)Float.valueOf(this.nextScale()));
        if (entity.func_70662_br()) {
            this.addPotionImmunity(MobEffects.field_76428_l, MobEffects.field_76436_u);
        }
        if (entity instanceof EntitySpider) {
            this.setImmuneToWebs(true);
            this.addPotionImmunity(MobEffects.field_76436_u);
        }
    }

    public void copyDataFrom(EntityLiving entity, boolean copyTextures) {
        if (entity instanceof ISpecialMob) {
            NBTTagCompound tag = new NBTTagCompound();
            ((ISpecialMob)entity).getSpecialData().writeToNBT(tag);
            if (!copyTextures) {
                tag.func_82580_o(TAG_TEXTURE);
                tag.func_82580_o(TAG_TEXTURE_EYES);
                tag.func_82580_o(TAG_TEXTURE_OVER);
            }
            this.readFromNBT(tag);
        }
    }

    public void onUpdate() {
        if (this.updateTextures && !((EntityLiving)this.theEntity).field_70170_p.field_72995_K && ((EntityLiving)this.theEntity).field_70173_aa > 1) {
            this.updateTextures = false;
            SpecialMobsMod.network().sendToDimension((IMessage)new MessageTexture((Entity)this.theEntity), ((EntityLiving)this.theEntity).field_71093_bK);
        }
        if (this.healTimeMax > 0 && ++this.healTime >= this.healTimeMax) {
            this.healTime = 0;
            this.theEntity.func_70691_i(1.0f);
        }
        if (this.isDamagedByWater() && this.theEntity.func_70026_G()) {
            this.theEntity.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public void addAttribute(IAttribute attribute, double amount) {
        this.theEntity.func_110148_a(attribute).func_111128_a(this.theEntity.func_110148_a(attribute).func_111126_e() + amount);
    }

    public void multAttribute(IAttribute attribute, double amount) {
        this.theEntity.func_110148_a(attribute).func_111128_a(this.theEntity.func_110148_a(attribute).func_111126_e() * amount);
    }

    public void addPotionImmunity(Potion ... potions) {
        for (Potion potion : potions) {
            this.immuneToPotions.add(potion.func_76393_a());
        }
    }

    public boolean hasEyesTexture() {
        return this.textureEyes != null;
    }

    public boolean hasOverlayTexture() {
        return this.textureOverlay != null;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation getTextureEyes() {
        return this.textureEyes;
    }

    public ResourceLocation getTextureOverlay() {
        return this.textureOverlay;
    }

    private void setTextures(ResourceLocation[] textures) {
        this.texture = textures[0];
        if (textures.length > 1) {
            this.textureEyes = textures[1];
        }
        if (textures.length > 2) {
            this.textureOverlay = textures[2];
        }
    }

    public void loadTextures(String[] textures) {
        try {
            this.loadTexture(textures[0]);
            this.loadTextureEyes(textures.length > 1 ? textures[1] : "");
            this.loadTextureOverlay(textures.length > 2 ? textures[2] : "");
        }
        catch (Exception ex) {
            SpecialMobsMod.log().warn("Failed to load textures for {}! ({})", this.theEntity, (Object)textures);
        }
    }

    private void loadTexture(String tex) {
        if (tex.isEmpty()) {
            throw new IllegalArgumentException("Entity must have a base texture");
        }
        ResourceLocation newTexture = new ResourceLocation(tex);
        if (!newTexture.toString().equals(this.texture.toString())) {
            this.texture = newTexture;
            this.updateTextures = true;
        }
    }

    private void loadTextureEyes(String tex) {
        if (tex.isEmpty()) {
            if (this.textureEyes != null) {
                this.textureEyes = null;
                this.updateTextures = true;
            }
        } else if (this.textureEyes == null) {
            this.textureEyes = new ResourceLocation(tex);
            this.updateTextures = true;
        } else {
            ResourceLocation newTexture = new ResourceLocation(tex);
            if (!newTexture.toString().equals(this.textureEyes.toString())) {
                this.texture = newTexture;
                this.updateTextures = true;
            }
        }
    }

    private void loadTextureOverlay(String tex) {
        if (tex.isEmpty()) {
            if (this.textureOverlay != null) {
                this.textureOverlay = null;
                this.updateTextures = true;
            }
        } else if (this.textureOverlay == null) {
            this.textureOverlay = new ResourceLocation(tex);
            this.updateTextures = true;
        } else {
            ResourceLocation newTexture = new ResourceLocation(tex);
            if (!newTexture.toString().equals(this.textureOverlay.toString())) {
                this.texture = newTexture;
                this.updateTextures = true;
            }
        }
    }

    public float getRenderScale() {
        return ((Float)this.theEntity.func_184212_Q().func_187225_a(this.renderScale)).floatValue();
    }

    public void setRenderScale(float scale) {
        if (!((EntityLiving)this.theEntity).field_70170_p.field_72995_K) {
            this.theEntity.func_184212_Q().func_187227_b(this.renderScale, (Object)Float.valueOf(scale));
        }
    }

    public float getFamilyBaseScale() {
        return this.familyScale;
    }

    public float getBaseScaleForPreScaledValues() {
        return this.getBaseScale() / this.getFamilyBaseScale();
    }

    public float getBaseScale() {
        return this.baseScale;
    }

    public void setBaseScale(float newBaseScale) {
        this.baseScale = newBaseScale;
        this.setRenderScale(this.nextScale());
    }

    private float nextScale() {
        if (Config.get().GENERAL.RANDOM_SCALING > 0.0f) {
            return this.baseScale * (1.0f + (this.theEntity.func_70681_au().nextFloat() - 0.5f) * Config.get().GENERAL.RANDOM_SCALING);
        }
        return this.baseScale;
    }

    public double getRangedDamage(float distanceFactor) {
        int powerEnchant = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, this.theEntity);
        return (double)this.rangedAttackDamage * ((double)distanceFactor + this.theEntity.func_70681_au().nextGaussian() * 0.125 + (double)((float)((EntityLiving)this.theEntity).field_70170_p.func_175659_aa().func_151525_a() * 0.055f)) + (powerEnchant > 0 ? (double)powerEnchant * 0.5 + 0.5 : 0.0);
    }

    public void setRegenerationTime(int ticks) {
        this.healTimeMax = ticks;
    }

    public float getFallDamageMultiplier() {
        return this.fallDamageMultiplier;
    }

    public void setFallDamageMultiplier(float value) {
        this.fallDamageMultiplier = value;
    }

    public void setImmuneToFire(boolean value) {
        ((ISpecialMob)this.theEntity).setImmuneToFire(value);
        if (value) {
            this.theEntity.func_184644_a(PathNodeType.LAVA, PathNodeType.WATER.func_186289_a());
            this.theEntity.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.OPEN.func_186289_a());
            this.theEntity.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.OPEN.func_186289_a());
        } else {
            this.theEntity.func_184644_a(PathNodeType.LAVA, PathNodeType.LAVA.func_186289_a());
            this.theEntity.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
            this.theEntity.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
        }
    }

    public boolean isImmuneToBurning() {
        return this.isImmuneToBurning;
    }

    public void setImmuneToBurning(boolean value) {
        this.isImmuneToBurning = value;
        if (value) {
            this.theEntity.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.OPEN.func_186289_a());
            this.theEntity.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
        } else {
            this.theEntity.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
            this.theEntity.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
        }
    }

    public boolean allowLeashing() {
        return this.allowLeashing;
    }

    public void setAllowLeashing(boolean value) {
        this.allowLeashing = value;
    }

    public boolean isImmuneToWebs() {
        return this.isImmuneToWebs;
    }

    public void setImmuneToWebs(boolean value) {
        this.isImmuneToWebs = value;
    }

    public boolean ignorePressurePlates() {
        return this.ignorePressurePlates;
    }

    public void setIgnorePressurePlates(boolean value) {
        this.ignorePressurePlates = value;
    }

    public boolean canBreatheInWater() {
        return this.canBreatheInWater;
    }

    public void setCanBreatheInWater(boolean value) {
        this.canBreatheInWater = value;
    }

    public boolean ignoreWaterPush() {
        return this.ignoreWaterPush;
    }

    public void setIgnoreWaterPush(boolean value) {
        this.ignoreWaterPush = value;
    }

    public boolean isDamagedByWater() {
        return this.isDamagedByWater;
    }

    public void setDamagedByWater(boolean value) {
        this.isDamagedByWater = value;
        if (value) {
            this.theEntity.func_184644_a(PathNodeType.WATER, PathNodeType.LAVA.func_186289_a());
        } else {
            this.theEntity.func_184644_a(PathNodeType.WATER, PathNodeType.WATER.func_186289_a());
        }
    }

    public boolean isPotionApplicable(PotionEffect effect) {
        return !this.immuneToPotions.contains(effect.func_188419_a().func_76393_a());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74776_a(TAG_RENDER_SCALE, this.getRenderScale());
        tag.func_74768_a(TAG_EXPERIENCE, ((ISpecialMob)this.theEntity).getExperience());
        tag.func_74774_a(TAG_REGENERATION, (byte)this.healTimeMax);
        tag.func_74778_a(TAG_TEXTURE, this.texture.toString());
        tag.func_74778_a(TAG_TEXTURE_EYES, this.textureEyes == null ? "" : this.textureEyes.toString());
        tag.func_74778_a(TAG_TEXTURE_OVER, this.textureOverlay == null ? "" : this.textureOverlay.toString());
        tag.func_74776_a(TAG_ARROW_DAMAGE, this.rangedAttackDamage);
        tag.func_74776_a(TAG_ARROW_SPREAD, this.rangedAttackSpread);
        tag.func_74776_a(TAG_ARROW_WALK_SPEED, this.rangedWalkSpeed);
        tag.func_74777_a(TAG_ARROW_REFIRE_MIN, (short)this.rangedAttackCooldown);
        tag.func_74777_a(TAG_ARROW_REFIRE_MAX, (short)this.rangedAttackMaxCooldown);
        tag.func_74776_a(TAG_ARROW_RANGE, this.rangedAttackMaxRange);
        tag.func_74776_a(TAG_FALL_MULTI, this.getFallDamageMultiplier());
        tag.func_74757_a(TAG_FIRE_IMMUNE, this.theEntity.func_70045_F());
        tag.func_74757_a(TAG_BURN_IMMUNE, this.isImmuneToBurning());
        tag.func_74757_a(TAG_LEASHABLE, this.allowLeashing());
        tag.func_74757_a(TAG_WEB_IMMUNE, this.isImmuneToWebs());
        tag.func_74757_a(TAG_TRAP_IMMUNE, this.ignorePressurePlates());
        tag.func_74757_a(TAG_DROWN_IMMUNE, this.canBreatheInWater());
        tag.func_74757_a(TAG_WATER_PUSH_IMMUNE, this.ignoreWaterPush());
        tag.func_74757_a(TAG_WATER_DAMAGE, this.isDamagedByWater());
        NBTTagList potionsTag = new NBTTagList();
        for (String potionName : this.immuneToPotions) {
            potionsTag.func_74742_a((NBTBase)new NBTTagString(potionName));
        }
        tag.func_74782_a(TAG_POTION_IMMUNE, (NBTBase)potionsTag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b(TAG_RENDER_SCALE, 99)) {
            this.setRenderScale(tag.func_74760_g(TAG_RENDER_SCALE));
        }
        if (tag.func_150297_b(TAG_EXPERIENCE, 99)) {
            ((ISpecialMob)this.theEntity).setExperience(tag.func_74762_e(TAG_EXPERIENCE));
        }
        if (tag.func_150297_b(TAG_REGENERATION, 99)) {
            this.healTimeMax = tag.func_74771_c(TAG_REGENERATION);
        }
        try {
            byte nbtTypeString = new NBTTagString().func_74732_a();
            if (tag.func_150297_b(TAG_TEXTURE, (int)nbtTypeString)) {
                this.loadTexture(tag.func_74779_i(TAG_TEXTURE));
            }
            if (tag.func_150297_b(TAG_TEXTURE_EYES, (int)nbtTypeString)) {
                this.loadTextureEyes(tag.func_74779_i(TAG_TEXTURE_EYES));
            }
            if (tag.func_150297_b(TAG_TEXTURE_OVER, (int)nbtTypeString)) {
                this.loadTextureOverlay(tag.func_74779_i(TAG_TEXTURE_OVER));
            }
        }
        catch (Exception ex) {
            SpecialMobsMod.log().warn("Failed to load textures from NBT! " + this.theEntity.toString());
        }
        if (tag.func_150297_b(TAG_ARROW_DAMAGE, 99)) {
            this.rangedAttackDamage = tag.func_74760_g(TAG_ARROW_DAMAGE);
        }
        if (tag.func_150297_b(TAG_ARROW_SPREAD, 99)) {
            this.rangedAttackSpread = tag.func_74760_g(TAG_ARROW_SPREAD);
        }
        if (tag.func_150297_b(TAG_ARROW_WALK_SPEED, 99)) {
            this.rangedWalkSpeed = tag.func_74760_g(TAG_ARROW_WALK_SPEED);
        }
        if (tag.func_150297_b(TAG_ARROW_REFIRE_MIN, 99)) {
            this.rangedAttackCooldown = tag.func_74765_d(TAG_ARROW_REFIRE_MIN);
        }
        if (tag.func_150297_b(TAG_ARROW_REFIRE_MAX, 99)) {
            this.rangedAttackMaxCooldown = tag.func_74765_d(TAG_ARROW_REFIRE_MAX);
        }
        if (tag.func_150297_b(TAG_ARROW_RANGE, 99)) {
            this.rangedAttackMaxRange = tag.func_74760_g(TAG_ARROW_RANGE);
        }
        if (tag.func_150297_b(TAG_FALL_MULTI, 99)) {
            this.setFallDamageMultiplier(tag.func_74760_g(TAG_FALL_MULTI));
        }
        if (tag.func_150297_b(TAG_FIRE_IMMUNE, 99)) {
            ((ISpecialMob)this.theEntity).setImmuneToFire(tag.func_74767_n(TAG_FIRE_IMMUNE));
        }
        if (tag.func_150297_b(TAG_BURN_IMMUNE, 99)) {
            this.setImmuneToBurning(tag.func_74767_n(TAG_BURN_IMMUNE));
        }
        if (tag.func_150297_b(TAG_LEASHABLE, 99)) {
            this.setAllowLeashing(tag.func_74767_n(TAG_LEASHABLE));
        }
        if (tag.func_150297_b(TAG_WEB_IMMUNE, 99)) {
            this.setImmuneToWebs(tag.func_74767_n(TAG_WEB_IMMUNE));
        }
        if (tag.func_150297_b(TAG_TRAP_IMMUNE, 99)) {
            this.setIgnorePressurePlates(tag.func_74767_n(TAG_TRAP_IMMUNE));
        }
        if (tag.func_150297_b(TAG_DROWN_IMMUNE, 99)) {
            this.setCanBreatheInWater(tag.func_74767_n(TAG_DROWN_IMMUNE));
        }
        if (tag.func_150297_b(TAG_WATER_PUSH_IMMUNE, 99)) {
            this.setIgnoreWaterPush(tag.func_74767_n(TAG_WATER_PUSH_IMMUNE));
        }
        if (tag.func_150297_b(TAG_WATER_DAMAGE, 99)) {
            this.setDamagedByWater(tag.func_74767_n(TAG_WATER_DAMAGE));
        }
        if (tag.func_150297_b(TAG_POTION_IMMUNE, (int)new NBTTagList().func_74732_a())) {
            NBTTagList potionsTag = tag.func_150295_c(TAG_POTION_IMMUNE, (int)new NBTTagString().func_74732_a());
            this.immuneToPotions.clear();
            for (int i = 0; i < potionsTag.func_74745_c(); ++i) {
                this.immuneToPotions.add(potionsTag.func_150307_f(i));
            }
        }
    }
}

