/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.config;

import fathertoast.specialmobs.config.Config;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class TargetBlock {
    public final Block BLOCK;
    public final int BLOCK_DATA;

    public static HashSet<TargetBlock> newBlockSet(String line) {
        return TargetBlock.newBlockSet(line.split(","));
    }

    public static HashSet<TargetBlock> newBlockSet(String[] targetableBlocks) {
        HashSet<TargetBlock> blockSet = new HashSet<TargetBlock>();
        for (String target : targetableBlocks) {
            TargetBlock targetableBlock;
            String[] pair = target.split(" ", 2);
            if (pair.length > 1) {
                targetableBlock = new TargetBlock(TargetBlock.getStringAsBlock(pair[0]), Integer.parseInt(pair[1].trim()));
            } else {
                if (pair[0].endsWith("*")) {
                    TargetBlock.addAllModBlocks(blockSet, pair[0].substring(pair[0].length() - 1));
                    continue;
                }
                targetableBlock = new TargetBlock(TargetBlock.getStringAsBlock(pair[0]), -1);
            }
            if (targetableBlock.BLOCK == null || targetableBlock.BLOCK == Blocks.field_150350_a) continue;
            if (targetableBlock.BLOCK_DATA < 0) {
                while (blockSet.contains(targetableBlock)) {
                    blockSet.remove(targetableBlock);
                }
            }
            blockSet.add(targetableBlock);
        }
        return blockSet;
    }

    static IBlockState getStringAsBlock(String id) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(id));
        if (block == Blocks.field_150350_a) {
            try {
                block = Block.func_149729_e((int)Integer.parseInt(id));
                if (block != Blocks.field_150350_a) {
                    Config.log.warn("Usage of numerical block id! ({})", (Object)id);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (block == Blocks.field_150350_a) {
            Config.log.error("Missing or invalid block! ({})", (Object)id);
        }
        return block.func_176223_P();
    }

    private static void addAllModBlocks(HashSet<TargetBlock> blockSet, String namespace) {
        try {
            for (ResourceLocation blockId : Block.field_149771_c.func_148742_b()) {
                if (!blockId.toString().startsWith(namespace)) continue;
                TargetBlock targetableBlock = new TargetBlock(TargetBlock.getStringAsBlock(blockId.toString()), -1);
                if (targetableBlock.BLOCK == null || targetableBlock.BLOCK == Blocks.field_150350_a) continue;
                while (blockSet.contains(targetableBlock)) {
                    blockSet.remove(targetableBlock);
                }
                blockSet.add(targetableBlock);
            }
        }
        catch (Exception ex) {
            Config.log.error("Caught exception while adding namespace! ({}*)", (Object)namespace);
        }
    }

    public TargetBlock(Block block, int meta) {
        this.BLOCK = block;
        this.BLOCK_DATA = meta;
    }

    public TargetBlock(Block block) {
        this(block, -1);
    }

    public TargetBlock(IBlockState block, int meta) {
        this(block.func_177230_c(), meta);
    }

    public TargetBlock(IBlockState block) {
        this(block, block.func_177230_c().func_176201_c(block));
    }

    public int hashCode() {
        return Block.func_149682_b((Block)this.BLOCK);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TargetBlock && this.BLOCK.equals(((TargetBlock)obj).BLOCK)) {
            return this.BLOCK_DATA < 0 || ((TargetBlock)obj).BLOCK_DATA < 0 || this.BLOCK_DATA == ((TargetBlock)obj).BLOCK_DATA;
        }
        return false;
    }
}

