/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.registry.IVariant;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSubTypeEdible
extends ItemFood
implements IVariant {
    private final FoodMetaInfo[] info;
    private final String[] variants;

    public ItemSubTypeEdible(FoodMetaInfo[] info) {
        super(0, 0.0f, false);
        this.func_77627_a(true);
        this.info = info;
        this.variants = (String[])Arrays.stream(info).map(FoodMetaInfo::getName).toArray(String[]::new);
    }

    private FoodMetaInfo getInfo(ItemStack stack) {
        return this.isValidMeta(stack.func_77960_j()) ? this.info[stack.func_77960_j()] : FoodMetaInfo.EMPTY;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        FoodMetaInfo info = this.getInfo(stack);
        if (!worldIn.field_72995_K && !info.getEffects().isEmpty() && MathsUtils.tryPercentage(info.getPotionChance())) {
            for (PotionEffect effect : info.getEffects()) {
                player.func_70690_d(new PotionEffect(effect));
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getInfo(stack).isDrink() ? EnumAction.DRINK : EnumAction.EAT;
    }

    public int func_150905_g(ItemStack stack) {
        return this.getInfo(stack).getFood();
    }

    public float func_150906_h(ItemStack stack) {
        return this.getInfo(stack).getSaturation();
    }

    @Override
    public String[] getVariant() {
        return this.variants;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < this.getVariant().length; ++meta) {
                subItems.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    public static class FoodMetaInfo {
        public static FoodMetaInfo EMPTY = new FoodMetaInfo(-1, "invalid", 0, 0);
        private int meta;
        private String name;
        private int food;
        private int saturation;
        private boolean isDrink;
        private float potionChance;
        private List<PotionEffect> effects;

        public FoodMetaInfo(int meta, String name, int food, int saturation) {
            this(meta, name, food, saturation, false, 0.0f, new ArrayList<PotionEffect>());
        }

        public FoodMetaInfo(int meta, String name, int food, int saturation, boolean isDrink) {
            this(meta, name, food, saturation, isDrink, 0.0f, new ArrayList<PotionEffect>());
        }

        public FoodMetaInfo(int meta, String name, int food, int saturation, boolean isDrink, float potionChance, List<PotionEffect> effects) {
            this.meta = meta;
            this.name = name;
            this.food = food;
            this.saturation = saturation;
            this.isDrink = isDrink;
            this.potionChance = potionChance;
            this.effects = effects;
        }

        public int getMeta() {
            return this.meta;
        }

        public void setMeta(int meta) {
            this.meta = meta;
        }

        public int getFood() {
            return this.food;
        }

        public void setFood(int food) {
            this.food = food;
        }

        public int getSaturation() {
            return this.saturation;
        }

        public void setSaturation(int saturation) {
            this.saturation = saturation;
        }

        public float getPotionChance() {
            return this.potionChance;
        }

        public void setPotionChance(float potionChance) {
            this.potionChance = potionChance;
        }

        public List<PotionEffect> getEffects() {
            return this.effects;
        }

        public void setEffects(List<PotionEffect> effects) {
            this.effects = effects;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isDrink() {
            return this.isDrink;
        }

        public void setDrink(boolean isDrink) {
            this.isDrink = isDrink;
        }
    }
}

