/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib;

import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class CompatForgeRegistry<K> {
    public static final Class<?> CLASS = TRLUtils.MC_VERSION_NUMBER > 11 ? IForgeRegistry.class : TRLUtils.getClass("net.minecraftforge.fml.common.registry.IForgeRegistry");
    private static final Method FIND_REGISTRY = TRLUtils.MC_VERSION_NUMBER > 11 || CLASS == null ? null : TRLUtils.findMethod(GameRegistry.class, "findRegistry", Class.class);
    private static final Method GET_VALUE = TRLUtils.MC_VERSION_NUMBER > 11 || CLASS == null ? null : TRLUtils.findMethod(CLASS, "getValue", ResourceLocation.class);
    private final Object registry;

    public CompatForgeRegistry(Object registry) {
        CompatForgeRegistry.checkSupported();
        if (!CLASS.isAssignableFrom(registry.getClass())) {
            throw new IllegalArgumentException("Not an IForgeRegistry: " + registry);
        }
        this.registry = registry;
    }

    public Object getRegistry() {
        return this.registry;
    }

    public K getValue(ResourceLocation key) {
        CompatForgeRegistry.checkSupported();
        if (TRLUtils.MC_VERSION_NUMBER > 11) {
            return (K)((IForgeRegistry)this.registry).getValue(key);
        }
        try {
            return (K)GET_VALUE.invoke(this.registry, key);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            TRLUtils.crashReport("Failed to get registry entry with key: " + key, ex);
            return null;
        }
    }

    public static <K> CompatForgeRegistry<K> findRegistry(Class<K> clazz) {
        CompatForgeRegistry.checkSupported();
        if (TRLUtils.MC_VERSION_NUMBER > 11) {
            return new CompatForgeRegistry<K>(GameRegistry.findRegistry(clazz));
        }
        try {
            return new CompatForgeRegistry<K>(FIND_REGISTRY.invoke(null, clazz));
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            TRLUtils.crashReport("Failed to get Forge registry: " + clazz.getName(), ex);
            return null;
        }
    }

    private static void checkSupported() {
        if (CLASS == null) {
            throw new UnsupportedOperationException("Not supported on Minecraft 1.8");
        }
    }
}

