/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.hook.client;

import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;

public final class EntityRendererHook {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Field ENTITY_RENDERER_HOOK = TRLUtils.findField(EntityRenderer.class, "entityRendererHook");
    private float lastEyeHeight;
    private float eyeHeight;

    public static void updateRenderer(EntityRenderer renderer, EntityRendererHook hook) {
        hook = EntityRendererHook.get(renderer, hook);
        hook.lastEyeHeight = hook.eyeHeight;
        hook.eyeHeight += (mc.func_175606_aa().func_70047_e() - hook.eyeHeight) * 0.5f;
    }

    public static float getEyeHeight(Entity entity, float partialTicks, EntityRenderer renderer, EntityRendererHook hook) {
        hook = EntityRendererHook.get(renderer, hook);
        return hook.lastEyeHeight + (hook.eyeHeight - hook.lastEyeHeight) * partialTicks;
    }

    public static void orientCamera(float partialTicks, EntityRenderer renderer, EntityRendererHook hook) {
        if (!RPConfig.Client.smoothEyeLevelChanges) {
            return;
        }
        Entity entity = mc.func_175606_aa();
        GlStateManager.func_179109_b((float)0.0f, (float)(entity.func_70047_e() - EntityRendererHook.getEyeHeight(entity, partialTicks, renderer, hook)), (float)0.0f);
    }

    public static EntityRendererHook get(EntityRenderer renderer, EntityRendererHook hook) {
        if (hook == null) {
            hook = new EntityRendererHook();
            try {
                ENTITY_RENDERER_HOOK.set(renderer, hook);
            }
            catch (IllegalAccessException ex) {
                TRLUtils.crashReport("Failed to set EntityRenderer#entityRendererHook", ex);
            }
        }
        return hook;
    }
}

