/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;

@Config(modid="pyrotech", name="pyrotech/module.Tool")
public class ModuleToolConfig {
    @Config.Comment(value={"The durability of the vanilla type tools, excluding hammers.", "To change the durability of hammers, see the hammers section in core.cfg."})
    public static Map<String, Integer> DURABILITY = new LinkedHashMap<String, Integer>();
    @Config.Comment(value={"The harvest levels of each tool material, excluding hammers.", "To change the harvest level of hammers, see the hammers section in core.cfg."})
    public static Map<String, Integer> HARVEST_LEVEL;
    @Config.Comment(value={"The durability of the shears.", "For reference, the durability of the vanilla shears is 238."})
    public static Map<String, Integer> SHEARS_DURABILITY;
    @Config.Comment(value={"The durability of the crude fishing rod.", "Default: 16"})
    @Config.RangeInt(min=1, max=32767)
    public static int CRUDE_FISHING_ROD_DURABILITY;
    @Config.Comment(value={"Chance that the crude fishing rod will break when damaged.", "The chance to break increases linearly as the rod takes damage.", "This is the maximum chance when the rod is at 100% damage.", "chance = (damage / maxDamage) * configChance", "Default: 0.65"})
    public static double CRUDE_FISHING_ROD_BREAK_CHANCE;

    public static int getHarvestLevel(String type) {
        return HARVEST_LEVEL.getOrDefault(type, -1);
    }

    static {
        DURABILITY.put("crude", 32);
        DURABILITY.put("bone", 150);
        DURABILITY.put("flint", 150);
        DURABILITY.put("obsidian", 1400);
        HARVEST_LEVEL = new LinkedHashMap<String, Integer>();
        HARVEST_LEVEL.put("crude", 0);
        HARVEST_LEVEL.put("bone", 1);
        HARVEST_LEVEL.put("flint", 1);
        HARVEST_LEVEL.put("obsidian", 2);
        SHEARS_DURABILITY = new LinkedHashMap<String, Integer>();
        SHEARS_DURABILITY.put("clay", 60);
        SHEARS_DURABILITY.put("stone", 90);
        SHEARS_DURABILITY.put("bone", 120);
        SHEARS_DURABILITY.put("flint", 120);
        SHEARS_DURABILITY.put("gold", 30);
        SHEARS_DURABILITY.put("diamond", 952);
        SHEARS_DURABILITY.put("obsidian", 852);
        CRUDE_FISHING_ROD_DURABILITY = 16;
        CRUDE_FISHING_ROD_BREAK_CHANCE = 0.65;
    }
}

