/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi;

import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarDrain;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileActivePile;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarCollectorBase;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarTankBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileTarDrainBase
extends TileTarTankBase {
    public TileTarDrainBase() {
        this.fluidTank.setCanFill(false);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            EnumFacing tileFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTarDrain.FACING);
            return facing == tileFacing || facing == tileFacing.func_176734_d();
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        EnumFacing tileFacing;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == (tileFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTarDrain.FACING)) || facing == tileFacing.func_176734_d())) {
            return (T)((Object)this.fluidTank);
        }
        return null;
    }

    @Override
    protected List<BlockPos> getCollectionSourcePositions(World world, BlockPos origin) {
        IBlockState blockState = world.func_180495_p(origin);
        if (blockState.func_177230_c() != ModuleTechRefractory.Blocks.TAR_DRAIN) {
            return Collections.emptyList();
        }
        EnumFacing facing = ((EnumFacing)blockState.func_177229_b((IProperty)BlockTarDrain.FACING)).func_176734_d();
        int drainRange = this.getDrainRange();
        BlockPos offset = origin.func_177967_a(facing, 1 + drainRange);
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(9);
        for (int x = -drainRange; x <= drainRange; ++x) {
            for (int z = -drainRange; z <= drainRange; ++z) {
                result.add(offset.func_177982_a(x, 0, z));
            }
        }
        return result;
    }

    protected abstract int getDrainRange();

    @Override
    @Nullable
    protected FluidTank getCollectionSourceFluidTank(@Nullable TileEntity tileEntity) {
        if (tileEntity instanceof TileTarCollectorBase) {
            return ((TileTarCollectorBase)tileEntity).getFluidTank();
        }
        if (tileEntity instanceof TileActivePile) {
            return ((TileActivePile)tileEntity).getFluidTank();
        }
        return null;
    }
}

