/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile;

import com.codetaylor.mc.athenaeum.inventory.LargeObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.FacingHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.library.CompactingBinRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileSoakingPot;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileMechanicalCompactingBinWorker
extends TileCogWorkerBase {
    private OutputStackHandler outputStackHandler = new OutputStackHandler(this.getOutputCapacity());

    public TileMechanicalCompactingBinWorker() {
        super(ModuleTechMachine.TILE_DATA_SERVICE);
        this.outputStackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.outputStackHandler)});
        this.addInteractions(new IInteraction[]{new InteractionItem((ItemStackHandler)this.outputStackHandler)});
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return facing == EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.outputStackHandler);
        }
        return null;
    }

    public OutputStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    @Override
    protected int getUpdateIntervalTicks() {
        return ModuleTechMachineConfig.MECHANICAL_COMPACTING_BIN.WORK_INTERVAL_TICKS;
    }

    @Override
    protected boolean isValidCog(ItemStack itemStack) {
        return this.getCogRecipeProgress(itemStack) > -1.0;
    }

    protected double getCogRecipeProgress(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        return ModuleTechMachineConfig.MECHANICAL_COMPACTING_BIN.getCogRecipeProgress(registryName);
    }

    protected int getOutputCapacity() {
        return ModuleTechMachineConfig.MECHANICAL_COMPACTING_BIN.OUTPUT_CAPACITY;
    }

    @Override
    protected int doWork(ItemStack cog) {
        TileCompactingBin tile;
        CompactingBinRecipeBase currentRecipe;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (tileEntity instanceof TileCompactingBin && (currentRecipe = (tile = (TileCompactingBin)tileEntity).getCurrentRecipe()) != null && currentRecipe.getAmount() <= tile.getInputStackHandler().getTotalItemCount() && this.outputStackHandler.insertItemInternal(currentRecipe.getOutput(), true).func_190916_E() == 0) {
            float progress = (float)MathHelper.func_151237_a((double)this.getCogRecipeProgress(this.getCog()), (double)0.0, (double)1.0);
            if ((double)tile.addRecipeProgress(progress) > 0.9999) {
                this.outputStackHandler.insertItemInternal(currentRecipe.getOutput(), false);
                tile.getInputStackHandler().removeItems(currentRecipe.getAmount());
                tile.resetRecipeProgress();
            }
            SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187715_dR, (SoundCategory)SoundCategory.BLOCKS, (float)0.5f);
            return 1;
        }
        return -1;
    }

    @Override
    protected boolean isPowered() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return true;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        return this.field_145850_b.func_175640_z(this.field_174879_c.func_177972_a(facing));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
    }

    @Override
    protected Transform getCogInteractionTransform() {
        return new Transform(Transform.translate(0.875, 0.5, 0.5), Transform.rotate(0.0, 1.0, 0.0, 90.0), Transform.scale(0.75, 0.75, 2.0));
    }

    @Override
    protected AxisAlignedBB getCogInteractionBounds() {
        return AABBHelper.create((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @Override
    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.MECHANICAL_COMPACTING_BIN) {
            return FacingHelper.rotateFacingCW((EnumFacing)((EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)));
        }
        return super.getTileFacing(world, pos, blockState);
    }

    public static class OutputStackHandler
    extends LargeObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int capacity;

        OutputStackHandler(int capacity) {
            super(1);
            this.capacity = capacity;
        }

        public int getSlotLimit(int slot) {
            return this.capacity;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        ItemStack insertItemInternal(@Nonnull ItemStack stack, boolean simulate) {
            return super.insertItem(0, stack, simulate);
        }
    }

    private class InteractionItem
    extends InteractionItemStack<TileSoakingPot> {
        InteractionItem(ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, AABBHelper.create((double)1.0, (double)16.0, (double)3.0, (double)11.0, (double)11.0, (double)13.0), new Transform(Transform.translate(0.375, 1.0, 0.5), Transform.rotate(), Transform.scale(0.5, 0.5, 0.5)));
        }

        @Override
        protected boolean doItemStackValidation(ItemStack itemStack) {
            return false;
        }
    }
}

