/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.recipe;

import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInItemOutBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;

public class StoneOvenRecipe
extends MachineRecipeItemInItemOutBase<StoneOvenRecipe> {
    private static final Map<String, StoneOvenRecipe> SMELTING_RECIPES = new HashMap<String, StoneOvenRecipe>();
    private static final List<Ingredient> WHITELIST = new ArrayList<Ingredient>();
    private static final List<Ingredient> BLACKLIST = new ArrayList<Ingredient>();
    private static boolean BLACKLIST_ALL = false;

    public static void blacklistAll() {
        BLACKLIST_ALL = true;
    }

    @Nullable
    public static StoneOvenRecipe getRecipe(ItemStack input) {
        String key = StoneOvenRecipe.getRecipeKey(input);
        StoneOvenRecipe result = SMELTING_RECIPES.get(key);
        if (result != null) {
            return result;
        }
        if (!BLACKLIST_ALL && RecipeHelper.hasFurnaceFoodRecipe((ItemStack)input)) {
            FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
            ItemStack output = furnaceRecipes.func_151395_a(input);
            if (StoneOvenRecipe.hasWhitelist()) {
                if (StoneOvenRecipe.isWhitelisted(output)) {
                    result = new StoneOvenRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}));
                    SMELTING_RECIPES.put(key, result);
                    return result;
                }
                return StoneOvenRecipe.getCustomRecipe(input);
            }
            if (StoneOvenRecipe.hasBlacklist()) {
                if (!StoneOvenRecipe.isBlacklisted(output)) {
                    result = new StoneOvenRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}));
                    SMELTING_RECIPES.put(key, result);
                    return result;
                }
                return StoneOvenRecipe.getCustomRecipe(input);
            }
            result = new StoneOvenRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}));
            SMELTING_RECIPES.put(key, result);
            return result;
        }
        return StoneOvenRecipe.getCustomRecipe(input);
    }

    @Nullable
    private static StoneOvenRecipe getCustomRecipe(ItemStack input) {
        for (StoneOvenRecipe recipe : ModuleTechMachine.Registries.STONE_OVEN_RECIPES) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    private static String getRecipeKey(ItemStack itemStack) {
        return itemStack.func_77973_b().func_77658_a() + ":" + itemStack.func_77952_i();
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechMachine.Registries.STONE_OVEN_RECIPES, (Ingredient)output);
    }

    public static void blacklistSmeltingRecipe(Ingredient output) {
        BLACKLIST.add(output);
    }

    public static void whitelistSmeltingRecipe(Ingredient output) {
        WHITELIST.add(output);
    }

    public static boolean hasBlacklist() {
        return !BLACKLIST.isEmpty();
    }

    public static boolean hasWhitelist() {
        return !WHITELIST.isEmpty();
    }

    public static boolean isBlacklisted(ItemStack output) {
        for (Ingredient ingredient : BLACKLIST) {
            if (!ingredient.apply(output)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhitelisted(ItemStack output) {
        for (Ingredient ingredient : WHITELIST) {
            if (!ingredient.apply(output)) continue;
            return true;
        }
        return false;
    }

    public StoneOvenRecipe(ItemStack output, Ingredient input) {
        super(input, output, ModuleTechMachineConfig.STONE_OVEN.COOK_TIME_TICKS);
    }

    public StoneOvenRecipe(ItemStack output, Ingredient input, int cookTimeTicks) {
        super(input, output, cookTimeTicks);
    }
}

