/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.waila.delegate;

import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.athenaeum.util.StringHelper;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileCombustionWorkerBase;
import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneBase;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public abstract class CombustionMachineProviderDelegateBase<D extends ICombustionMachineDisplay, T extends TileCombustionWorkerStoneBase, R extends MachineRecipeBase>
extends ProviderDelegateBase<D, T> {
    protected CombustionMachineProviderDelegateBase(D display) {
        super(display);
    }

    public void addBurnTimeInfo(T tile, float progress, ItemStack input, ItemStack fuel, @Nullable R recipe) {
        ItemStack fuelStack = ((TileCombustionWorkerStoneBase)tile).getFuelStackHandler().getStackInSlot(0);
        int ticks = ((TileCombustionWorkerBase)tile).combustionGetBurnTimeRemaining();
        if (!fuelStack.func_190926_b()) {
            ticks += fuelStack.func_190916_E() * StackHelper.getItemBurnTime((ItemStack)fuelStack);
        }
        String langKey = "gui.pyrotech.waila.burn.time";
        String burnTimeString = StringHelper.ticksToHMS((int)ticks);
        if (recipe != null) {
            float recipeTimeTicks = (float)((MachineRecipeBase)recipe).getTimeTicks() * (1.0f - progress);
            if ((float)ticks < (recipeTimeTicks = this.getModifiedRecipeTimeTicks(recipeTimeTicks, tile, input, recipe))) {
                ((ICombustionMachineDisplay)this.display).setBurnTime(TextFormatting.RED, langKey, burnTimeString);
            } else {
                ((ICombustionMachineDisplay)this.display).setBurnTime(TextFormatting.GREEN, langKey, burnTimeString);
            }
        } else {
            ((ICombustionMachineDisplay)this.display).setBurnTime(null, langKey, burnTimeString);
        }
        if (!fuel.func_190926_b()) {
            langKey = "gui.pyrotech.waila.fuel";
            String fuelCountString = fuel.func_190916_E() > 1 ? " * " + fuel.func_190916_E() : "";
            ((ICombustionMachineDisplay)this.display).setFuel(langKey, fuel, fuelCountString);
        }
    }

    public float getModifiedRecipeTimeTicks(float recipeTimeTicks, T tile, ItemStack input, R recipe) {
        return recipeTimeTicks;
    }

    public static interface ICombustionMachineDisplay {
        public void setBurnTime(@Nullable TextFormatting var1, String var2, String var3);

        public void setFuel(String var1, ItemStack var2, String var3);
    }
}

