/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.crafttweaker;

import com.codetaylor.mc.athenaeum.tools.ZenDocAppend;
import com.codetaylor.mc.athenaeum.tools.ZenDocArg;
import com.codetaylor.mc.athenaeum.tools.ZenDocClass;
import com.codetaylor.mc.athenaeum.tools.ZenDocMethod;
import com.codetaylor.mc.athenaeum.tools.ZenDocPrepend;
import com.codetaylor.mc.pyrotech.library.crafttweaker.RemoveAllRecipesAction;
import com.codetaylor.mc.pyrotech.modules.core.plugin.crafttweaker.ZenStages;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickSawmillRecipe;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.pyrotech.BrickSawmill")
@ZenDocPrepend(value={"docs/include/header.md"})
@ZenDocAppend(value={"docs/include/brick_sawmill.example.md"})
@ZenClass(value="mods.pyrotech.BrickSawmill")
public class ZenBrickSawmill {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="burnTimeTicks", info="recipe duration in ticks"), @ZenDocArg(arg="blade", info="blade(s) used"), @ZenDocArg(arg="woodChips", info="amount of wood chips produced per recipe")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, int burnTimeTicks, IIngredient blade, @Optional(valueLong=0L) int woodChips) {
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(name, CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerMC.getIngredient((IIngredient)input), burnTimeTicks, CraftTweakerMC.getIngredient((IIngredient)blade), woodChips));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="output", info="output ingredient to match")})
    @ZenMethod
    public static void removeRecipes(IIngredient output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveRecipe(CraftTweakerMC.getIngredient((IIngredient)output)));
    }

    @ZenDocMethod(order=3)
    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAllRecipesAction<BrickSawmillRecipe>(ModuleTechMachine.Registries.BRICK_SAWMILL_RECIPES, "brick sawmill"));
    }

    @ZenDocMethod(order=4, args={@ZenDocArg(arg="stages", info="game stages")}, description={"Sets game stage logic required to use the device."})
    @ZenMethod
    public static void setGameStages(ZenStages stages) {
        ModuleTechMachineConfig.STAGES_BRICK_SAWMILL = stages.getStages();
    }

    public static class AddRecipe
    implements IAction {
        private final String name;
        private final ItemStack output;
        private final Ingredient input;
        private final int burnTimeTicks;
        private final Ingredient blade;
        private final int woodChips;

        public AddRecipe(String name, ItemStack output, Ingredient input, int burnTimeTicks, Ingredient blade, int woodChips) {
            this.name = name;
            this.input = input;
            this.output = output;
            this.burnTimeTicks = burnTimeTicks;
            this.blade = blade;
            this.woodChips = woodChips;
        }

        public void apply() {
            BrickSawmillRecipe recipe = new BrickSawmillRecipe(this.output, this.input, this.burnTimeTicks, this.blade, this.woodChips);
            ModuleTechMachine.Registries.BRICK_SAWMILL_RECIPES.register(recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        public String describe() {
            return "Adding brick sawmill recipe for " + this.output;
        }
    }

    public static class RemoveRecipe
    implements IAction {
        private final Ingredient output;

        public RemoveRecipe(Ingredient output) {
            this.output = output;
        }

        public void apply() {
            BrickSawmillRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing brick sawmill recipes for " + this.output;
        }
    }
}

