/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.item;

import com.codetaylor.mc.pyrotech.Reference;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemCog
extends Item {
    private int burnTime;

    public ItemCog(int maxUses) {
        this.func_77625_d(1);
        this.func_77656_e(maxUses);
        this.burnTime = 0;
    }

    public Item setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }

    public int getItemEnchantability(ItemStack stack) {
        if (stack.func_77973_b() == ModuleTechMachine.Items.GOLD_COG) {
            return Item.ToolMaterial.GOLD.func_77995_e();
        }
        return super.getItemEnchantability(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int[] cogData;
            double recipeProgress;
            Item item = stack.func_77973_b();
            ResourceLocation registryName = item.getRegistryName();
            int transferAmount = ModuleTechMachineConfig.STONE_HOPPER.getCogTransferAmount(registryName);
            if (transferAmount > -1) {
                String unlocalizedName = Item.func_150898_a((Block)ModuleTechMachine.Blocks.STONE_HOPPER).func_77658_a() + ".name";
                String localizedName = I18n.func_74838_a((String)unlocalizedName);
                tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.cog.hopper", (Object[])new Object[]{localizedName, Reference.Tooltip.COLOR_EXTENDED_INFO_HIGHLIGHT, transferAmount}));
            }
            if ((recipeProgress = ModuleTechMachineConfig.MECHANICAL_COMPACTING_BIN.getCogRecipeProgress(registryName)) > -1.0) {
                String unlocalizedName = Item.func_150898_a((Block)ModuleTechMachine.Blocks.MECHANICAL_COMPACTING_BIN).func_77658_a() + ".name";
                String localizedName = I18n.func_74838_a((String)unlocalizedName);
                tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.cog.compactor", (Object[])new Object[]{localizedName, Reference.Tooltip.COLOR_EXTENDED_INFO_HIGHLIGHT, (int)(recipeProgress * 100.0)}));
            }
            if ((cogData = ModuleTechMachineConfig.MECHANICAL_MULCH_SPREADER.getCogData(registryName, new int[2]))[0] > -1) {
                int range = cogData[0] * 2 + 1;
                int attempts = cogData[1];
                String unlocalizedName = Item.func_150898_a((Block)ModuleTechMachine.Blocks.MECHANICAL_MULCH_SPREADER).func_77658_a() + ".name";
                String localizedName = I18n.func_74838_a((String)unlocalizedName);
                tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.cog.spreader", (Object[])new Object[]{localizedName, Reference.Tooltip.COLOR_EXTENDED_INFO_HIGHLIGHT, attempts, range, range}));
            }
        } else {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.extended.shift", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO, TextFormatting.GRAY}));
        }
        if (ModuleTechMachineConfig.isCogIndestructible(stack.func_77973_b())) {
            tooltip.add(I18n.func_74838_a((String)"gui.pyrotech.tooltip.durability.indestructible"));
        } else {
            int damage = this.getDamage(stack);
            if (damage == 0) {
                int maxDamage = this.getMaxDamage(stack);
                tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.durability.full", (Object[])new Object[]{maxDamage}));
            }
        }
    }
}

