/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.block.spi;

import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem;
import com.codetaylor.mc.pyrotech.library.spi.tile.ITileContainer;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileCombustionWorkerBase;
import com.codetaylor.mc.pyrotech.modules.ignition.item.ItemIgniterBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneBase;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCombustionWorkerStoneBase
extends Block
implements IBlockInteractable,
IBlockIgnitableAdjacentIgniterBlock,
IBlockIgnitableWithIgniterItem {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375);

    public BlockCombustionWorkerStoneBase() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumType.BOTTOM)));
    }

    @Override
    public void igniteWithAdjacentIgniterBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCombustionWorkerStoneBase) {
            ((TileCombustionWorkerStoneBase)tileEntity).workerSetActive(true);
        }
    }

    @Override
    public void igniteWithIgniterItem(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tileEntity;
        if (!this.isTop(blockState) && blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL) == facing && (tileEntity = world.func_175625_s(pos)) instanceof TileCombustionWorkerStoneBase) {
            ((TileCombustionWorkerStoneBase)tileEntity).workerSetActive(true);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(TYPE) == EnumType.BOTTOM_LIT) {
            return MathHelper.func_76125_a((int)ModuleTechMachineConfig.GENERAL.STONE_MACHINE_LIGHT_LEVEL, (int)0, (int)15);
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean isTop(IBlockState state) {
        return state.func_177229_b(TYPE) == EnumType.TOP;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isTop(state)) {
            return AABB_TOP;
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing face) {
        if (this.isTop(state)) {
            return false;
        }
        if (face == EnumFacing.UP || face == state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)) {
            return false;
        }
        return this.func_149730_j(state);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149730_j(state);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isFireSource(@Nonnull World world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (this.isTop(state)) {
            return this.createTileEntityTop();
        }
        return this.createTileEntityBottom();
    }

    protected abstract TileEntity createTileEntityTop();

    protected abstract TileEntity createTileEntityBottom();

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (this.isTop(state)) {
            return 0;
        }
        return super.quantityDropped(state, fortune, random);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult result = super.func_180636_a(blockState, world, pos, start, end);
        if (this.isTop(blockState)) {
            return this.interactionRayTrace(result, blockState, world, pos.func_177977_b(), start, end);
        }
        return this.interactionRayTrace(result, blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        if (!this.isTop(state) && (heldItem = player.func_184614_ca()).func_77973_b() instanceof ItemIgniterBase) {
            return false;
        }
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.isTop(state)) {
            BlockPos down = pos.func_177977_b();
            if (world.func_180495_p(down).func_177230_c() == this) {
                TileEntity tileEntity = world.func_175625_s(down);
                if (tileEntity instanceof ITileContainer) {
                    ITileContainer tile = (ITileContainer)tileEntity;
                    tile.dropContents();
                }
                StackHelper.spawnStackOnTop((World)world, (ItemStack)new ItemStack((Block)this), (BlockPos)down);
                world.func_175698_g(down);
            }
        } else {
            TileEntity tileEntity;
            BlockPos up = pos.func_177984_a();
            if (world.func_180495_p(up).func_177230_c() == this) {
                world.func_175698_g(up);
            }
            if ((tileEntity = world.func_175625_s(pos)) instanceof ITileContainer) {
                ITileContainer tile = (ITileContainer)tileEntity;
                tile.dropContents();
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos up;
        if (!this.isTop(state) && super.func_176196_c(world, up = pos.func_177984_a())) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
            world.func_175656_a(up, this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing).func_177226_a(TYPE, (Comparable)((Object)EnumType.TOP)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    @Override
    public boolean interact(IInteraction.EnumType type, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isTop(state)) {
            return IBlockInteractable.super.interact(type, world, pos.func_177977_b(), state, player, hand, facing, hitX, hitY + 1.0f, hitZ);
        }
        return IBlockInteractable.super.interact(type, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isTop(state)) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177977_b());
            if (tileEntity instanceof TileCombustionWorkerStoneBase && ((TileCombustionWorkerStoneBase)tileEntity).workerIsActive()) {
                this.randomDisplayTickActiveTop(state, world, pos, rand);
                if (((TileCombustionWorkerStoneBase)tileEntity).hasFuel() && ((TileCombustionWorkerStoneBase)tileEntity).hasInput()) {
                    this.randomDisplayTickWorkingTop(state, world, pos, rand);
                }
            }
        } else {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileCombustionWorkerBase && ((TileCombustionWorkerBase)tileEntity).workerIsActive()) {
                EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
                double d2 = (double)pos.func_177952_p() + 0.5;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                double offset = 0.25;
                switch (enumfacing) {
                    case WEST: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - offset, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, d0 - offset, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + offset, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, d0 + offset, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case NORTH: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - offset, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - offset, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + offset, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + offset, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    protected void randomDisplayTickWorkingTop(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    protected void randomDisplayTickActiveTop(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int type = meta >> 2 & 3;
        int facingIndex = (meta & 3) + 2;
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_82609_l[facingIndex]).func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(type)));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        int meta = facing.func_176745_a() - 2;
        return meta |= type.getMeta() << 2;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        if (state.func_177229_b(TYPE) == EnumType.BOTTOM && (tileEntity = world.func_175625_s(pos)) instanceof TileCombustionWorkerBase && ((TileCombustionWorkerBase)tileEntity).combustionGetBurnTimeRemaining() > 0) {
            return state.func_177226_a(TYPE, (Comparable)((Object)EnumType.BOTTOM_DORMANT));
        }
        return state;
    }

    public static enum EnumType implements IVariant
    {
        TOP(0, "top"),
        BOTTOM(1, "bottom"),
        BOTTOM_LIT(2, "bottom_lit"),
        BOTTOM_DORMANT(3, "bottom_dormant");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

