/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.block;

import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileStoneHopper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BlockMechanicalHopper
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME = "mechanical_hopper";
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177706_a((String)"type", EnumType.class, (Enum[])new EnumType[]{EnumType.Down, EnumType.Side});
    private static final Map<EnumType, Map<EnumFacing, List<AxisAlignedBB>>> RAYTRACE_COLLISION_BOUNDS;

    public BlockMechanicalHopper() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumType.Down)));
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        EnumType type = (EnumType)((Object)blockState.func_177229_b(TYPE));
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileStoneHopper && !((TileStoneHopper)tileEntity).getCogStackHandler().getStackInSlot(0).func_190926_b()) {
            type = type == EnumType.Down ? EnumType.DownWithCog : EnumType.SideWithCog;
        }
        return RAYTRACE_COLLISION_BOUNDS.get((Object)type).get(blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).stream().map(bb -> this.func_185503_a(pos, start, end, (AxisAlignedBB)bb)).anyMatch(Objects::nonNull) ? this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end) : null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileStoneHopper) {
            TileCogWorkerBase.CogStackHandler handler = ((TileStoneHopper)tileEntity).getCogStackHandler();
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)handler, (BlockPos)pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileStoneHopper();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int type = meta >> 2 & 3;
        int facingIndex = (meta & 3) + 2;
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_82609_l[facingIndex]).func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(type)));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        int meta = facing.func_176745_a() - 2;
        return meta |= type.getMeta() << 2;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        EnumType type;
        if (facing.func_176736_b() == -1) {
            type = EnumType.Down;
            facing = placer.func_174811_aO().func_176734_d();
        } else {
            type = EnumType.Side;
        }
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    private static /* synthetic */ Map lambda$static$6(List shared, EnumType type) {
        Map result = Stream.of(EnumFacing.values()).filter(t -> t != EnumFacing.UP).collect(Collectors.toMap(aa -> aa, aa -> new ArrayList(shared), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new EnumMap(EnumFacing.class)));
        if (type == EnumType.Down || type == EnumType.DownWithCog) {
            AxisAlignedBB downAABB = AABBHelper.create((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
            ((List)result.get(EnumFacing.NORTH)).add(downAABB);
            ((List)result.get(EnumFacing.SOUTH)).add(downAABB);
            ((List)result.get(EnumFacing.EAST)).add(downAABB);
            ((List)result.get(EnumFacing.WEST)).add(downAABB);
            if (type == EnumType.DownWithCog) {
                ((List)result.get(EnumFacing.NORTH)).add(AABBHelper.create((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)13.0, (double)4.0));
                ((List)result.get(EnumFacing.SOUTH)).add(AABBHelper.create((double)2.0, (double)1.0, (double)12.0, (double)14.0, (double)13.0, (double)16.0));
                ((List)result.get(EnumFacing.EAST)).add(AABBHelper.create((double)12.0, (double)1.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0));
                ((List)result.get(EnumFacing.WEST)).add(AABBHelper.create((double)0.0, (double)1.0, (double)2.0, (double)4.0, (double)13.0, (double)14.0));
            }
        } else {
            ((List)result.get(EnumFacing.SOUTH)).add(AABBHelper.create((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
            ((List)result.get(EnumFacing.NORTH)).add(AABBHelper.create((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
            ((List)result.get(EnumFacing.WEST)).add(AABBHelper.create((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
            ((List)result.get(EnumFacing.EAST)).add(AABBHelper.create((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
            if (type == EnumType.SideWithCog) {
                ((List)result.get(EnumFacing.NORTH)).add(AABBHelper.create((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)13.0, (double)4.0));
                ((List)result.get(EnumFacing.SOUTH)).add(AABBHelper.create((double)2.0, (double)1.0, (double)12.0, (double)14.0, (double)13.0, (double)16.0));
                ((List)result.get(EnumFacing.EAST)).add(AABBHelper.create((double)12.0, (double)1.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0));
                ((List)result.get(EnumFacing.WEST)).add(AABBHelper.create((double)0.0, (double)1.0, (double)2.0, (double)4.0, (double)13.0, (double)14.0));
            }
        }
        return result;
    }

    static {
        ImmutableList shared = ImmutableList.of((Object)AABBHelper.create((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)AABBHelper.create((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0));
        RAYTRACE_COLLISION_BOUNDS = Stream.of(EnumType.values()).collect(Collectors.toMap(type -> type, arg_0 -> BlockMechanicalHopper.lambda$static$6((List)shared, arg_0), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new EnumMap(EnumType.class)));
    }

    public static enum EnumType implements IVariant
    {
        Down(0, "down"),
        Side(1, "side"),
        DownWithCog(2, "down_with_cog"),
        SideWithCog(3, "side_with_cog");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

