/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.block;

import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalBellows;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalBellowsTop;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BlockMechanicalBellows
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME = "mechanical_bellows";
    public static final IProperty<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB AABB_TOP = AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public BlockMechanicalBellows() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(0.2f);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177230_c() == this && state.func_177229_b(TYPE) == EnumType.TOP) {
            return AABB_TOP;
        }
        return super.func_185496_a(state, source, pos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult result = super.func_180636_a(blockState, world, pos, start, end);
        if (this.isTop(blockState)) {
            return this.interactionRayTrace(result, blockState, world, pos, start, end);
        }
        return result;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isTop(state)) {
            return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO();
        if (facing.func_176736_b() > -1) {
            opposite = facing.func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockPos posBottom;
        BlockPos posTop;
        boolean isTop = this.isTop(state);
        if (isTop) {
            posTop = pos;
            posBottom = pos.func_177977_b();
        } else {
            posTop = pos.func_177984_a();
            posBottom = pos;
        }
        TileEntity tileTop = world.func_175625_s(posTop);
        if (tileTop instanceof TileMechanicalBellowsTop) {
            TileCogWorkerBase.CogStackHandler cogStackHandler = ((TileMechanicalBellowsTop)tileTop).getCogStackHandler();
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)cogStackHandler, (BlockPos)posBottom);
        }
        world.func_175698_g(posTop);
        world.func_175698_g(posBottom);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos up;
        if (!this.isTop(state) && super.func_176196_c(world, up = pos.func_177984_a())) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
            world.func_175656_a(up, this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing).func_177226_a(TYPE, (Comparable)((Object)EnumType.TOP)));
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public boolean isTop(IBlockState blockState) {
        if (blockState.func_177230_c() == this) {
            return blockState.func_177229_b(TYPE) == EnumType.TOP;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumType.TOP) {
            return new TileMechanicalBellowsTop();
        }
        return new TileMechanicalBellows();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta >> 2 & 1))).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta() << 2 | ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176736_b();
    }

    public static enum EnumType implements IVariant
    {
        BOTTOM(0, "bottom"),
        TOP(1, "top");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

