/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe;

import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.util.IngredientHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.core.init.CompatInitializerOre;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockPileSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.SlagInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.ItemSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomAnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BloomeryRecipesAdd {
    private static final int DEFAULT_BURN_TIME_TICKS = 28800;
    private static final float DEFAULT_FAILURE_CHANCE = 0.25f;
    private static final RecipeItemParser RECIPE_ITEM_PARSER = new RecipeItemParser();

    public static void applyCompatRecipes(Path configurationPath, IForgeRegistry<BloomeryRecipe> registry) {
        CompatInitializerOre.OreCompatData data = CompatInitializerOre.read(configurationPath);
        if (data == null) {
            return;
        }
        for (Map.Entry<String, CompatInitializerOre.OreCompatOreDictEntry> entry : data.oredict.entrySet()) {
            String oreDictKey = entry.getKey();
            ItemSlag itemSlag = SlagInitializer.SLAG_BY_OREDICT.get(oreDictKey);
            BlockPileSlag blockPileSlag = SlagInitializer.SLAG_PILE_BY_OREDICT.get(oreDictKey);
            if (itemSlag == null || blockPileSlag == null) continue;
            ItemSlag.Properties properties = ModuleTechBloomery.Items.GENERATED_SLAG.get((Object)itemSlag);
            String langKey = properties.langKey;
            CompatInitializerOre.OreCompatOreDictEntry oreDictEntry = entry.getValue();
            ItemStack outputItemStack = BloomeryRecipesAdd.getFirstValidOutput(oreDictEntry.output);
            if (outputItemStack.func_190926_b()) continue;
            registry.register((IForgeRegistryEntry)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)new BloomeryRecipeBuilder(new ResourceLocation("pyrotech", "bloom_from_" + oreDictKey.toLowerCase()), outputItemStack.func_77946_l(), (Ingredient)new OreIngredient(oreDictKey)).setBurnTimeTicks(28800)).setFailureChance(0.25f)).setBloomYield(12, 15)).setSlagItem(new ItemStack((Item)itemSlag), 4)).addFailureItem(new ItemStack(ModuleTechBloomery.Items.SLAG), 1)).addFailureItem(new ItemStack((Item)itemSlag), 2)).setLangKey(langKey)).create());
            registry.register((IForgeRegistryEntry)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)new BloomeryRecipeBuilder(new ResourceLocation("pyrotech", "bloom_from_" + oreDictKey.toLowerCase() + "_slag"), outputItemStack.func_77946_l(), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)blockPileSlag)})).setBurnTimeTicks(14400)).setFailureChance(0.25f)).setBloomYield(12, 15)).setSlagItem(new ItemStack((Item)itemSlag), 2)).addFailureItem(new ItemStack((Block)ModuleCore.Blocks.ROCK, 1, BlockRock.EnumType.STONE.getMeta()), 1)).addFailureItem(new ItemStack(ModuleTechBloomery.Items.SLAG, 1, 0), 2)).setLangKey(langKey + ";" + itemSlag.func_77658_a() + ".unique")).create());
        }
    }

    private static ItemStack getFirstValidOutput(String[] outputs) {
        for (String itemString : outputs) {
            try {
                ParseResult parseResult = RECIPE_ITEM_PARSER.parse(itemString);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parseResult.getDomain(), parseResult.getPath()));
                if (item != null) {
                    return new ItemStack(item, 1, parseResult.getMeta());
                }
                ModuleTechBloomery.LOGGER.error("Unable to find registered item for: " + itemString);
            }
            catch (Exception e) {
                ModuleTechBloomery.LOGGER.error("Invalid item string: " + itemString);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void registerBloomAnvilRecipes(IForgeRegistry<BloomeryRecipe> registryBloomery, IForgeRegistry<AnvilRecipe> registryAnvil) {
        Collection bloomeryRecipes = registryBloomery.getValuesCollection();
        ArrayList snapshot = new ArrayList(bloomeryRecipes);
        for (BloomeryRecipeBase recipe : snapshot) {
            BloomeryRecipesAdd.registerBloomAnvilRecipe(registryAnvil, recipe);
        }
    }

    public static void registerBloomAnvilRecipe(IForgeRegistry<AnvilRecipe> registryAnvil, BloomeryRecipeBase recipe) {
        ResourceLocation registryName = recipe.getRegistryName();
        if (registryName == null) {
            return;
        }
        registryAnvil.register(new BloomAnvilRecipe(recipe.getOutput(), (Ingredient)IngredientHelper.fromStackWithNBT((ItemStack)recipe.getOutputBloom()), ModuleTechBloomeryConfig.BLOOM.HAMMER_HITS_IN_ANVIL_REQUIRED, AnvilRecipe.EnumType.HAMMER, Arrays.copyOf(recipe.getAnvilTiers(), recipe.getAnvilTiers().length), recipe).setRegistryName(registryName));
    }
}

