/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.block;

import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPileBase;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleLava;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.ItemSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TilePileSlag;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockPileSlag
extends BlockPileBase {
    public static final String NAME = "pile_slag";
    public static final PropertyBool MOLTEN = PropertyBool.func_177716_a((String)"molten");

    public BlockPileSlag() {
        super(Material.field_151576_e);
        this.func_149711_c(1.75f);
        this.func_149752_b(40.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockPileBase.LEVEL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)MOLTEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ItemStack getDrop(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TilePileSlag) {
            return ((TilePileSlag)tileEntity).getStackHandler().extractItem(0, 1, false);
        }
        return ItemStack.field_190927_a;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)MOLTEN)).booleanValue()) {
            return 6;
        }
        return super.getLightValue(state, world, pos);
    }

    public int func_149750_m(IBlockState state) {
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)MOLTEN)).booleanValue()) {
            return 6;
        }
        return super.func_149750_m(state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tileEntity;
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)MOLTEN)).booleanValue() && (tileEntity = world.func_175625_s(pos)) instanceof TilePileSlag) {
            long lastMolten = ((TilePileSlag)tileEntity).getLastMolten();
            if (world.func_82737_E() - lastMolten > 6000L) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)MOLTEN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)MOLTEN)).booleanValue()) {
            BlockPos posUp = pos.func_177984_a();
            IBlockState blockStateUp = world.func_180495_p(posUp);
            if (!world.func_175623_d(posUp) && blockStateUp.func_177230_c().isNormalCube(blockStateUp, (IBlockAccess)world, posUp)) {
                return;
            }
            int level = this.getLevel(state);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + (double)(level - 1) / 16.0 + rand.nextDouble() * 2.0 / 16.0;
            double z = (double)pos.func_177952_p() + 0.5;
            for (int i = 0; i < 4; ++i) {
                double offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.3;
                double offsetY = (rand.nextDouble() * 2.0 - 1.0) * 0.3;
                double offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.3;
                world.func_175688_a(EnumParticleTypes.FLAME, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                if (!(rand.nextDouble() < 0.05)) continue;
                world.func_175688_a(EnumParticleTypes.LAVA, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == this && ((Boolean)blockState.func_177229_b((IProperty)MOLTEN)).booleanValue() && ModuleTechBloomeryConfig.SLAG.MOLTEN_WALK_DAMAGE > 0.0 && !entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.func_70097_a(DamageSource.field_190095_e, (float)ModuleTechBloomeryConfig.SLAG.MOLTEN_WALK_DAMAGE);
        }
        super.func_176199_a(world, pos, entity);
    }

    @Override
    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (state.func_177230_c() == this && !world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)MOLTEN)).booleanValue()) {
            int level = this.getLevel(state);
            int dimension = world.field_73011_w.getDimension();
            ModuleTechBloomery.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleLava(pos, level), dimension, pos);
            if (ModuleTechBloomeryConfig.SLAG.HARVESTING_PLAYER_FIRE_DURATION_SECONDS > 0 && ModuleTechBloomeryConfig.SLAG.HARVESTING_PLAYER_FIRE_CHANCE > 0.0 && RandomHelper.random().nextDouble() < ModuleTechBloomeryConfig.SLAG.HARVESTING_PLAYER_FIRE_CHANCE) {
                player.func_70015_d(ModuleTechBloomeryConfig.SLAG.HARVESTING_PLAYER_FIRE_DURATION_SECONDS);
            }
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePileSlag();
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockPileBase.LEVEL, MOLTEN});
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int safeMeta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
        return this.func_176223_P().func_177226_a((IProperty)BlockPileBase.LEVEL, (Comparable)Integer.valueOf(safeMeta & 7)).func_177226_a((IProperty)MOLTEN, (Comparable)Boolean.valueOf((safeMeta >> 3 & 1) == 1));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPileBase.LEVEL) | ((Boolean)state.func_177229_b((IProperty)MOLTEN) != false ? 1 : 0) << 3;
    }

    public static class Properties {
        @Nullable
        public final String langKey;
        public final int color;
        public final ItemSlag slagItem;

        public Properties(@Nullable String langKey, int color, ItemSlag slagItem) {
            this.langKey = langKey;
            this.color = color;
            this.slagItem = slagItem;
        }
    }

    public static class ItemBlockPileSlag
    extends ItemBlock {
        public ItemBlockPileSlag(BlockPileSlag block) {
            super((Block)block);
        }

        @Nonnull
        public BlockPileSlag getBlock() {
            return (BlockPileSlag)super.func_179223_d();
        }

        public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
            TileEntity tileEntity;
            Properties properties = ModuleTechBloomery.Blocks.GENERATED_PILE_SLAG.get((Object)this.getBlock());
            ItemStack slagItem = properties == null ? new ItemStack(ModuleTechBloomery.Items.SLAG) : new ItemStack((Item)properties.slagItem);
            boolean result = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
            if (result && (tileEntity = world.func_175625_s(pos)) instanceof TilePileSlag) {
                TilePileSlag.StackHandler stackHandler = ((TilePileSlag)tileEntity).getStackHandler();
                for (int i = 0; i < 8; ++i) {
                    stackHandler.insertItem(i, slagItem.func_77946_l(), false);
                }
            }
            return result;
        }

        @Nonnull
        public String func_77653_i(@Nonnull ItemStack stack) {
            String langKey;
            Properties properties;
            if (stack.func_77973_b() == this && (properties = ModuleTechBloomery.Blocks.GENERATED_PILE_SLAG.get((Object)this.getBlock())) != null && I18n.func_94522_b((String)(langKey = properties.langKey + ".name"))) {
                String translatedLangKey = I18n.func_74838_a((String)langKey);
                return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".unique.name"), (Object[])new Object[]{translatedLangKey}).trim();
            }
            return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
        }
    }
}

