/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi;

import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.athenaeum.util.TickCounter;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetWorkerBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.spi.DryingRackRecipeBase;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileDryingRackBase
extends TileNetWorkerBase
implements ITickable {
    private static final int SPEED_CHECK_INTERVAL_TICKS = 20;
    protected InputStackHandler inputStackHandler = new InputStackHandler(this.getSlotCount());
    protected OutputStackHandler outputStackHandler;
    private int[] dryTimeTotal;
    private int[] dryTimeRemaining;
    private float[] partialTicks;
    private TileDataFloat speed;
    private TickCounter speedCheckTickCounter;

    public TileDryingRackBase(int taskCount) {
        super(ModuleCore.TILE_DATA_SERVICE, taskCount);
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.initSlotDryTime(slot, this.getDryTimeTicks(handler.getStackInSlot(slot)));
            this.func_70296_d();
        });
        this.outputStackHandler = new OutputStackHandler(this.getSlotCount());
        this.outputStackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.dryTimeTotal = new int[this.getSlotCount()];
        this.dryTimeRemaining = new int[this.getSlotCount()];
        this.partialTicks = new float[this.getSlotCount()];
        Arrays.fill(this.dryTimeTotal, -1);
        Arrays.fill(this.dryTimeRemaining, -1);
        this.speedCheckTickCounter = new TickCounter(20, 20);
        this.speed = new TileDataFloat(0.0f, 20);
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler), new TileDataItemStackHandler((ItemStackHandler)this.outputStackHandler), this.speed});
    }

    public ItemStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public ItemStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public float getSpeed() {
        return this.speed.get();
    }

    protected boolean hasInput() {
        for (int i = 0; i < this.inputStackHandler.getSlots(); ++i) {
            if (this.inputStackHandler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void dropContents() {
        ItemStack itemStack;
        int i;
        for (i = 0; i < this.inputStackHandler.getSlots(); ++i) {
            itemStack = this.inputStackHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c, (double)0.0);
        }
        for (i = 0; i < this.outputStackHandler.getSlots(); ++i) {
            itemStack = this.outputStackHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c, (double)0.0);
        }
    }

    @Override
    public boolean workerIsActive() {
        return true;
    }

    @Override
    public void workerSetActive(boolean active) {
        throw new UnsupportedOperationException("Drying rack can't be deactivated.");
    }

    @Override
    protected float workerCalculateProgress(int taskIndex) {
        if (this.dryTimeTotal[taskIndex] == -1) {
            return 0.0f;
        }
        return 1.0f - (float)this.dryTimeRemaining[taskIndex] / (float)this.dryTimeTotal[taskIndex];
    }

    @Override
    public boolean workerDoWork() {
        boolean isDirty = false;
        if (this.speedCheckTickCounter.increment()) {
            this.speed.set(this.updateSpeed());
        }
        for (int slotIndex = 0; slotIndex < this.inputStackHandler.getSlots(); ++slotIndex) {
            ItemStack itemStack = this.inputStackHandler.getStackInSlot(slotIndex);
            if (itemStack.func_190926_b()) continue;
            if (this.dryTimeRemaining[slotIndex] > 0) {
                int n = slotIndex;
                this.partialTicks[n] = this.partialTicks[n] + this.speed.get();
                double fullTicks = Math.floor(this.partialTicks[slotIndex]);
                if (Math.abs(fullTicks) > 0.0) {
                    int n2 = slotIndex;
                    this.partialTicks[n2] = (float)((double)this.partialTicks[n2] - fullTicks);
                    int n3 = slotIndex;
                    this.dryTimeRemaining[n3] = (int)((double)this.dryTimeRemaining[n3] - fullTicks);
                    this.dryTimeRemaining[slotIndex] = Math.max(0, this.dryTimeRemaining[slotIndex]);
                    this.dryTimeRemaining[slotIndex] = Math.min(this.dryTimeTotal[slotIndex], this.dryTimeRemaining[slotIndex]);
                    isDirty = true;
                }
            }
            if (this.dryTimeRemaining[slotIndex] != 0) continue;
            this.initSlotDryTime(slotIndex, -1);
            this.inputStackHandler.extractItem(slotIndex, 64, false);
            DryingRackRecipeBase recipe = this.getRecipe(itemStack);
            if (recipe == null) continue;
            this.outputStackHandler.insertItem(slotIndex, recipe.getOutput(), false);
        }
        if (isDirty) {
            this.func_70296_d();
        }
        return true;
    }

    protected abstract int getSlotCount();

    protected abstract float getMultiplicativeSpeedModifier();

    public abstract DryingRackRecipeBase getRecipe(ItemStack var1);

    private void initSlotDryTime(int slot, int dryTimeTicks) {
        this.dryTimeTotal[slot] = dryTimeTicks;
        this.dryTimeRemaining[slot] = dryTimeTicks;
        this.partialTicks[slot] = 0.0f;
    }

    private float updateSpeed() {
        String registryNameString;
        Float explicitSpeed;
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        boolean canRain = biome.func_76738_d();
        ModuleTechBasicConfig.DryingRackConditionalModifiers modifiers = this.getConditionalModifiers();
        double calculatedSpeed = 0.0;
        Map<String, Float> biomeSpeeds = this.getBiomeSpeeds();
        ResourceLocation registryName = biome.getRegistryName();
        boolean isExplicitBiomeSpeedSet = false;
        if (registryName != null && (explicitSpeed = biomeSpeeds.get(registryNameString = registryName.toString())) != null) {
            calculatedSpeed = explicitSpeed.floatValue();
            isExplicitBiomeSpeedSet = true;
        }
        if (!isExplicitBiomeSpeedSet) {
            if (canRain && this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) {
                calculatedSpeed = modifiers.DIRECT_RAIN;
            } else if (canRain && this.field_145850_b.func_72896_J() || biome.func_76736_e()) {
                calculatedSpeed = modifiers.INDIRECT_RAIN;
            } else if (this.field_145850_b.field_73011_w.func_177495_o()) {
                calculatedSpeed = modifiers.NETHER;
            } else {
                calculatedSpeed = modifiers.BASE_DERIVED;
                if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HOT).contains(biome)) {
                    calculatedSpeed += modifiers.DERIVED_HOT;
                }
                if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DRY).contains(biome)) {
                    calculatedSpeed += modifiers.DERIVED_DRY;
                }
                if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.COLD).contains(biome)) {
                    calculatedSpeed += modifiers.DERIVED_COLD;
                }
                if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WET).contains(biome)) {
                    calculatedSpeed += modifiers.DERIVED_WET;
                }
            }
        }
        float[] fireSourceBonus = new float[1];
        int range = modifiers.FIRE_SOURCE_BONUS_RANGE;
        BlockHelper.forBlocksInCube((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)range, (int)range, (int)range, (w, p, bs) -> {
            if (this.isSpeedBonusBlock(bs, p)) {
                fireSourceBonus[0] = (float)((double)fireSourceBonus[0] + modifiers.FIRE_SOURCE_BONUS);
            }
            return true;
        });
        calculatedSpeed += (double)fireSourceBonus[0];
        if (!this.field_145850_b.func_72896_J() && this.field_145850_b.func_175678_i(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_72820_D() % 24000L > 3000L && this.field_145850_b.func_72820_D() % 24000L < 9000L) {
            calculatedSpeed += modifiers.DAYTIME;
        }
        return (float)(calculatedSpeed * (double)this.getMultiplicativeSpeedModifier());
    }

    protected abstract ModuleTechBasicConfig.DryingRackConditionalModifiers getConditionalModifiers();

    protected abstract Map<String, Float> getBiomeSpeeds();

    private boolean isSpeedBonusBlock(IBlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150480_ab || block.isFireSource(this.field_145850_b, pos, null);
    }

    private int getDryTimeTicks(ItemStack itemStack) {
        DryingRackRecipeBase recipe;
        if (!itemStack.func_190926_b() && (recipe = this.getRecipe(itemStack)) != null) {
            int durationTicks = recipe.getTimeTicks();
            return Math.max(1, durationTicks);
        }
        return -1;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.dryTimeTotal = compound.func_74759_k("dryTimeTotal");
        this.dryTimeRemaining = compound.func_74759_k("dryTimeRemaining");
        this.speed.set(compound.func_74760_g("speed"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74783_a("dryTimeTotal", this.dryTimeTotal);
        compound.func_74783_a("dryTimeRemaining", this.dryTimeRemaining);
        compound.func_74776_a("speed", this.speed.get());
        return compound;
    }

    private class OutputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        OutputStackHandler(int size) {
            super(size);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        InputStackHandler(int size) {
            super(size);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    }
}

