/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi;

import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.spi.BlockAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.network.SCPacketParticleAnvilHit;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileAnvilBase
extends TileNetBase
implements ITileInteractable {
    private final TileDataItemStackHandler<InputStackHandler> tileDataItemStackHandler;
    private InputStackHandler stackHandler = new InputStackHandler(this);
    private TileDataFloat recipeProgress;
    private int durabilityUntilNextDamage;
    private IInteraction[] interactions;
    private AxisAlignedBB renderBounds;

    public TileAnvilBase() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> {
            this.recipeProgress.set(0.0f);
            this.func_70296_d();
        });
        this.recipeProgress = new TileDataFloat(0.0f);
        this.tileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.stackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataItemStackHandler, this.recipeProgress});
        this.interactions = new IInteraction[]{new InteractionItem(), new Interaction(this, (ItemStackHandler)this.stackHandler), new InteractionHit()};
        this.durabilityUntilNextDamage = this.getHitsPerDamage();
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void setDamage(int damage) {
        this.field_145850_b.func_180501_a(this.field_174879_c, this.getBlock().func_176223_P().func_177226_a(BlockAnvilBase.DAMAGE, (Comparable)Integer.valueOf(damage)), 3);
    }

    public int getDamage() {
        return (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockAnvilBase.DAMAGE);
    }

    public void setDurabilityUntilNextDamage(int durabilityUntilNextDamage) {
        this.durabilityUntilNextDamage = durabilityUntilNextDamage;
        this.func_70296_d();
    }

    public int getDurabilityUntilNextDamage() {
        return this.durabilityUntilNextDamage;
    }

    public void setRecipeProgress(float recipeProgress) {
        this.recipeProgress.set(recipeProgress);
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    public abstract int getBloomAnvilExtraDamagePerHit();

    public abstract double getBloomAnvilExtraDamageChance();

    protected abstract int getHitsPerDamage();

    protected abstract double getExhaustionCostPerCraftComplete();

    protected abstract double getExhaustionCostPerHit();

    protected abstract int getHammerHitReduction(ResourceLocation var1);

    protected abstract String[] getPickaxeWhitelist();

    protected abstract String[] getPickaxeBlacklist();

    protected abstract int getMinimumHungerToUse();

    public abstract AnvilRecipe.EnumTier getRecipeTier();

    public abstract boolean useDurability();

    @Nonnull
    protected abstract BlockAnvilBase getBlock();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected abstract boolean allowAutomation();

    @Override
    public void onTileDataUpdate() {
        if (this.tileDataItemStackHandler.isDirty()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        compound.func_74768_a("durabilityUntilNextDamage", this.durabilityUntilNextDamage);
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
        this.durabilityUntilNextDamage = compound.func_74762_e("durabilityUntilNextDamage");
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 0.5, 0.0);
        }
        return this.renderBounds;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileAnvilBase tile;

        public InputStackHandler(TileAnvilBase tile) {
            super(1);
            this.tile = tile;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!stack.func_190926_b() && AnvilRecipe.getRecipe(stack, this.tile.getRecipeTier()) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }

    private class InteractionHit
    extends InteractionUseItemBase<TileAnvilBase> {
        InteractionHit() {
            super(new EnumFacing[]{EnumFacing.UP}, BlockAnvilBase.AABB);
        }

        @Override
        protected boolean allowInteraction(TileAnvilBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (player.func_71024_bL().func_75116_a() < tile.getMinimumHungerToUse()) {
                return false;
            }
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            ResourceLocation resourceLocation = heldItem.getRegistryName();
            if (resourceLocation == null) {
                return false;
            }
            ItemStackHandler stackHandler = tile.getStackHandler();
            ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getSlotLimit(0), true);
            AnvilRecipe recipe = AnvilRecipe.getRecipe(itemStack, tile.getRecipeTier());
            if (recipe == null) {
                return false;
            }
            if (tile.getHammerHitReduction(resourceLocation) > -1) {
                return recipe.getType() == AnvilRecipe.EnumType.HAMMER;
            }
            if (heldItem.getToolClasses(heldItemStack).contains("pickaxe") ? !ArrayHelper.contains((Object[])tile.getPickaxeBlacklist(), (Object)resourceLocation.toString()) : ArrayHelper.contains((Object[])tile.getPickaxeWhitelist(), (Object)resourceLocation.toString())) {
                return recipe.getType() == AnvilRecipe.EnumType.PICKAXE;
            }
            return false;
        }

        @Override
        protected boolean doInteraction(TileAnvilBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStackHandler stackHandler = tile.getStackHandler();
            ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getSlotLimit(0), true);
            AnvilRecipe recipe = AnvilRecipe.getRecipe(itemStack, tile.getRecipeTier());
            boolean isExtendedRecipe = recipe instanceof AnvilRecipe.IExtendedRecipe;
            if (!world.field_72995_K) {
                if (tile.getExhaustionCostPerHit() > 0.0) {
                    player.func_71020_j((float)tile.getExhaustionCostPerHit());
                }
                if (tile.useDurability() && tile.getDurabilityUntilNextDamage() <= 1) {
                    tile.setDurabilityUntilNextDamage(tile.getHitsPerDamage());
                    if (tile.getDamage() + 1 < 4) {
                        tile.setDamage(tile.getDamage() + 1);
                    } else {
                        if (isExtendedRecipe) {
                            ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).onAnvilDurabilityExpired(world, tile, hitX, hitY, hitZ);
                        } else {
                            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)tile.getStackHandler(), (BlockPos)tile.func_174877_v());
                            world.func_175655_b(tile.func_174877_v(), false);
                        }
                        return true;
                    }
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                if (recipe != null) {
                    if (isExtendedRecipe) {
                        ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).applyDamage(world, tile);
                    } else if (tile.useDurability()) {
                        tile.setDurabilityUntilNextDamage(tile.getDurabilityUntilNextDamage() - 1);
                    }
                    if (tile.getRecipeProgress() < 1.0f) {
                        ItemStack heldItemMainHand = player.func_184614_ca();
                        Item item = heldItemMainHand.func_77973_b();
                        int hitReduction = item.getToolClasses(heldItemMainHand).contains("pickaxe") ? item.getHarvestLevel(heldItemMainHand, "pickaxe", player, null) : tile.getHammerHitReduction(item.getRegistryName());
                        int hits = Math.max(1, recipe.getHits() - hitReduction);
                        float recipeProgressIncrement = 1.0f / (float)hits;
                        if (isExtendedRecipe) {
                            recipeProgressIncrement = ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).getModifiedRecipeProgressIncrement(recipeProgressIncrement, tile, player);
                        }
                        tile.setRecipeProgress(tile.getRecipeProgress() + recipeProgressIncrement);
                    }
                    if ((double)tile.getRecipeProgress() >= 0.9999) {
                        if (isExtendedRecipe) {
                            ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).onRecipeCompleted(tile, world, stackHandler, recipe, player);
                        } else {
                            stackHandler.extractItem(0, stackHandler.getSlotLimit(0), false);
                            StackHelper.spawnStackOnTop((World)world, (ItemStack)recipe.getOutput(), (BlockPos)tile.func_174877_v(), (double)0.0);
                        }
                        world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                        if (tile.getExhaustionCostPerCraftComplete() > 0.0) {
                            player.func_71020_j((float)tile.getExhaustionCostPerCraftComplete());
                        }
                        tile.func_70296_d();
                        BlockHelper.notifyBlockUpdate((World)world, (BlockPos)tile.func_174877_v());
                    }
                    ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)hitPos.func_177958_n() + 0.5, hitPos.func_177956_o() + 1, (double)hitPos.func_177952_p() + 0.5, 2), world.field_73011_w.getDimension(), hitPos);
                    ModuleTechBasic.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleAnvilHit(tile.field_174879_c, hitX, hitY, hitZ), (TileEntity)tile);
                }
            }
            return true;
        }
    }

    private class Interaction
    extends InteractionItemStack<TileAnvilBase> {
        private final TileAnvilBase tile;

        Interaction(TileAnvilBase tile, ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, BlockAnvilBase.AABB, new Transform(Transform.translate(0.5, 0.75, 0.5), Transform.rotate(), Transform.scale(0.75, 0.75, 0.75)));
            this.tile = tile;
        }

        @Override
        protected boolean doItemStackValidation(ItemStack itemStack) {
            return AnvilRecipe.getRecipe(itemStack, this.tile.getRecipeTier()) != null;
        }

        @Override
        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            }
        }
    }

    private class InteractionItem
    extends InteractionUseItemBase<TileAnvilBase> {
        InteractionItem() {
            super(new EnumFacing[]{EnumFacing.UP}, BlockAnvilBase.AABB);
        }
    }
}

