/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.inventory.LargeObservableStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.library.util.ParticleHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockSoakingPot;
import com.codetaylor.mc.pyrotech.modules.tech.basic.client.render.SoakingPotFluidRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.SoakingPotRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSoakingPot
extends TileNetBase
implements ITileInteractable,
ITickable {
    private final TileDataFluidTank<InputFluidTank> tileDataFluidTank;
    private final TileDataItemStackHandler<InputStackHandler> tileDataItemStackHandler;
    private InputFluidTank inputFluidTank = new InputFluidTank(this);
    private InputStackHandler inputStackHandler;
    private OutputStackHandler outputStackHandler;
    private TileDataFloat recipeProgress;
    private SoakingPotRecipe currentRecipe;
    private IInteraction[] interactions;
    private boolean firstLightCheck = false;

    public TileSoakingPot() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.inputFluidTank.addObserver((tank, amount) -> {
            this.func_70296_d();
            this.updateRecipe();
            this.ejectItemOverfill();
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        });
        this.outputStackHandler = new OutputStackHandler();
        this.outputStackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.inputStackHandler = new InputStackHandler(this.inputFluidTank, this.outputStackHandler);
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.func_70296_d();
            this.updateRecipe();
        });
        this.recipeProgress = new TileDataFloat(0.0f, 20);
        this.tileDataFluidTank = new TileDataFluidTank((FluidTank)this.inputFluidTank);
        this.tileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataFluidTank, this.tileDataItemStackHandler, new TileDataLargeItemStackHandler((ItemStackHandler)this.outputStackHandler), this.recipeProgress});
        this.interactions = new IInteraction[]{new InteractionInputFluid((FluidTank)this.inputFluidTank), new InteractionItem(this, new ItemStackHandler[]{this.inputStackHandler, this.outputStackHandler})};
    }

    private void ejectItemOverfill() {
        int maxItemCount;
        int fluidAmount;
        int existingItemCount;
        int requiredFluidPerItem;
        int totalFluidRequired;
        if (this.currentRecipe != null && !this.field_145850_b.field_72995_K && (totalFluidRequired = (requiredFluidPerItem = this.currentRecipe.getInputFluid().amount) * (existingItemCount = this.getInputStackHandler().getStackInSlot(0).func_190916_E())) > (fluidAmount = this.getInputFluidTank().getFluidAmount()) && (maxItemCount = fluidAmount / requiredFluidPerItem) < existingItemCount) {
            int toEject = existingItemCount - maxItemCount;
            ItemStack itemStack = this.getInputStackHandler().extractItem(0, toEject, false);
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c, (double)0.5);
        }
    }

    public SoakingPotRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public float getRecipeProgress() {
        if (this.currentRecipe == null) {
            return 0.0f;
        }
        return this.recipeProgress.get();
    }

    public InputStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public InputFluidTank getInputFluidTank() {
        return this.inputFluidTank;
    }

    public OutputStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (facing == EnumFacing.DOWN) {
                    return (T)((Object)this.outputStackHandler);
                }
                return (T)((Object)this.inputStackHandler);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this.inputFluidTank);
            }
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleTechBasicConfig.SOAKING_POT.ALLOW_AUTOMATION;
    }

    @Override
    public void onTileDataUpdate() {
        if (this.tileDataFluidTank.isDirty() || this.tileDataItemStackHandler.isDirty()) {
            this.updateRecipe();
        }
    }

    private void updateRecipe() {
        ItemStack inputItem = this.inputStackHandler.getStackInSlot(0);
        FluidStack fluid = this.inputFluidTank.getFluid();
        this.currentRecipe = inputItem.func_190926_b() || fluid == null || fluid.amount == 0 ? null : SoakingPotRecipe.getRecipe(inputItem, fluid);
    }

    public void func_73660_a() {
        if (!this.firstLightCheck) {
            this.firstLightCheck = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.field_145850_b.field_72995_K) {
            if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.currentRecipe != null && !this.getInputStackHandler().getStackInSlot(0).func_190926_b() && this.field_145850_b.func_82737_E() % 40L == 0L) {
                ParticleHelper.spawnProgressParticlesClient(1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, 0.25, 0.25, 0.25);
            }
            return;
        }
        if (this.currentRecipe != null) {
            int timeTicks = Math.max(1, this.currentRecipe.getTimeTicks());
            float increment = 1.0f / (float)timeTicks;
            ItemStack itemStack = this.inputStackHandler.getStackInSlot(0);
            int maxDrain = this.currentRecipe.getInputFluid().amount * itemStack.func_190916_E();
            FluidStack drain = this.inputFluidTank.drain(maxDrain, false);
            if (drain == null || drain.amount != maxDrain) {
                return;
            }
            this.recipeProgress.add(increment);
            if ((double)this.recipeProgress.get() >= 0.9999) {
                SoakingPotRecipe currentRecipe = this.currentRecipe;
                ItemStack inputItem = this.inputStackHandler.extractItem(0, this.inputStackHandler.getSlotLimit(0), false);
                this.inputFluidTank.drain(currentRecipe.getInputFluid().amount * inputItem.func_190916_E(), true);
                ItemStack output = currentRecipe.getOutput();
                output.func_190920_e(inputItem.func_190916_E() * output.func_190916_E());
                this.outputStackHandler.insertItem(0, output, false);
                this.recipeProgress.set(0.0f);
                this.updateRecipe();
            }
        } else {
            this.recipeProgress.set(0.0f);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.inputFluidTank.readFromNBT(compound.func_74775_l("inputFluidTank"));
        this.recipeProgress.set((float)compound.func_74762_e("recipeProgress"));
        this.updateRecipe();
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_SOAKING_POT;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private int getHotFluidTemperature() {
        return ModuleTechBasicConfig.SOAKING_POT.HOT_TEMPERATURE;
    }

    private boolean canHoldHotFluids() {
        return ModuleTechBasicConfig.SOAKING_POT.HOLDS_HOT_FLUIDS;
    }

    public static class InputFluidTank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileSoakingPot tile;

        InputFluidTank(TileSoakingPot tile) {
            super(ModuleTechBasicConfig.SOAKING_POT.MAX_FLUID_CAPACITY);
            this.tile = tile;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int filled = super.fillInternal(resource, doFill);
            if (!this.tile.canHoldHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                        FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (IFluidHandler)this, (FluidStack)resource);
                        ModuleStorage.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, 0.2, 0.2, 0.2), (TileEntity)this.tile);
                    }
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }
    }

    public static class OutputStackHandler
    extends LargeObservableStackHandler
    implements ITileDataItemStackHandler {
        OutputStackHandler() {
            super(1);
        }
    }

    public static class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final InputFluidTank inputFluidTank;
        private final OutputStackHandler outputStackHandler;

        public InputStackHandler(InputFluidTank inputFluidTank, OutputStackHandler outputStackHandler) {
            super(1);
            this.inputFluidTank = inputFluidTank;
            this.outputStackHandler = outputStackHandler;
        }

        public int getSlotLimit(int slot) {
            return ModuleTechBasicConfig.SOAKING_POT.MAX_STACK_SIZE;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.outputStackHandler.getStackInSlot(0).func_190926_b()) {
                return stack;
            }
            FluidStack fluid = this.inputFluidTank.getFluid();
            if (fluid == null || fluid.amount == 0) {
                return stack;
            }
            SoakingPotRecipe recipe = SoakingPotRecipe.getRecipe(stack, fluid);
            if (recipe == null) {
                return stack;
            }
            int requiredFluidPerItem = recipe.getInputFluid().amount;
            int existingItemCount = this.getStackInSlot(0).func_190916_E();
            if (fluid.amount < requiredFluidPerItem * existingItemCount) {
                return stack;
            }
            ItemStack remainingItems = super.insertItem(slot, stack, true);
            if (remainingItems.func_190916_E() == stack.func_190916_E()) {
                return stack;
            }
            int maxInsertQuantity = stack.func_190916_E() - remainingItems.func_190916_E();
            int actualInsertQuantity = 0;
            for (int i = 0; i < maxInsertQuantity && fluid.amount >= requiredFluidPerItem * (existingItemCount + i + 1); ++i) {
                ++actualInsertQuantity;
            }
            if (actualInsertQuantity == 0) {
                return stack;
            }
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190920_e(actualInsertQuantity);
            super.insertItem(slot, toInsert, simulate);
            ItemStack result = stack.func_77946_l();
            result.func_190920_e(stack.func_190916_E() - actualInsertQuantity);
            return result;
        }
    }

    public static class InteractionInputFluid
    extends InteractionBucketBase<TileSoakingPot> {
        private final FluidTank fluidTank;

        InteractionInputFluid(FluidTank fluidTank) {
            super((IFluidHandler)fluidTank, new EnumFacing[]{EnumFacing.UP}, BlockSoakingPot.AABB);
            this.fluidTank = fluidTank;
        }

        public FluidTank getFluidTank() {
            return this.fluidTank;
        }

        @Override
        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            SoakingPotFluidRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }
    }

    private class InteractionItem
    extends InteractionItemStack<TileSoakingPot> {
        private final TileSoakingPot tile;

        InteractionItem(TileSoakingPot tile, ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.UP}, BlockSoakingPot.AABB, new Transform(Transform.translate(0.5, 0.5, 0.5), Transform.rotate(), Transform.scale(0.375, 0.375, 0.375)));
            this.tile = tile;
        }

        @Override
        protected boolean doItemStackValidation(ItemStack itemStack) {
            FluidStack fluid = this.tile.inputFluidTank.getFluid();
            if (fluid == null) {
                return false;
            }
            if (this.tile.inputStackHandler.insertItem(0, itemStack, true).func_190916_E() == itemStack.func_190916_E()) {
                return false;
            }
            return SoakingPotRecipe.getRecipe(itemStack, fluid) != null;
        }
    }
}

