/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.interaction.api.Quaternion;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.util.ParticleHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CrudeDryingRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.spi.DryingRackRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileDryingRackBase;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileDryingRackCrude
extends TileDryingRackBase
implements ITileInteractable {
    private IInteraction[] interactionHandlers;
    private AxisAlignedBB renderBounds;

    public TileDryingRackCrude() {
        super(1);
        this.interactionHandlers = new IInteraction[]{new Interaction(new ItemStackHandler[]{this.inputStackHandler, this.outputStackHandler})};
    }

    @Override
    public DryingRackRecipeBase getRecipe(ItemStack itemStack) {
        return CrudeDryingRackRecipe.getRecipe(itemStack);
    }

    @Override
    protected ModuleTechBasicConfig.DryingRackConditionalModifiers getConditionalModifiers() {
        return ModuleTechBasicConfig.CRUDE_DRYING_RACK.CONDITIONAL_MODIFIERS;
    }

    @Override
    protected int getSlotCount() {
        return 1;
    }

    @Override
    protected float getMultiplicativeSpeedModifier() {
        return (float)ModuleTechBasicConfig.CRUDE_DRYING_RACK.SPEED_MODIFIER;
    }

    @Override
    protected Map<String, Float> getBiomeSpeeds() {
        return ModuleTechBasicConfig.CrudeDryingRack.BIOME_MODIFIERS;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = new AxisAlignedBB(this.func_174877_v());
        }
        return this.renderBounds;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.getSpeed() > 0.0f && this.hasInput() && this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.displayProgressParticles();
        }
    }

    private void displayProgressParticles() {
        EnumFacing tileFacing = this.getTileFacing(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        switch (tileFacing) {
            case NORTH: {
                ParticleHelper.spawnProgressParticlesClient(1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.125 + 0.125, 0.125, 0.125, 0.0625);
                break;
            }
            case SOUTH: {
                ParticleHelper.spawnProgressParticlesClient(1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.875 - 0.125, 0.125, 0.125, 0.0625);
                break;
            }
            case EAST: {
                ParticleHelper.spawnProgressParticlesClient(1, (double)this.field_174879_c.func_177958_n() + 0.825 - 0.125, (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0625, 0.125, 0.125);
                break;
            }
            case WEST: {
                ParticleHelper.spawnProgressParticlesClient(1, (double)this.field_174879_c.func_177958_n() + 0.125 + 0.125, (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0625, 0.125, 0.125);
            }
        }
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_DRYING_RACK_CRUDE;
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactionHandlers;
    }

    @Override
    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechBasic.Blocks.DRYING_RACK) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return ITileInteractable.super.getTileFacing(world, pos, blockState);
    }

    private class Interaction
    extends InteractionItemStack<TileDryingRackCrude> {
        public Interaction(ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, EnumFacing.field_82609_l, BlockDryingRack.AABB_NORTH, new Transform(new Vec3d(0.5, 0.5, 0.15), new Quaternion(), new Vec3d(0.75, 0.75, 0.75)));
        }

        @Override
        protected int getInsertionIndex(TileDryingRackCrude tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!this.stackHandlers[0].getStackInSlot(this.slot).func_190926_b()) {
                return 0;
            }
            if (!this.stackHandlers[1].getStackInSlot(this.slot).func_190926_b()) {
                return 1;
            }
            return CrudeDryingRackRecipe.getRecipe(player.func_184614_ca()) != null ? 0 : 1;
        }
    }
}

