/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockChoppingBlock;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.ChoppingBlockRecipe;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileChoppingBlock
extends TileNetBase
implements ITileInteractable {
    private InputStackHandler stackHandler = new InputStackHandler();
    private TileDataFloat recipeProgress;
    private int sawdust;
    private int durabilityUntilNextDamage;
    private IInteraction[] interactions;
    private AxisAlignedBB renderBounds;

    public TileChoppingBlock() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> {
            this.recipeProgress.set(0.0f);
            this.func_70296_d();
        });
        this.recipeProgress = new TileDataFloat(0.0f);
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.stackHandler), this.recipeProgress});
        this.interactions = new IInteraction[]{new Interaction(new ItemStackHandler[]{this.stackHandler}), new InteractionShovel(), new InteractionChop()};
        this.durabilityUntilNextDamage = ModuleTechBasicConfig.CHOPPING_BLOCK.CHOPS_PER_DAMAGE;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void setSawdust(int sawdust) {
        this.sawdust = Math.max(0, Math.min(5, sawdust));
        this.func_70296_d();
        BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public int getSawdust() {
        return this.sawdust;
    }

    public void setDamage(int damage) {
        this.field_145850_b.func_180501_a(this.field_174879_c, ModuleTechBasic.Blocks.CHOPPING_BLOCK.func_176223_P().func_177226_a(BlockChoppingBlock.DAMAGE, (Comparable)Integer.valueOf(damage)), 3);
    }

    public int getDamage() {
        return (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockChoppingBlock.DAMAGE);
    }

    private void setDurabilityUntilNextDamage(int durabilityUntilNextDamage) {
        this.durabilityUntilNextDamage = durabilityUntilNextDamage;
        this.func_70296_d();
    }

    private int getDurabilityUntilNextDamage() {
        return this.durabilityUntilNextDamage;
    }

    private void setRecipeProgress(float recipeProgress) {
        this.recipeProgress.set(recipeProgress);
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleTechBasicConfig.CHOPPING_BLOCK.ALLOW_AUTOMATION;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        compound.func_74768_a("sawdust", this.sawdust);
        compound.func_74768_a("durabilityUntilNextDamage", this.durabilityUntilNextDamage);
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
        this.sawdust = compound.func_74762_e("sawdust");
        this.durabilityUntilNextDamage = compound.func_74762_e("durabilityUntilNextDamage");
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 0.5, 0.0);
        }
        return this.renderBounds;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_CHOPPING_BLOCK;
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        InputStackHandler() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || ChoppingBlockRecipe.getRecipe(stack) == null) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    private class InteractionChop
    extends InteractionUseItemBase<TileChoppingBlock> {
        InteractionChop() {
            super(new EnumFacing[]{EnumFacing.UP}, BlockChoppingBlock.AABB);
        }

        @Override
        protected boolean allowInteraction(TileChoppingBlock tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (player.func_71024_bL().func_75116_a() < ModuleTechBasicConfig.CHOPPING_BLOCK.MINIMUM_HUNGER_TO_USE) {
                return false;
            }
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            ResourceLocation resourceLocation = heldItem.getRegistryName();
            if (resourceLocation == null) {
                return false;
            }
            String registryName = resourceLocation.toString();
            if (heldItem.getToolClasses(heldItemStack).contains("axe")) {
                return !ArrayHelper.contains((Object[])ModuleTechBasicConfig.CHOPPING_BLOCK.AXE_BLACKLIST, (Object)registryName);
            }
            return ArrayHelper.contains((Object[])ModuleTechBasicConfig.CHOPPING_BLOCK.AXE_WHITELIST, (Object)registryName);
        }

        @Override
        protected boolean doInteraction(TileChoppingBlock tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            block14: {
                block13: {
                    int[] chops;
                    ItemStackHandler stackHandler;
                    ItemStack itemStack;
                    ChoppingBlockRecipe recipe;
                    ItemStack heldItem;
                    int harvestLevel;
                    if (world.field_72995_K) break block13;
                    if (ModuleTechBasicConfig.CHOPPING_BLOCK.EXHAUSTION_COST_PER_AXE_CHOP > 0.0) {
                        player.func_71020_j((float)ModuleTechBasicConfig.CHOPPING_BLOCK.EXHAUSTION_COST_PER_AXE_CHOP);
                    }
                    if (ModuleTechBasicConfig.CHOPPING_BLOCK.USES_DURABILITY && tile.getDurabilityUntilNextDamage() <= 1) {
                        tile.setDurabilityUntilNextDamage(ModuleTechBasicConfig.CHOPPING_BLOCK.CHOPS_PER_DAMAGE);
                        if (tile.getDamage() + 1 < 6) {
                            tile.setDamage(tile.getDamage() + 1);
                        } else {
                            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)tile.getStackHandler(), (BlockPos)tile.func_174877_v());
                            ItemStack itemStack2 = new ItemStack((Block)ModuleCore.Blocks.ROCK, tile.getSawdust(), BlockRock.EnumType.WOOD_CHIPS.getMeta());
                            StackHelper.spawnStackOnTop((World)world, (ItemStack)itemStack2, (BlockPos)hitPos, (double)0.0);
                            world.func_175655_b(tile.func_174877_v(), false);
                            return true;
                        }
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                    if (tile.getSawdust() < 5 && Math.random() < ModuleTechBasicConfig.CHOPPING_BLOCK.WOOD_CHIPS_CHANCE * 2.0) {
                        tile.setSawdust(tile.getSawdust() + 1);
                    }
                    ArrayList candidates = new ArrayList();
                    if (Math.random() < ModuleTechBasicConfig.CHOPPING_BLOCK.WOOD_CHIPS_CHANCE * 0.5) {
                        BlockHelper.forBlocksInCube((World)world, (BlockPos)tile.func_174877_v(), (int)1, (int)1, (int)1, (w, p, bs) -> {
                            if (w.func_175623_d(p) && ModuleCore.Blocks.ROCK.func_176196_c(w, p) && bs.func_177230_c() != ModuleCore.Blocks.ROCK) {
                                candidates.add(p);
                            }
                            return true;
                        });
                    }
                    if (candidates.size() > 0) {
                        Collections.shuffle(candidates);
                        world.func_175656_a((BlockPos)candidates.get(0), ModuleCore.Blocks.ROCK.func_176223_P().func_177226_a(BlockRock.VARIANT, (Comparable)((Object)BlockRock.EnumType.WOOD_CHIPS)));
                    }
                    if (ModuleTechBasicConfig.CHOPPING_BLOCK.USES_DURABILITY) {
                        tile.setDurabilityUntilNextDamage(tile.getDurabilityUntilNextDamage() - 1);
                    }
                    if ((harvestLevel = (heldItem = player.func_184586_b(hand)).func_77973_b().getHarvestLevel(heldItem, "axe", player, null)) < 0) {
                        harvestLevel = 0;
                    }
                    if ((recipe = ChoppingBlockRecipe.getRecipe(itemStack = (stackHandler = tile.getStackHandler()).getStackInSlot(0))) == null) break block14;
                    ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)hitPos.func_177958_n() + 0.5, (double)hitPos.func_177956_o() + 1.0, (double)hitPos.func_177952_p() + 0.5, 2), world.field_73011_w.getDimension(), hitPos);
                    if (tile.getRecipeProgress() < 1.0f && (chops = recipe.getChops()).length > 0) {
                        float increment = 1.0f / (float)ArrayHelper.getOrLast((int[])chops, (int)harvestLevel);
                        tile.setRecipeProgress(tile.getRecipeProgress() + increment);
                    }
                    if (!((double)tile.getRecipeProgress() >= 0.9999)) break block14;
                    stackHandler.extractItem(0, stackHandler.getSlotLimit(0), false);
                    ItemStack output = recipe.getOutput();
                    int[] quantities = recipe.getQuantities();
                    if (quantities.length > 0) {
                        int quantity = ArrayHelper.getOrLast((int[])quantities, (int)harvestLevel);
                        output.func_190920_e(quantity);
                    }
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)output, (BlockPos)tile.func_174877_v(), (double)0.0);
                    world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                    if (ModuleTechBasicConfig.CHOPPING_BLOCK.EXHAUSTION_COST_PER_CRAFT_COMPLETE > 0.0) {
                        player.func_71020_j((float)ModuleTechBasicConfig.CHOPPING_BLOCK.EXHAUSTION_COST_PER_CRAFT_COMPLETE);
                    }
                    tile.func_70296_d();
                    BlockHelper.notifyBlockUpdate((World)world, (BlockPos)tile.func_174877_v());
                    break block14;
                }
                IBlockState blockState = ModuleTechBasic.Blocks.CHOPPING_BLOCK.func_176223_P();
                for (int i = 0; i < 8; ++i) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)tile.func_174877_v().func_177958_n() + hitX), (double)((float)tile.func_174877_v().func_177956_o() + hitY), (double)((float)tile.func_174877_v().func_177952_p() + hitZ), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)blockState)});
                }
            }
            return true;
        }
    }

    private class InteractionShovel
    extends InteractionUseItemBase<TileChoppingBlock> {
        InteractionShovel() {
            super(EnumFacing.field_82609_l, BlockChoppingBlock.AABB);
        }

        @Override
        protected boolean allowInteraction(TileChoppingBlock tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStack heldItemStack = player.func_184586_b(hand);
            return tile.getSawdust() > 0 && (heldItemStack.func_190926_b() || heldItemStack.func_77973_b().getToolClasses(heldItemStack).contains("shovel"));
        }

        @Override
        protected boolean doInteraction(TileChoppingBlock tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStack heldItem = player.func_184614_ca();
            if (!world.field_72995_K) {
                int sawdust = tile.getSawdust();
                if (ModuleCoreConfig.TWEAKS.REQUIRE_SHOVEL_TO_PICKUP_WOOD_CHIPS) {
                    if (!heldItem.func_190926_b()) {
                        ItemStack itemStack = new ItemStack((Block)ModuleCore.Blocks.ROCK, 1, BlockRock.EnumType.WOOD_CHIPS.getMeta());
                        StackHelper.spawnStackOnTop((World)world, (ItemStack)itemStack, (BlockPos)hitPos, (double)0.0);
                        heldItem.func_77972_a(1, (EntityLivingBase)player);
                    }
                    tile.setSawdust(sawdust - 1);
                } else {
                    tile.setSawdust(sawdust - 1);
                    ItemStack itemStack = new ItemStack((Block)ModuleCore.Blocks.ROCK, 1, BlockRock.EnumType.WOOD_CHIPS.getMeta());
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)itemStack, (BlockPos)hitPos, (double)0.0);
                }
                world.func_184133_a(null, hitPos, SoundEvents.field_187747_eB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (ModuleTechBasicConfig.CHOPPING_BLOCK.EXHAUSTION_COST_PER_SHOVEL_SCOOP > 0.0) {
                    player.func_71020_j((float)ModuleTechBasicConfig.CHOPPING_BLOCK.EXHAUSTION_COST_PER_SHOVEL_SCOOP);
                }
            }
            return true;
        }
    }

    private class Interaction
    extends InteractionItemStack<TileChoppingBlock> {
        Interaction(ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.UP}, BlockChoppingBlock.AABB, new Transform(Transform.translate(0.5, 0.75, 0.5), Transform.rotate(), Transform.scale(0.75, 0.75, 0.75)));
        }

        @Override
        protected boolean doItemStackValidation(ItemStack itemStack) {
            return ChoppingBlockRecipe.getRecipe(itemStack) != null;
        }

        @Override
        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            }
        }
    }
}

