/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.inventory.LIFOStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.athenaeum.util.TickCounter;
import com.codetaylor.mc.pyrotech.interaction.api.InteractionBounds;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionBase;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.library.InteractionUseItemToActivateWorker;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileCombustionWorkerBase;
import com.codetaylor.mc.pyrotech.library.util.ParticleHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockCampfire;
import com.codetaylor.mc.pyrotech.modules.tech.basic.client.render.CampfireInteractionLogRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CampfireRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCampfire
extends TileCombustionWorkerBase
implements ITickable,
ITileInteractable {
    private InputStackHandler inputStackHandler;
    private OutputStackHandler outputStackHandler;
    private FuelStackHandler fuelStackHandler;
    private TileDataInteger ashLevel;
    private TileDataBoolean dead;
    private int cookTime;
    private int cookTimeTotal;
    private TickCounter burnedFoodTickCounter;
    private boolean extinguishedByRain;
    private IInteraction[] interactions;
    private int interactionCooldown;

    public TileCampfire() {
        super(ModuleTechBasic.TILE_DATA_SERVICE, 1);
        this.burnedFoodTickCounter = new TickCounter(ModuleTechBasicConfig.CAMPFIRE.BURNED_FOOD_TICKS);
        this.inputStackHandler = new InputStackHandler();
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.setCookTime(this.getCookTime(handler.getStackInSlot(slot)));
            this.func_70296_d();
        });
        this.outputStackHandler = new OutputStackHandler();
        this.outputStackHandler.addObserver((handler, slot) -> {
            if (handler.getStackInSlot(slot).func_190926_b()) {
                this.burnedFoodTickCounter.reset();
            }
            this.func_70296_d();
        });
        this.fuelStackHandler = new FuelStackHandler();
        this.fuelStackHandler.addObserver((handler, slot) -> {
            this.burnTimeRemaining.forceUpdate();
            this.func_70296_d();
        });
        this.ashLevel = new TileDataInteger(0);
        this.ashLevel.addChangeObserver((TileDataBase.IChangeObserver)new TileDataBase.IChangeObserver.OnDirtyMarkTileDirty((TileEntity)this));
        this.dead = new TileDataBoolean(false);
        this.dead.addChangeObserver((TileDataBase.IChangeObserver)new TileDataBase.IChangeObserver.OnDirtyMarkTileDirty((TileEntity)this));
        this.cookTime = -1;
        this.cookTimeTotal = -1;
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler), new TileDataItemStackHandler((ItemStackHandler)this.outputStackHandler), new TileDataItemStackHandler((ItemStackHandler)this.fuelStackHandler), this.ashLevel, this.dead});
        this.interactions = new IInteraction[]{new InteractionBucket(), new InteractionFood(new ItemStackHandler[]{this.inputStackHandler, this.outputStackHandler}), new InteractionShovel(), new InteractionUseItemToActivateWorker(Items.field_151033_d, EnumFacing.field_82609_l, BlockCampfire.AABB_FULL), new InteractionUseItemToActivateWorker(Items.field_151059_bz, EnumFacing.field_82609_l, BlockCampfire.AABB_FULL, true), new InteractionLog(this)};
    }

    public ItemStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public ItemStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public int getAshLevel() {
        return this.ashLevel.get();
    }

    private void setAshLevel(int ashLevel) {
        this.ashLevel.set(ashLevel);
    }

    private void setCookTime(int cookTime) {
        this.cookTime = cookTime;
        this.cookTimeTotal = cookTime;
    }

    private int getCookTime(ItemStack stack) {
        CampfireRecipe recipe = CampfireRecipe.getRecipe(stack);
        return recipe == null ? -1 : recipe.getTicks();
    }

    public int getFuelRemaining() {
        int index = this.fuelStackHandler.getLastNonEmptyIndex();
        return index + 1;
    }

    public boolean isDead() {
        return this.dead.get();
    }

    private void setDead() {
        this.dead.set(true);
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockCampfire.VARIANT, (Comparable)((Object)BlockCampfire.EnumType.ASH)));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP) {
                return (T)((Object)this.inputStackHandler);
            }
            if (facing == EnumFacing.DOWN) {
                return (T)((Object)this.outputStackHandler);
            }
            return (T)((Object)this.fuelStackHandler);
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleTechBasicConfig.CAMPFIRE.ALLOW_AUTOMATION;
    }

    @Override
    protected int combustionGetInitialBurnTimeRemaining() {
        return ModuleCoreConfig.FUEL.TINDER_BURN_TIME_TICKS;
    }

    @Override
    protected int combustionGetBurnTimeForFuel(ItemStack fuel) {
        return ModuleTechBasicConfig.CAMPFIRE.BURN_TIME_TICKS_PER_LOG;
    }

    @Override
    protected ItemStack combustionGetFuelItem() {
        return this.fuelStackHandler.extractItem(0, 1, false);
    }

    @Override
    protected int combustionGetRainDeactivateTime() {
        if (ModuleTechBasicConfig.CAMPFIRE.EXTINGUISHED_BY_RAIN) {
            return ModuleTechBasicConfig.CAMPFIRE.TICKS_BEFORE_EXTINGUISHED;
        }
        return -1;
    }

    @Override
    protected void combustionOnDeactivatedByRain() {
        this.extinguishedByRain = true;
    }

    @Override
    public void workerSetActive(boolean active) {
        if (this.isDead()) {
            return;
        }
        if (this.workerIsActive() && !active) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModuleTechBasic.Blocks.CAMPFIRE) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockCampfire.VARIANT, (Comparable)((Object)BlockCampfire.EnumType.NORMAL)));
            }
        } else if (!this.workerIsActive() && active && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModuleTechBasic.Blocks.CAMPFIRE) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockCampfire.VARIANT, (Comparable)((Object)BlockCampfire.EnumType.LIT)));
        }
        super.workerSetActive(active);
        if (active) {
            this.interactionCooldown = 5;
        }
    }

    @Override
    public boolean workerIsActive() {
        return !this.isDead() && super.workerIsActive();
    }

    @Override
    public boolean workerConsumeFuel() {
        if (super.workerConsumeFuel()) {
            return true;
        }
        this.setDead();
        ItemStack contents = this.inputStackHandler.extractItem(0, 64, false);
        if (!contents.func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)contents, (BlockPos)this.field_174879_c, (double)-0.125);
        }
        if (!(contents = this.outputStackHandler.extractItem(0, 64, false)).func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)contents, (BlockPos)this.field_174879_c, (double)-0.125);
        }
        return false;
    }

    @Override
    protected float workerCalculateProgress(int taskIndex) {
        if (this.cookTime < 0) {
            return 0.0f;
        }
        return 1.0f - (float)this.cookTime / (float)this.cookTimeTotal;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.workerIsActive() && !this.getInputStackHandler().getStackInSlot(0).func_190926_b() && this.field_145850_b.func_82737_E() % 40L == 0L) {
            ParticleHelper.spawnProgressParticlesClient(1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.85, (double)this.field_174879_c.func_177952_p() + 0.5, 0.25, 0.3, 0.25);
        }
        if (this.workerIsActive() && !this.getOutputStackHandler().getStackInSlot(0).func_190926_b() && this.field_145850_b.func_82737_E() % 5L == 0L) {
            for (int i = 0; i < 4; ++i) {
                double offsetX = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.4;
                double offsetY = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.4;
                double offsetZ = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.4;
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + offsetX;
                double y = (double)this.field_174879_c.func_177956_o() + 0.6 + offsetY;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + offsetZ;
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean workerDoWork() {
        CampfireRecipe recipe;
        ItemStack itemStack;
        if (!super.workerDoWork()) {
            return false;
        }
        if (this.ashLevel.get() == 8) {
            return false;
        }
        if (Math.random() < 0.05 && this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().isFlammable((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177977_b(), EnumFacing.UP)) {
            this.field_145850_b.func_180501_a(this.field_174879_c.func_177977_b(), Blocks.field_150480_ab.func_176223_P(), 3);
            return false;
        }
        if (this.cookTime > 0) {
            --this.cookTime;
        }
        if (this.cookTime == 0 && !(itemStack = this.inputStackHandler.extractItem(0, 1, false)).func_190926_b() && (recipe = CampfireRecipe.getRecipe(itemStack)) != null) {
            ItemStack result = recipe.getOutput();
            this.outputStackHandler.insertItem(0, result, false);
        }
        if (!this.outputStackHandler.getStackInSlot(0).func_190926_b()) {
            ItemStack stackInSlot = this.outputStackHandler.getStackInSlot(0);
            if (stackInSlot.func_77973_b() != ModuleCore.Items.BURNED_FOOD && stackInSlot.func_77973_b() instanceof ItemFood && this.burnedFoodTickCounter.increment()) {
                this.outputStackHandler.setStackInSlot(0, new ItemStack((Item)ModuleCore.Items.BURNED_FOOD));
            }
        } else {
            this.burnedFoodTickCounter.reset();
        }
        if (this.combustionGetBurnTimeRemaining() <= 0 && Math.random() < ModuleTechBasicConfig.CAMPFIRE.ASH_CHANCE) {
            this.ashLevel.add(1);
        }
        return true;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74782_a("fuelStackHandler", (NBTBase)this.fuelStackHandler.serializeNBT());
        compound.func_74757_a("dead", this.dead.get());
        compound.func_74768_a("ashLevel", this.ashLevel.get());
        compound.func_74768_a("cookTime", this.cookTime);
        compound.func_74768_a("cookTimeTotal", this.cookTimeTotal);
        compound.func_74757_a("extinguishedByRain", this.extinguishedByRain);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.fuelStackHandler.deserializeNBT(compound.func_74775_l("fuelStackHandler"));
        this.dead.set(compound.func_74767_n("dead"));
        this.ashLevel.set(compound.func_74762_e("ashLevel"));
        this.cookTime = compound.func_74762_e("cookTime");
        this.cookTimeTotal = compound.func_74762_e("cookTimeTotal");
        this.extinguishedByRain = compound.func_74767_n("extinguishedByRain");
    }

    public void dropContents() {
        ItemStack itemStack;
        if (this.isDead()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)ItemMaterial.EnumType.PIT_ASH.asStack(1), (BlockPos)this.field_174879_c, (double)-0.125);
        } else if (!this.extinguishedByRain && !this.workerIsActive()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)new ItemStack((Item)ModuleTechBasic.Items.TINDER), (BlockPos)this.field_174879_c, (double)-0.125);
        }
        for (int i = 0; i < this.fuelStackHandler.getSlots() && !(itemStack = this.fuelStackHandler.extractItem(i, 64, false)).func_190926_b(); ++i) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c, (double)-0.125);
        }
        ItemStackHandler stackHandler = this.getInputStackHandler();
        itemStack = stackHandler.extractItem(0, 64, false);
        if (!itemStack.func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c, (double)-0.125);
        }
        if (!(itemStack = (stackHandler = this.getOutputStackHandler()).extractItem(0, 64, false)).func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c, (double)-0.125);
        }
        if (this.ashLevel.get() > 0) {
            ItemStack ashStack = ItemMaterial.EnumType.PIT_ASH.asStack(this.ashLevel.get());
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)ashStack, (BlockPos)this.field_174879_c, (double)-0.125);
        }
        BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Override
    public void onTileDataUpdate() {
        if (this.ashLevel.isDirty()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
        if (this.active.isDirty()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.dead.isDirty() && this.dead.get()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v());
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_CAMPFIRE;
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    @Override
    public int getInteractionCooldown() {
        return this.interactionCooldown;
    }

    private class FuelStackHandler
    extends LIFOStackHandler
    implements ITileDataItemStackHandler {
        FuelStackHandler() {
            super(8);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!ModuleTechBasicConfig.CAMPFIRE.isValidFuel(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    private class OutputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        OutputStackHandler() {
            super(1);
        }
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        InputStackHandler() {
            super(1);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || CampfireRecipe.getRecipe(stack) == null || !TileCampfire.this.outputStackHandler.getStackInSlot(0).func_190926_b()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    private class InteractionShovel
    extends InteractionBase<TileCampfire> {
        InteractionShovel() {
            super(EnumFacing.field_82609_l, BlockCampfire.AABB_FULL);
        }

        @Override
        public boolean interact(IInteraction.EnumType type, TileCampfire tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (type != IInteraction.EnumType.MouseClick) {
                return false;
            }
            ItemStack heldItem = player.func_184614_ca();
            if (tile.getAshLevel() > 0 && heldItem.func_77973_b().getToolClasses(heldItem).contains("shovel")) {
                if (!world.field_72995_K) {
                    tile.setAshLevel(tile.getAshLevel() - 1);
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)ItemMaterial.EnumType.PIT_ASH.asStack(), (BlockPos)hitPos, (double)0.0);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                    world.func_184133_a(null, hitPos, SoundEvents.field_187747_eB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }
    }

    public static class InteractionLog
    extends InteractionBase<TileCampfire> {
        private ItemStack lastItemChecked;
        private boolean lastItemValid;
        private final TileCampfire tile;

        InteractionLog(TileCampfire tile) {
            super(EnumFacing.field_82609_l, BlockCampfire.AABB_FULL);
            this.tile = tile;
        }

        public int getLogCount() {
            int firstEmptyIndex = this.tile.fuelStackHandler.getFirstEmptyIndex();
            return firstEmptyIndex == -1 ? this.tile.fuelStackHandler.getSlots() : firstEmptyIndex;
        }

        public ItemStack getLog(int slot) {
            return this.tile.fuelStackHandler.getStackInSlot(slot);
        }

        @Override
        public boolean isEnabled() {
            return !this.tile.isDead();
        }

        public boolean isItemStackValid(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return false;
            }
            return this.doItemStackValidation(itemStack);
        }

        private boolean doItemStackValidation(ItemStack itemStack) {
            return ModuleTechBasicConfig.CAMPFIRE.isValidFuel(itemStack);
        }

        @Override
        public boolean interact(IInteraction.EnumType type, TileCampfire tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStack heldItem = player.func_184614_ca();
            if (type == IInteraction.EnumType.MouseClick && heldItem.func_190926_b() || type == IInteraction.EnumType.MouseWheelDown) {
                ItemStack itemStack = tile.fuelStackHandler.extractItem(0, 1, world.field_72995_K);
                if (!itemStack.func_190926_b()) {
                    if (!world.field_72995_K) {
                        if (ModuleTechBasicConfig.CAMPFIRE.PLAYER_LOG_BURN_DAMAGE > 0.0 && Math.random() < ModuleTechBasicConfig.CAMPFIRE.PLAYER_BURN_CHANCE && !player.func_70045_F() && !EnchantmentHelper.func_189869_j((EntityLivingBase)player) && ModuleTechBasic.Blocks.CAMPFIRE.func_176221_a(state, (IBlockAccess)world, hitPos).func_177229_b(BlockCampfire.VARIANT) == BlockCampfire.EnumType.LIT) {
                            player.func_70097_a(DamageSource.field_190095_e, (float)ModuleTechBasicConfig.CAMPFIRE.PLAYER_LOG_BURN_DAMAGE);
                        }
                        StackHelper.addToInventoryOrSpawn((World)world, (EntityPlayer)player, (ItemStack)itemStack, (BlockPos)hitPos, (double)-0.125, (boolean)false, (type == IInteraction.EnumType.MouseClick ? 1 : 0) != 0);
                    }
                    return true;
                }
            } else if ((type == IInteraction.EnumType.MouseClick && !heldItem.func_190926_b() || type == IInteraction.EnumType.MouseWheelUp) && this.isItemStackValid(heldItem)) {
                int firstEmptyIndex;
                FuelStackHandler fuelStackHandler = tile.fuelStackHandler;
                if (!world.field_72995_K && (firstEmptyIndex = fuelStackHandler.getFirstEmptyIndex()) > -1) {
                    fuelStackHandler.insertItem(0, new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77960_j()), false);
                    world.func_184133_a(null, hitPos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            CampfireInteractionLogRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        @Override
        public boolean forceRenderAdditivePassWhileSneaking() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return CampfireInteractionLogRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }

    private class InteractionFood
    extends InteractionItemStack<TileCampfire> {
        InteractionFood(ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.UP}, BlockCampfire.AABB_FULL, new Transform(Transform.translate(0.5, 0.5, 0.5), Transform.rotate(), Transform.scale(0.75, 0.75, 0.75)));
        }

        @Override
        public boolean isEnabled() {
            return !TileCampfire.this.isDead();
        }

        @Override
        protected boolean doItemStackValidation(ItemStack itemStack) {
            return CampfireRecipe.getRecipe(itemStack) != null;
        }

        @Override
        public boolean interact(IInteraction.EnumType type, TileCampfire tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (player.func_70093_af() && type == IInteraction.EnumType.MouseClick) {
                return false;
            }
            return super.interact(type, tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
        }
    }

    private class InteractionBucket
    extends InteractionBucketBase<TileCampfire> {
        public InteractionBucket() {
            super((IFluidHandler)new FluidTank(1000){

                public boolean canFillFluidType(FluidStack fluid) {
                    return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
                }

                public int fillInternal(FluidStack resource, boolean doFill) {
                    int filled = super.fillInternal(resource, doFill);
                    this.setFluid(null);
                    return filled;
                }
            }, EnumFacing.field_82609_l, InteractionBounds.BLOCK);
        }

        @Override
        protected boolean doInteraction(TileCampfire tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!tile.workerIsActive() || tile.isDead()) {
                return false;
            }
            if (super.doInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ)) {
                tile.combustionOnDeactivatedByRain();
                tile.workerSetActive(false);
                if (!world.field_72995_K) {
                    SoundHelper.playSoundServer((World)world, (BlockPos)tile.func_174877_v(), (SoundEvent)SoundEvents.field_187646_bt, (SoundCategory)SoundCategory.BLOCKS);
                }
                return true;
            }
            return false;
        }
    }
}

