/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.recipe;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WorktableRecipe
extends IForgeRegistryEntry.Impl<WorktableRecipe>
implements IRecipeSingleOutput {
    private static final Map<ResourceLocation, WorktableRecipe> CACHE = new HashMap<ResourceLocation, WorktableRecipe>();
    private static final Set<ResourceLocation> WHITELIST = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> BLACKLIST = new HashSet<ResourceLocation>();
    private static boolean BLACKLIST_ALL = false;
    private final IRecipe recipe;
    private final List<Item> toolList;
    private final int toolDamage;
    private final Stages stages;

    public static void blacklistAll() {
        BLACKLIST_ALL = true;
    }

    @Nullable
    public static WorktableRecipe getRecipe(InventoryCrafting inventory, World world) {
        IRecipe recipe;
        if (!BLACKLIST_ALL && (recipe = CraftingManager.func_192413_b((InventoryCrafting)inventory, (World)world)) != null) {
            WorktableRecipe result = WorktableRecipe.getWrappedRecipe(recipe);
            if (result != null) {
                return result;
            }
            return WorktableRecipe.getCustomRecipe(inventory, world);
        }
        return WorktableRecipe.getCustomRecipe(inventory, world);
    }

    @Nullable
    public static WorktableRecipe getRecipe(ResourceLocation resourceLocation) {
        WorktableRecipe cachedRecipe = CACHE.get(resourceLocation);
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        IRecipe vanillaRecipe = (IRecipe)ForgeRegistries.RECIPES.getValue(resourceLocation);
        if (vanillaRecipe != null) {
            return WorktableRecipe.getWrappedRecipe(vanillaRecipe);
        }
        return WorktableRecipe.getCustomRecipe(resourceLocation);
    }

    @Nullable
    private static WorktableRecipe getWrappedRecipe(IRecipe recipe) {
        ResourceLocation resourceLocation = recipe.getRegistryName();
        WorktableRecipe cachedRecipe = CACHE.get(resourceLocation);
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (WorktableRecipe.hasWhitelist()) {
            if (WorktableRecipe.isWhitelisted(resourceLocation)) {
                WorktableRecipe worktableRecipe = new WorktableRecipe(recipe, resourceLocation);
                CACHE.put(resourceLocation, worktableRecipe);
                return worktableRecipe;
            }
            return null;
        }
        if (WorktableRecipe.hasBlacklist()) {
            if (!WorktableRecipe.isBlacklisted(resourceLocation)) {
                WorktableRecipe worktableRecipe = new WorktableRecipe(recipe, resourceLocation);
                CACHE.put(resourceLocation, worktableRecipe);
                return worktableRecipe;
            }
            return null;
        }
        WorktableRecipe worktableRecipe = new WorktableRecipe(recipe, resourceLocation);
        CACHE.put(resourceLocation, worktableRecipe);
        return worktableRecipe;
    }

    public static boolean hasRecipeWithTool(Item tool) {
        for (WorktableRecipe worktableRecipe : ModuleTechBasic.Registries.WORKTABLE_RECIPE) {
            List<Item> toolList = worktableRecipe.getToolList();
            if (!toolList.contains(tool)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static WorktableRecipe getCustomRecipe(InventoryCrafting inventory, World world) {
        for (WorktableRecipe worktableRecipe : ModuleTechBasic.Registries.WORKTABLE_RECIPE) {
            if (!worktableRecipe.matches(inventory, world)) continue;
            return worktableRecipe;
        }
        return null;
    }

    @Nullable
    private static WorktableRecipe getCustomRecipe(ResourceLocation resourceLocation) {
        return (WorktableRecipe)ModuleTechBasic.Registries.WORKTABLE_RECIPE.getValue(resourceLocation);
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechBasic.Registries.WORKTABLE_RECIPE, (Ingredient)output);
    }

    public static void blacklistVanillaRecipe(ResourceLocation resourceLocation) {
        BLACKLIST.add(resourceLocation);
    }

    public static void whitelistVanillaRecipe(ResourceLocation resourceLocation) {
        WHITELIST.add(resourceLocation);
    }

    public static boolean hasBlacklist() {
        return BLACKLIST_ALL || !BLACKLIST.isEmpty() || ModuleTechBasicConfig.WORKTABLE_COMMON.RECIPE_BLACKLIST.length > 0;
    }

    public static boolean hasWhitelist() {
        return !WHITELIST.isEmpty() || ModuleTechBasicConfig.WORKTABLE_COMMON.RECIPE_WHITELIST.length > 0;
    }

    public static boolean isBlacklisted(ResourceLocation resourceLocation) {
        return BLACKLIST_ALL && !"crafttweaker".equals(resourceLocation.func_110624_b()) || WorktableRecipe.matchesResourceLocation(resourceLocation, BLACKLIST) || WorktableRecipe.matchesResourceLocation(resourceLocation, ModuleTechBasicConfig.WORKTABLE_COMMON.RECIPE_BLACKLIST);
    }

    public static boolean isWhitelisted(ResourceLocation resourceLocation) {
        return WorktableRecipe.matchesResourceLocation(resourceLocation, WHITELIST) || WorktableRecipe.matchesResourceLocation(resourceLocation, ModuleTechBasicConfig.WORKTABLE_COMMON.RECIPE_WHITELIST);
    }

    private static boolean matchesResourceLocation(ResourceLocation resourceLocation, String[] list) {
        String resourceLocationString = resourceLocation.toString();
        for (String configString : list) {
            String[] split;
            if (!(configString.endsWith("*") ? (split = configString.split(":"))[0].equals(resourceLocation.func_110624_b()) : configString.equals(resourceLocationString))) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesResourceLocation(ResourceLocation resourceLocation, Set<ResourceLocation> set) {
        for (ResourceLocation blacklistLocation : set) {
            if ("*".equals(blacklistLocation.func_110623_a()) && resourceLocation.func_110624_b().equals(blacklistLocation.func_110624_b())) {
                return true;
            }
            if (!resourceLocation.equals((Object)blacklistLocation)) continue;
            return true;
        }
        return false;
    }

    public WorktableRecipe(IRecipe recipe, ResourceLocation resourceLocation) {
        this(recipe, null, 0, null);
        this.setRegistryName(resourceLocation);
    }

    public WorktableRecipe(IRecipe recipe, @Nullable Ingredient tool, int toolDamage, @Nullable Stages stages) {
        ItemStack[] matchingStacks;
        this.recipe = recipe;
        this.toolDamage = toolDamage;
        this.toolList = new ArrayList<Item>();
        this.stages = stages;
        if (tool != null && (matchingStacks = tool.func_193365_a()).length > 0) {
            Stream.of(matchingStacks).map(ItemStack::func_77973_b).collect(Collectors.toCollection(() -> this.toolList));
        }
    }

    @Nonnull
    public IRecipe getRecipe() {
        return this.recipe;
    }

    public List<Item> getToolList() {
        return this.toolList;
    }

    public int getToolDamage() {
        return this.toolDamage;
    }

    public Stages getStages() {
        return this.stages;
    }

    public ItemStack getOutput() {
        return this.recipe.func_77571_b().func_77946_l();
    }

    public boolean matches(InventoryCrafting inventory, World world) {
        return this.recipe.func_77569_a(inventory, world);
    }
}

