/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.recipe;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.spi.recipe.IRecipeTimed;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoakingPotRecipe
extends IForgeRegistryEntry.Impl<SoakingPotRecipe>
implements IRecipeSingleOutput,
IRecipeTimed {
    private final ItemStack output;
    private final Ingredient inputItem;
    private final FluidStack inputFluid;
    private final int timeTicks;

    @Nullable
    public static SoakingPotRecipe getRecipe(ItemStack inputItem, FluidStack inputFluid) {
        for (SoakingPotRecipe recipe : ModuleTechBasic.Registries.SOAKING_POT_RECIPE) {
            if (!recipe.matches(inputItem, inputFluid)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechBasic.Registries.SOAKING_POT_RECIPE, (Ingredient)output);
    }

    public SoakingPotRecipe(ItemStack output, Ingredient inputItem, FluidStack inputFluid, int timeTicks) {
        this.output = output;
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.timeTicks = timeTicks;
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public int getTimeTicks() {
        return (int)Math.max(1.0, (double)this.timeTicks * ModuleTechBasicConfig.SOAKING_POT.BASE_RECIPE_DURATION_MODIFIER);
    }

    public boolean matches(ItemStack inputItem, FluidStack inputFluid) {
        return this.inputItem.apply(inputItem) && this.inputFluid.isFluidEqual(inputFluid);
    }
}

