/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.recipe;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.spi.recipe.IRecipeTimed;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class KilnPitRecipe
extends IForgeRegistryEntry.Impl<KilnPitRecipe>
implements IRecipeSingleOutput,
IRecipeTimed {
    private final Ingredient input;
    private final ItemStack output;
    private final int burnTimeTicks;
    private final float failureChance;
    private final ItemStack[] failureItems;

    @Nullable
    public static KilnPitRecipe getRecipe(ItemStack input) {
        for (KilnPitRecipe recipe : ModuleTechBasic.Registries.KILN_PIT_RECIPE) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechBasic.Registries.KILN_PIT_RECIPE, (Ingredient)output);
    }

    public KilnPitRecipe(ItemStack output, Ingredient input, int burnTimeTicks, float failureChance, ItemStack[] failureItems) {
        this.input = input;
        this.output = output;
        this.burnTimeTicks = burnTimeTicks;
        this.failureChance = MathHelper.func_76131_a((float)failureChance, (float)0.0f, (float)1.0f);
        this.failureItems = failureItems;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public int getTimeTicks() {
        return (int)Math.max(1.0, (double)this.burnTimeTicks * ModuleTechBasicConfig.PIT_KILN.BASE_RECIPE_DURATION_MODIFIER);
    }

    public float getFailureChance() {
        return this.failureChance;
    }

    public ItemStack[] getFailureItems() {
        return this.failureItems;
    }

    public boolean matches(ItemStack input) {
        return this.input.apply(input);
    }
}

