/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.recipe;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AnvilRecipe
extends IForgeRegistryEntry.Impl<AnvilRecipe>
implements IRecipeSingleOutput {
    private final Ingredient input;
    private final ItemStack output;
    private final int hits;
    private final EnumType type;
    private final EnumTier[] tiers;

    @Nullable
    public static AnvilRecipe getRecipe(ItemStack input, EnumTier tier) {
        for (AnvilRecipe recipe : ModuleTechBasic.Registries.ANVIL_RECIPE) {
            if (!recipe.matches(input, tier)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechBasic.Registries.ANVIL_RECIPE, (Ingredient)output);
    }

    public AnvilRecipe(ItemStack output, Ingredient input, int hits, EnumType type, EnumTier tier) {
        this(output, input, hits, type, new EnumTier[]{tier});
    }

    public AnvilRecipe(ItemStack output, Ingredient input, int hits, EnumType type, EnumTier[] tiers) {
        this.input = input;
        this.output = output;
        this.hits = hits;
        this.type = type;
        this.tiers = tiers;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getHits() {
        return this.hits;
    }

    public EnumType getType() {
        return this.type;
    }

    public boolean isTier(EnumTier tier) {
        return ArrayHelper.contains((Object[])this.tiers, (Object)((Object)tier));
    }

    public boolean matches(ItemStack input, EnumTier tier) {
        return this.isTier(tier) && this.input.apply(input);
    }

    public static interface IExtendedRecipe<T extends AnvilRecipe> {
        public void applyDamage(World var1, TileAnvilBase var2);

        public float getModifiedRecipeProgressIncrement(float var1, TileAnvilBase var2, EntityPlayer var3);

        public void onRecipeCompleted(TileAnvilBase var1, World var2, ItemStackHandler var3, T var4, EntityPlayer var5);

        public void onAnvilHitClient(World var1, TileAnvilBase var2, float var3, float var4, float var5);

        public void onAnvilDurabilityExpired(World var1, TileAnvilBase var2, float var3, float var4, float var5);

        default public boolean allowInheritance() {
            return false;
        }
    }

    public static enum EnumType {
        HAMMER,
        PICKAXE;

    }

    public static enum EnumTier {
        GRANITE,
        IRONCLAD;

    }
}

