/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.provider;

import com.codetaylor.mc.pyrotech.library.spi.plugin.waila.BodyProviderAdapter;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.library.util.plugin.waila.WailaUtil;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate.WorktableProviderDelegate;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileWorktable;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class WorktableProvider
extends BodyProviderAdapter
implements WorktableProviderDelegate.IWorktableDisplay {
    private final WorktableProviderDelegate delegate = new WorktableProviderDelegate(this);
    private List<String> tooltip;

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileWorktable) {
            this.tooltip = tooltip;
            this.delegate.display((TileWorktable)tileEntity, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void setRecipeProgress(ItemStack input, ItemStack output, int progress, int maxProgress) {
        String renderString = WailaUtil.getStackRenderString(input) + WailaUtil.getProgressRenderString(progress, maxProgress) + WailaUtil.getStackRenderString(output);
        this.tooltip.add(renderString);
    }

    @Override
    public void setRecipeOutputName(ItemStack itemStack) {
        this.tooltip.add(itemStack.func_82833_r());
    }

    @Override
    public void setCondition(String langKey, String textColorString, String conditionLangKey) {
        String condition = Util.translateFormatted(conditionLangKey, new Object[0]);
        this.tooltip.add(Util.translateFormatted(langKey, textColorString, condition));
    }

    @Override
    public void setHoveredItem(ItemStack stackInSlot) {
        String displayName = stackInSlot.func_82833_r();
        int count = stackInSlot.func_190916_E();
        if (count == 1) {
            this.tooltip.add(displayName);
        } else {
            String localized = Util.translateFormatted("gui.pyrotech.waila.quantity", displayName, count);
            this.tooltip.add(localized);
        }
    }
}

