/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteractionItemStack;
import com.codetaylor.mc.pyrotech.interaction.util.InteractionRayTraceData;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.plugin.gamestages.GameStages;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.WorktableRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileWorktable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.ItemStackHandler;

public class WorktableProviderDelegate
extends ProviderDelegateBase<IWorktableDisplay, TileWorktable> {
    public static final String LANG_KEY_HOVERED_ITEM_QUANTITY = "gui.pyrotech.waila.quantity";
    private List<Item> hammers;

    public WorktableProviderDelegate(IWorktableDisplay display) {
        super(display);
    }

    @Override
    public void display(TileWorktable tile) {
        this.display(tile, null);
    }

    public void display(TileWorktable tile, @Nullable EntityPlayer player) {
        int durability;
        int remainingDurability;
        float d;
        float progress = tile.getRecipeProgress();
        ItemStackHandler stackHandler = tile.getInputStackHandler();
        boolean notEmpty = false;
        for (int i = 0; i < 9; ++i) {
            if (stackHandler.getStackInSlot(i).func_190926_b()) continue;
            notEmpty = true;
            break;
        }
        if (notEmpty) {
            ItemStack recipeOutput;
            IRecipe recipe = tile.getRecipe();
            WorktableRecipe worktableRecipe = tile.getWorktableRecipe();
            boolean displayRecipe = false;
            if (recipe != null && worktableRecipe != null && player != null) {
                if (Loader.isModLoaded((String)"gamestages")) {
                    Stages stages = worktableRecipe.getStages();
                    displayRecipe = GameStages.allowed(player, stages);
                } else {
                    displayRecipe = true;
                }
            }
            if (displayRecipe && !(recipeOutput = recipe.func_77572_b((InventoryCrafting)tile.getInventoryWrapper())).func_190926_b()) {
                List<Item> toolList;
                if (!worktableRecipe.getToolList().isEmpty()) {
                    toolList = worktableRecipe.getToolList();
                } else {
                    if (this.hammers == null) {
                        this.hammers = new ArrayList<Item>();
                        for (String s : ModuleCoreConfig.HAMMERS.HAMMER_LIST) {
                            String[] split = s.split(";");
                            Item item = Item.func_111206_d((String)split[0]);
                            if (item == null) continue;
                            this.hammers.add(item);
                        }
                    }
                    toolList = this.hammers;
                }
                if (toolList.isEmpty()) {
                    ((IWorktableDisplay)this.display).setRecipeProgress(new ItemStack(Blocks.field_150462_ai), recipeOutput, (int)(100.0f * progress), 100);
                } else {
                    int index = (int)(tile.func_145831_w().func_82737_E() / 29L % (long)toolList.size());
                    Item item = toolList.get(index);
                    ((IWorktableDisplay)this.display).setRecipeProgress(new ItemStack(item), recipeOutput, (int)(100.0f * progress), 100);
                }
                ((IWorktableDisplay)this.display).setRecipeOutputName(recipeOutput);
            }
        }
        if ((double)(d = (float)(remainingDurability = tile.getRemainingDurability()) / (float)(durability = tile.getDurability())) < 0.25) {
            ((IWorktableDisplay)this.display).setCondition("gui.pyrotech.waila.worktable.condition", TextFormatting.RED.toString(), "gui.pyrotech.waila.worktable.condition.fractured");
        } else if ((double)d < 0.5) {
            ((IWorktableDisplay)this.display).setCondition("gui.pyrotech.waila.worktable.condition", TextFormatting.YELLOW.toString(), "gui.pyrotech.waila.worktable.condition.used");
        } else if ((double)d < 0.75) {
            ((IWorktableDisplay)this.display).setCondition("gui.pyrotech.waila.worktable.condition", TextFormatting.GOLD.toString(), "gui.pyrotech.waila.worktable.condition.fair");
        } else {
            ((IWorktableDisplay)this.display).setCondition("gui.pyrotech.waila.worktable.condition", TextFormatting.GREEN.toString(), "gui.pyrotech.waila.worktable.condition.good");
        }
        if (player != null) {
            int distance = 5;
            Vec3d posVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            RayTraceResult rayTraceResult = tile.func_145831_w().func_72901_a(posVec, posVec.func_178787_e(player.func_70040_Z().func_186678_a((double)distance)), false);
            if (rayTraceResult == null) {
                return;
            }
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            if (rayTraceResult.hitInfo instanceof InteractionRayTraceData.List) {
                InteractionRayTraceData.List list = (InteractionRayTraceData.List)rayTraceResult.hitInfo;
                for (InteractionRayTraceData data : list) {
                    ItemStack stackInSlot;
                    IInteraction interaction = data.getInteraction();
                    if (!interaction.isEnabled() || !(interaction instanceof IInteractionItemStack) || (stackInSlot = ((IInteractionItemStack)interaction).getStackInSlot()).func_190926_b()) continue;
                    ((IWorktableDisplay)this.display).setHoveredItem(stackInSlot);
                }
            }
        }
    }

    public static interface IWorktableDisplay {
        public void setRecipeProgress(ItemStack var1, ItemStack var2, int var3, int var4);

        public void setRecipeOutputName(ItemStack var1);

        public void setCondition(String var1, String var2, String var3);

        public void setHoveredItem(ItemStack var1);
    }
}

