/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.library.CompactingBinRecipeBase;
import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompactingBin;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class CompactingBinProviderDelegate
extends ProviderDelegateBase<ICompactingBinDisplay, TileCompactingBin> {
    public CompactingBinProviderDelegate(ICompactingBinDisplay display) {
        super(display);
    }

    @Override
    public void display(TileCompactingBin tile) {
        CompactingBinRecipeBase currentRecipe = tile.getCurrentRecipe();
        if (currentRecipe == null) {
            return;
        }
        float progress = tile.getRecipeProgress();
        TileCompactingBin.InputStackHandler inputStackHandler = tile.getInputStackHandler();
        int totalItemCount = tile.getInputStackHandler().getTotalItemCount();
        int completeRecipeCount = totalItemCount / currentRecipe.getAmount();
        if (totalItemCount > 0) {
            if (completeRecipeCount == 0) {
                ((ICompactingBinDisplay)this.display).setRecipeInput((ItemStackHandler)inputStackHandler);
            } else {
                ItemStack output = currentRecipe.getOutput();
                output.func_190920_e(completeRecipeCount);
                ((ICompactingBinDisplay)this.display).setRecipeProgress((ItemStackHandler)inputStackHandler, output, (int)(100.0f * progress), 100);
            }
        }
    }

    public static interface ICompactingBinDisplay {
        public void setRecipeInput(ItemStackHandler var1);

        public void setRecipeProgress(ItemStackHandler var1, ItemStack var2, int var3, int var4);
    }
}

