/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper;

import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.RenderHelper;
import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.IPyrotechRecipeWrapper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomAnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class JEIRecipeWrapperAnvil
implements IPyrotechRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final List<List<ItemStack>> output;
    private final int hits;
    private final AnvilRecipe.EnumType type;
    private final AnvilRecipe recipe;

    public JEIRecipeWrapperAnvil(AnvilRecipe recipe) {
        this.inputs = Collections.singletonList(Arrays.asList(recipe.getInput().func_193365_a()));
        if (recipe instanceof BloomAnvilRecipe) {
            BloomeryRecipeBase bloomeryRecipe = ((BloomAnvilRecipe)recipe).getBloomeryRecipe();
            BloomeryRecipeBase.FailureItem[] failureItems = bloomeryRecipe.getFailureItems();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(failureItems.length + 1);
            result.add(recipe.getOutput());
            for (BloomeryRecipeBase.FailureItem failureItem : failureItems) {
                result.add(failureItem.getItemStack().func_77946_l());
            }
            this.output = Collections.singletonList(result);
        } else {
            this.output = Collections.singletonList(Collections.singletonList(recipe.getOutput()));
        }
        this.hits = recipe.getHits();
        this.type = recipe.getType();
        this.recipe = recipe;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Object[] toolWhitelist;
        if (this.type == AnvilRecipe.EnumType.HAMMER) {
            toolWhitelist = ModuleCoreConfig.HAMMERS.HAMMER_LIST;
        } else if (this.type == AnvilRecipe.EnumType.PICKAXE) {
            toolWhitelist = ModuleTechBasicConfig.ANVIL_COMMON.JEI_HARVEST_LEVEL_PICKAXE;
        } else {
            throw new RuntimeException("Unknown recipe type: " + (Object)((Object)this.type));
        }
        int length = toolWhitelist.length;
        int index = (int)(minecraft.field_71441_e.func_82737_E() / 39L % (long)length);
        String locationString = ((String)ArrayHelper.getOrLast((Object[])toolWhitelist, (int)index)).split(";")[0];
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(locationString));
        int hits = this.hits;
        if (item != null) {
            hits = this.type == AnvilRecipe.EnumType.HAMMER ? (hits -= ModuleTechBasicConfig.ANVIL_COMMON.getHammerHitReduction(item.getRegistryName())) : (hits -= item.getHarvestLevel(null, "pickaxe", null, null));
            hits = Math.max(1, hits);
            RenderItem renderItem = minecraft.func_175599_af();
            ItemStack stack = new ItemStack(item);
            IBakedModel model = renderItem.func_184393_a(stack, null, null);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            int stage = (int)(minecraft.field_71441_e.func_82737_E() % 39L / 20L);
            GlStateManager.func_179109_b((float)8.0f, (float)(5 + stage * 4), (float)100.0f);
            GlStateManager.func_179114_b((float)(-90 + stage * -90), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
            RenderHelper.renderItemModel((ItemStack)stack, (IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false, (boolean)false);
            GlStateManager.func_179121_F();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)250.0f);
        minecraft.field_71466_p.func_175065_a("x" + hits, 18.0f, 2.0f, -1, true);
        if (this.recipe instanceof BloomAnvilRecipe) {
            BloomeryRecipeBase bloomeryRecipe = ((BloomAnvilRecipe)this.recipe).getBloomeryRecipe();
            int bloomYieldMin = bloomeryRecipe.getBloomYieldMin();
            int bloomYieldMax = bloomeryRecipe.getBloomYieldMax();
            String text = bloomYieldMin + "-" + bloomYieldMax;
            int width = minecraft.field_71466_p.func_78256_a(text);
            minecraft.field_71466_p.func_175065_a(text, (float)(82 - width), 5.0f, -1, true);
        }
        GlStateManager.func_179121_F();
    }
}

