/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.network;

import com.codetaylor.mc.athenaeum.spi.packet.PacketBlockPosBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class SCPacketParticleAnvilHit
extends PacketBlockPosBase<SCPacketParticleAnvilHit> {
    private float hitX;
    private float hitY;
    private float hitZ;

    public SCPacketParticleAnvilHit() {
    }

    public SCPacketParticleAnvilHit(BlockPos pos, float hitX, float hitY, float hitZ) {
        super(pos);
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.hitX = buf.readFloat();
        this.hitY = buf.readFloat();
        this.hitZ = buf.readFloat();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(SCPacketParticleAnvilHit message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = message.blockPos;
        float hitX = message.hitX;
        float hitY = message.hitY;
        float hitZ = message.hitZ;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileAnvilBase) {
            TileAnvilBase tile = (TileAnvilBase)tileEntity;
            IBlockState blockState = world.func_180495_p(pos);
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)tile.func_174877_v().func_177958_n() + hitX), (double)((float)tile.func_174877_v().func_177956_o() + hitY), (double)((float)tile.func_174877_v().func_177952_p() + hitZ), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)blockState)});
            }
            ItemStackHandler stackHandler = tile.getStackHandler();
            ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getSlotLimit(0), true);
            AnvilRecipe recipe = AnvilRecipe.getRecipe(itemStack, tile.getRecipeTier());
            if (recipe instanceof AnvilRecipe.IExtendedRecipe) {
                ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).onAnvilHitClient((World)world, tile, hitX, hitY, hitZ);
            }
        }
        return null;
    }
}

