/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block;

import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileDryingRackCrude;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileDryingRackBase;
import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDryingRack
extends BlockPartialBase
implements IBlockVariant<EnumType>,
IBlockInteractable {
    public static final String NAME = "drying_rack";
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB = AABBHelper.create((double)1.0, (double)11.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.6875, 0.0, 1.0, 1.0, 0.3125);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.6875, 0.6875, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.6875, 0.6875, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0, 0.6875, 0.0, 0.3125, 1.0, 1.0);

    public BlockDryingRack() {
        super(Material.field_151575_d);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(VARIANT, (Comparable)((Object)EnumType.CRUDE)));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 150;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileDryingRackBase) {
            ((TileDryingRackBase)tileEntity).dropContents();
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        IBlockState blockState;
        EnumFacing horizontalFacing = facing.func_176734_d();
        if (horizontalFacing == EnumFacing.UP || horizontalFacing == EnumFacing.DOWN) {
            horizontalFacing = placer.func_174811_aO();
        }
        if ((blockState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()))).func_177230_c() == this && blockState.func_177229_b(VARIANT) == EnumType.CRUDE) {
            horizontalFacing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta))).func_177226_a((IProperty)FACING, (Comparable)horizontalFacing);
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == EnumType.CRUDE) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            switch (facing) {
                case NORTH: {
                    return AABB_NORTH;
                }
                case SOUTH: {
                    return AABB_SOUTH;
                }
                case EAST: {
                    return AABB_EAST;
                }
                case WEST: {
                    return AABB_WEST;
                }
            }
        }
        return AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        return type == EnumType.CRUDE || type == EnumType.NORMAL;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.CRUDE) {
            return new TileDryingRackCrude();
        }
        if (type == EnumType.NORMAL) {
            return new TileDryingRack();
        }
        return null;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState blockStateUp;
        if (state.func_177230_c() == this && state.func_177229_b(VARIANT) == EnumType.NORMAL && (blockStateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this && state.func_177229_b(VARIANT) == EnumType.NORMAL) {
            return state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.STACKED));
        }
        return super.func_176221_a(state, world, pos);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            if (type == EnumType.STACKED) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta >> 2 & 1))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta() << 2 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    @Nonnull
    public String getModelName(ItemStack itemStack) {
        return EnumType.fromMeta(itemStack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return VARIANT;
    }

    public static enum EnumType implements IVariant
    {
        CRUDE(0, "crude"),
        NORMAL(1, "normal"),
        STACKED(2, "stacked");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

