/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block;

import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleLava;
import com.codetaylor.mc.pyrotech.modules.ignition.item.ItemIgniterBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCampfire;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockCampfire
extends BlockPartialBase
implements IBlockInteractable,
IBlockIgnitableWithIgniterItem,
IBlockIgnitableAdjacentIgniterBlock {
    public static final String NAME = "campfire";
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyInteger ASH = PropertyInteger.func_177719_a((String)"ash", (int)0, (int)8);
    public static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final AxisAlignedBB AABB_TINDER = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.3125, 0.75);
    private static final AxisAlignedBB AABB_ASH_A = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.0625, 0.875);
    private static final AxisAlignedBB AABB_ASH_B = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
    private static final AxisAlignedBB AABB_ASH_C = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    private static final AxisAlignedBB AABB_ASH_D = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private static final AxisAlignedBB AABB_ASH_E = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.3125, 0.875);
    private static final AxisAlignedBB AABB_ASH_F = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.375, 0.875);
    private static final AxisAlignedBB AABB_ASH_G = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.4375, 0.875);
    private static final AxisAlignedBB AABB_ASH_H = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);

    public BlockCampfire() {
        super(Material.field_151575_d);
        this.func_149711_c(0.5f);
    }

    @Override
    public void igniteWithIgniterItem(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCampfire) {
            ((TileCampfire)tileEntity).workerSetActive(true);
        }
    }

    @Override
    public void igniteWithAdjacentIgniterBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        this.igniteWithIgniterItem(world, pos, blockState, facing);
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileCampfire)) {
            return SoundType.field_185850_c;
        }
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)world, pos);
        if (((TileCampfire)tileEntity).getFuelRemaining() > 0) {
            return SoundType.field_185848_a;
        }
        if (actualState.func_177229_b(VARIANT) == EnumType.ASH) {
            return SoundType.field_185855_h;
        }
        return SoundType.field_185850_c;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, world, pos);
        if (actualState.func_177229_b(VARIANT) == EnumType.LIT) {
            return MathHelper.func_76125_a((int)ModuleTechBasicConfig.CAMPFIRE.LIGHT_LEVEL, (int)0, (int)15);
        }
        return super.getLightValue(state, world, pos);
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCampfire && ((TileCampfire)tileEntity).workerIsActive()) {
            double offsetZ;
            double offsetX;
            int i;
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 2.0 / 16.0;
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            for (i = 0; i < 4; ++i) {
                offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
            }
            if (!((TileCampfire)tileEntity).getOutputStackHandler().getStackInSlot(0).func_190926_b()) {
                for (i = 0; i < 8; ++i) {
                    offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tileEntity = source.func_175625_s(pos);
        if (!(tileEntity instanceof TileCampfire)) {
            return field_185506_k;
        }
        IBlockState actualState = this.func_176221_a(state, source, pos);
        if (((TileCampfire)tileEntity).getFuelRemaining() > 0) {
            return AABB_FULL;
        }
        switch ((Integer)actualState.func_177229_b((IProperty)ASH)) {
            default: {
                return actualState.func_177229_b(VARIANT) == EnumType.ASH ? AABB_ASH_A : AABB_TINDER;
            }
            case 1: {
                return AABB_ASH_A;
            }
            case 2: {
                return AABB_ASH_B;
            }
            case 3: {
                return AABB_ASH_C;
            }
            case 4: {
                return AABB_ASH_D;
            }
            case 5: {
                return AABB_ASH_E;
            }
            case 6: {
                return AABB_ASH_F;
            }
            case 7: {
                return AABB_ASH_G;
            }
            case 8: 
        }
        return AABB_ASH_H;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos).func_177229_b(VARIANT) == EnumType.LIT;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof ItemIgniterBase) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileCampfire)) {
            return false;
        }
        TileCampfire campfire = (TileCampfire)tileEntity;
        if (campfire.isDead()) {
            return false;
        }
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (ModuleTechBasicConfig.CAMPFIRE.ENTITY_WALK_BURN_DAMAGE > 0.0 && !entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity)) && this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos).func_177229_b(VARIANT) == EnumType.LIT) {
            entity.func_70097_a(DamageSource.field_190095_e, (float)ModuleTechBasicConfig.CAMPFIRE.ENTITY_WALK_BURN_DAMAGE);
        }
        super.func_176199_a(world, pos, entity);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IBlockState blockState;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCampfire) {
            ((TileCampfire)tileEntity).dropContents();
        }
        if ((blockState = world.func_180495_p(pos)).func_177230_c() == this && blockState.func_177229_b(VARIANT) == EnumType.LIT) {
            int level = 4;
            int dimension = world.field_73011_w.getDimension();
            ModuleTechBasic.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleLava(pos, level), dimension, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return 0;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCampfire();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            world.func_175655_b(pos, false);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, ASH});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCampfire) {
            TileCampfire tileCampfire = (TileCampfire)tileEntity;
            int ashLevel = tileCampfire.getAshLevel();
            return state.func_177226_a((IProperty)ASH, (Comparable)Integer.valueOf(ashLevel));
        }
        return super.func_176221_a(state, world, pos);
    }

    public static enum EnumType implements IVariant
    {
        NORMAL(0, "normal"),
        LIT(1, "lit"),
        ASH(2, "ash"),
        ITEM(3, "item");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

