/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic;

import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;

@Config(modid="pyrotech", name="pyrotech/module.tech.Basic")
public class ModuleTechBasicConfig {
    @Config.Ignore
    public static final List<Ingredient> CAMPFIRE_FUEL_WHITELIST = new ArrayList<Ingredient>(1);
    @Config.Ignore
    public static final List<Ingredient> CAMPFIRE_FUEL_BLACKLIST = new ArrayList<Ingredient>(1);
    @Config.Ignore
    public static Stages STAGES_WORKTABLE = null;
    @Config.Ignore
    public static Stages STAGES_WORKTABLE_STONE = null;
    @Config.Ignore
    public static Stages STAGES_SOAKING_POT = null;
    @Config.Ignore
    public static Stages STAGES_PIT_KILN = null;
    @Config.Ignore
    public static Stages STAGES_DRYING_RACK_CRUDE = null;
    @Config.Ignore
    public static Stages STAGES_DRYING_RACK = null;
    @Config.Ignore
    public static Stages STAGES_COMPACTING_BIN = null;
    @Config.Ignore
    public static Stages STAGES_CHOPPING_BLOCK = null;
    @Config.Ignore
    public static Stages STAGES_CAMPFIRE = null;
    @Config.Ignore
    public static Stages STAGES_ANVIL_IRONCLAD = null;
    @Config.Ignore
    public static Stages STAGES_ANVIL_GRANITE = null;
    public static WorktableCommon WORKTABLE_COMMON = new WorktableCommon();
    public static Worktable WORKTABLE = new Worktable();
    public static StoneWorktable STONE_WORKTABLE = new StoneWorktable();
    public static CompactingBin COMPACTING_BIN = new CompactingBin();
    public static SoakingPot SOAKING_POT = new SoakingPot();
    public static AnvilCommon ANVIL_COMMON = new AnvilCommon();
    public static GraniteAnvil GRANITE_ANVIL = new GraniteAnvil();
    public static IroncladAnvil IRONCLAD_ANVIL = new IroncladAnvil();
    public static ChoppingBlock CHOPPING_BLOCK = new ChoppingBlock();
    public static CrudeDryingRack CRUDE_DRYING_RACK = new CrudeDryingRack();
    public static DryingRack DRYING_RACK = new DryingRack();
    public static PitKiln PIT_KILN = new PitKiln();
    public static Campfire CAMPFIRE = new Campfire();

    public static class Campfire {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"The light level of the campfire when lit.", "Default: 11"})
        @Config.RangeInt(min=0, max=15)
        public int LIGHT_LEVEL = 11;
        @Config.Comment(value={"How many ticks to cook food on the campfire.", "Default: 1800"})
        @Config.RangeInt(min=1)
        public int COOK_TIME_TICKS = 1800;
        @Config.Comment(value={"The amount of ticks of burn time added to the campfire", "for each log consumed.", "Default: 2400"})
        @Config.RangeInt(min=1)
        public int BURN_TIME_TICKS_PER_LOG = 2400;
        @Config.Comment(value={"How many ticks does it take before the output food becomes burned food.", "Default: 600"})
        @Config.RangeInt(min=1)
        public int BURNED_FOOD_TICKS = 600;
        @Config.Comment(value={"Set to true if the campfire should be extinguished by rain.", "Default: true"})
        public boolean EXTINGUISHED_BY_RAIN = true;
        @Config.Comment(value={"The number of ticks that the campfire can be exposed to rain before", "it is extinguished.", "Default: 200"})
        @Config.RangeInt(min=1)
        public int TICKS_BEFORE_EXTINGUISHED = 200;
        @Config.Comment(value={"The chance that the campfire will produce ash when a fuel is consumed.", "Default: 0.25"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double ASH_CHANCE = 0.25;
        @Config.Comment(value={"The chance that the player will be damaged with fire when picking", "up a log while the campfire is lit.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double PLAYER_BURN_CHANCE = 0.5;
        @Config.Comment(value={"The amount of damage done to a player when picking up a log while the", "campfire is lit.", "Default: 1.0"})
        @Config.RangeDouble(min=0.0)
        public double PLAYER_LOG_BURN_DAMAGE = 1.0;
        @Config.Comment(value={"The amount of damage done to an entity when walking on top of a lit campfire.", "Set to zero to disable.", "Default: 1.0"})
        @Config.RangeDouble(min=0.0)
        public double ENTITY_WALK_BURN_DAMAGE = 1.0;
        @Config.Comment(value={"If true, all 'logWood' items will be valid fuel for the campfire.", "Default: true"})
        public boolean USE_LOG_WOOD_OREDICT = true;

        public boolean isValidFuel(ItemStack fuel) {
            if (this.USE_LOG_WOOD_OREDICT && OreDictHelper.contains((String)"logWood", (ItemStack)fuel) && this.isNotBlacklistedFuel(fuel)) {
                return true;
            }
            for (Ingredient ingredient : CAMPFIRE_FUEL_WHITELIST) {
                if (!ingredient.apply(fuel)) continue;
                return this.isNotBlacklistedFuel(fuel);
            }
            return false;
        }

        private boolean isNotBlacklistedFuel(ItemStack fuel) {
            for (Ingredient ingredient : CAMPFIRE_FUEL_BLACKLIST) {
                if (!ingredient.apply(fuel)) continue;
                return false;
            }
            return true;
        }
    }

    public static class PitKiln {
        @Config.Comment(value={"The maximum stack size that can be placed in the pit kiln.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int MAX_STACK_SIZE = 8;
        @Config.Comment(value={"Multiplicative modifier applied to every recipe in this device.", "recipeDurationTicks = recipeDurationTicks * BASE_RECIPE_DURATION_MODIFIER", "Default: 1"})
        @Config.RangeDouble(min=0.0)
        public double BASE_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"SPEED_SCALAR=(1-VARIABLE_SPEED_MODIFIER)PERCENTAGE_FULL+VARIABLE_SPEED_MODIFIER", "", "If set to 0.5, the Pit Kiln will complete 1 item in 50% of the time.", "For each item added after the first, the duration increases linearly", "until it is 100% when full.", "Setting the value to 0 is not recommended as it will cause one", "item to complete instantly.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double VARIABLE_SPEED_MODIFIER = 0.5;
    }

    public static class DryingRack {
        @Config.Ignore
        public static final Map<String, Float> BIOME_MODIFIERS = new HashMap<String, Float>();
        @Config.Comment(value={"speed = speed * SPEED_MODIFIER", "Default: 1.35"})
        @Config.RangeDouble
        public double SPEED_MODIFIER = 1.35;
        @Config.Comment(value={"If true, all the crude drying rack recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_CRUDE_DRYING_RACK_RECIPES = true;
        @Config.Comment(value={"Multiplicative modifier applied to the duration of all inherited recipes.", "Default: 1.0"})
        @Config.RangeDouble(min=0.0)
        public double INHERITED_CRUDE_DRYING_RACK_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"Multiplicative modifier applied to every recipe in this device.", "recipeDurationTicks = recipeDurationTicks * BASE_RECIPE_DURATION_MODIFIER", "Default: 1"})
        @Config.RangeDouble(min=0.0)
        public double BASE_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"Set to true to allow the player to climb the sides of drying racks.", "Default: true"})
        public boolean USE_AS_LADDER = true;
        @Config.Comment(value={"Set the up / down movement speed for climbing.", "Default: 0.1"})
        public double CLIMB_SPEED = 0.1;
        public DryingRackConditionalModifiers CONDITIONAL_MODIFIERS = new DryingRackConditionalModifiers();
    }

    public static class CrudeDryingRack {
        @Config.Ignore
        public static final Map<String, Float> BIOME_MODIFIERS = new HashMap<String, Float>();
        @Config.Comment(value={"speed = speed * SPEED_MODIFIER", "Default: 1.0"})
        @Config.RangeDouble
        public double SPEED_MODIFIER = 1.0;
        @Config.Comment(value={"Multiplicative modifier applied to every recipe in this device.", "recipeDurationTicks = recipeDurationTicks * BASE_RECIPE_DURATION_MODIFIER", "Default: 1"})
        @Config.RangeDouble(min=0.0)
        public double BASE_RECIPE_DURATION_MODIFIER = 1.0;
        public DryingRackConditionalModifiers CONDITIONAL_MODIFIERS = new DryingRackConditionalModifiers();
    }

    public static class DryingRackConditionalModifiers {
        @Config.Comment(value={"The base speed if the device is being directly rained on.", "Default: -1"})
        public double DIRECT_RAIN = -1.0;
        @Config.Comment(value={"The base speed if the it is raining, but not directly on the device, or", "the biome has high humidity.", "Default: 0.25"})
        public double INDIRECT_RAIN = 0.25;
        @Config.Comment(value={"The base speed if the device is in the Nether.", "Default: 2"})
        public double NETHER = 2.0;
        @Config.Comment(value={"The base derived speed.", "Default: 1"})
        public double BASE_DERIVED = 1.0;
        @Config.Comment(value={"Added to the base derived speed if the biome is hot.", "Default: 0.2"})
        public double DERIVED_HOT = 0.2f;
        @Config.Comment(value={"Added to the base derived speed if the biome is dry.", "Default: 0.2"})
        public double DERIVED_DRY = 0.2f;
        @Config.Comment(value={"Added to the base derived speed if the biome is cold.", "Default: -0.2"})
        public double DERIVED_COLD = -0.2f;
        @Config.Comment(value={"Added to the base derived speed if the biome is wet.", "Default: -0.2"})
        public double DERIVED_WET = -0.2f;
        @Config.Comment(value={"The device will gain a bonus for each fire source within this range.", "Default: 2"})
        public int FIRE_SOURCE_BONUS_RANGE = 2;
        @Config.Comment(value={"Added to the base derived speed for each fire source block in range.", "Default: 0.2"})
        public double FIRE_SOURCE_BONUS = 0.2f;
        @Config.Comment(value={"Added to the base derived speed if it isn't raining, the device has a", "direct line of sight to the sky, and it's daytime.", "Default: 0.2"})
        public double DAYTIME = 0.2f;
    }

    public static class ChoppingBlock {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Any item with a tool class of axe is automatically valid.", "Use this to add items that you want to be valid that don't have the", "axe tool class. Items you add are assumed to have durability.", "", "The whitelist takes priority over the blacklist.", "", "String format is a resource location: (domain):(path)"})
        public String[] AXE_WHITELIST = new String[0];
        @Config.Comment(value={"Any item with a tool class of axe is automatically valid.", "Use this to remove items that you don't want to be valid.", "", "The whitelist takes priority over the blacklist.", "", "String format is a resource location: (domain):(path)"})
        public String[] AXE_BLACKLIST = new String[0];
        @Config.Comment(value={"The number of chops required per harvest level of the axe used.", "The index into the array is the harvest level, the value at that index", "is the required number of chops. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "ie. {wood, stone, iron, diamond}", "Valid values are in the range: [1,+int]", "Default: {6, 4, 2, 2}"})
        public int[] CHOPS_REQUIRED_PER_HARVEST_LEVEL = new int[]{6, 4, 2, 2};
        @Config.Comment(value={"The recipe result quantity given per harvest level of the axe used.", "The index into the array is the harvest level, the value at that index", "is the recipe result quantity. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "ie. {wood, stone, iron, diamond}", "Valid values are in the range: [0,+int]", "Default: {1, 2, 3, 4}"})
        public int[] RECIPE_RESULT_QUANTITY_PER_HARVEST_LEVEL = new int[]{1, 2, 3, 4};
        @Config.Comment(value={"The item displayed to represent each harvest level in JEI.", "The index into the array is the harvest level, the value at that index", "is the displayed item. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "String format is a resource location: (domain):(path)"})
        public String[] JEI_HARVEST_LEVEL_ITEM = new String[]{"pyrotech:crude_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:diamond_axe"};
        @Config.Comment(value={"The chance that a chop will spawn wood chips nearby.", "Default: 0.05"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double WOOD_CHIPS_CHANCE = 0.05;
        @Config.Comment(value={"The number of times the block can be chopped on before applying damage", "to the block. The block has a total of six damage stages. This number", "represents the number of chops for just one damage stage.", "Default: 16"})
        @Config.RangeInt(min=1)
        public int CHOPS_PER_DAMAGE = 16;
        @Config.Comment(value={"How much exhaustion to apply per axe chop.", "Default: 1.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_AXE_CHOP = 1.5;
        @Config.Comment(value={"How much exhaustion to apply per shovel scoop.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_SHOVEL_SCOOP = 0.5;
        @Config.Comment(value={"How much exhaustion to apply per completed craft.", "Default: 0"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_CRAFT_COMPLETE = 0.0;
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
        @Config.Comment(value={"Set to false to prevent the device from wearing out.", "Default: true"})
        public boolean USES_DURABILITY = true;
    }

    public static class IroncladAnvil {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"The number of times the block can be hit before applying damage", "to the block. The block has a total of four damage stages. This number", "represents the number of hits for just one damage stage.", "Default: 256"})
        @Config.RangeInt(min=1)
        public int HITS_PER_DAMAGE = 256;
        @Config.Comment(value={"The amount of extra damage to apply to the anvil damage when hitting a bloom.", "Default: 1"})
        @Config.RangeInt(min=0)
        public int BLOOM_EXTRA_DAMAGE_PER_HIT = 1;
        @Config.Comment(value={"The chance that extra damage will be applied when hitting a bloom.", "Default: 0.05"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double BLOOM_EXTRA_DAMAGE_CHANCE = 0.05;
        @Config.Comment(value={"How much exhaustion to apply per hit.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_HIT = 0.5;
        @Config.Comment(value={"How much exhaustion to apply per completed craft.", "Default: 0"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_CRAFT_COMPLETE = 0.0;
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
        @Config.Comment(value={"If true, all the granite anvil recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_GRANITE_ANVIL_RECIPES = true;
        @Config.Comment(value={"Multiplicative modifier applied to the required hits for all inherited recipes.", "Default: 1.0"})
        @Config.RangeDouble(min=0.0)
        public double INHERITED_GRANITE_ANVIL_RECIPE_HIT_MODIFIER = 1.0;
        @Config.Comment(value={"Set to false to prevent the device from wearing out.", "Default: true"})
        public boolean USE_DURABILITY = true;
    }

    public static class GraniteAnvil {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"The number of times the block can be hit before applying damage", "to the block. The block has a total of four damage stages. This number", "represents the number of hits for just one damage stage.", "Default: 64"})
        @Config.RangeInt(min=1)
        public int HITS_PER_DAMAGE = 64;
        @Config.Comment(value={"The amount of extra damage to apply to the anvil damage when hitting a bloom.", "Default: 1"})
        @Config.RangeInt(min=0)
        public int BLOOM_EXTRA_DAMAGE_PER_HIT = 1;
        @Config.Comment(value={"The chance that extra damage will be applied when hitting a bloom.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double BLOOM_EXTRA_DAMAGE_CHANCE = 0.5;
        @Config.Comment(value={"How much exhaustion to apply per hit.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_HIT = 0.5;
        @Config.Comment(value={"How much exhaustion to apply per completed craft.", "Default: 0"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_CRAFT_COMPLETE = 0.0;
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
        @Config.Comment(value={"Set to false to prevent the device from wearing out.", "Default: true"})
        public boolean USE_DURABILITY = true;
    }

    public static class AnvilCommon {
        @Config.Comment(value={"These values are used to reduce the number of hits required to complete", "a recipe.", "", "The index into the array is the harvest level, the value at that index", "is the hit reduction. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "ie. {wood, stone, iron, diamond}", "Default: {0, 1, 2, 3}"})
        public int[] HIT_REDUCTION_PER_HAMMER_HARVEST_LEVEL = new int[]{0, 1, 2, 3};
        @Config.Comment(value={"Use this to add items that you want to be valid for pickaxe recipes.", "Items you add are assumed to have durability.", "", "String format is a resource location: (domain):(path)"})
        public String[] PICKAXE_WHITELIST = new String[0];
        @Config.Comment(value={"Use this to add items that you want to be invalid for pickaxe recipes.", "Items you add are assumed to have durability.", "", "String format is a resource location: (domain):(path)"})
        public String[] PICKAXE_BLACKLIST = new String[0];
        @Config.Comment(value={"The pickaxe displayed to represent each harvest level in JEI.", "The index into the array is the harvest level, the value at that index", "is the displayed item. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "String format is a resource location: (domain):(path)"})
        public String[] JEI_HARVEST_LEVEL_PICKAXE = new String[]{"pyrotech:crude_pickaxe", "minecraft:stone_pickaxe", "minecraft:iron_pickaxe", "minecraft:diamond_pickaxe"};

        public int getHammerHitReduction(ResourceLocation resourceLocation) {
            int hammerHarvestLevel = ModuleCoreConfig.HAMMERS.getHammerHarvestLevel(resourceLocation);
            if (hammerHarvestLevel > -1) {
                return ArrayHelper.getOrLast((int[])this.HIT_REDUCTION_PER_HAMMER_HARVEST_LEVEL, (int)hammerHarvestLevel);
            }
            return -1;
        }
    }

    public static class SoakingPot {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"The maximum stack size that can be placed in the pot.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int MAX_STACK_SIZE = 8;
        @Config.Comment(value={"The maximum fluid capacity in millibuckets.", "Default: 4000"})
        @Config.RangeInt(min=1)
        public int MAX_FLUID_CAPACITY = 4000;
        @Config.Comment(value={"The temperature that the container considers hot.", "The temperature of lava is 1300 and water is 300", "Default: 450"})
        @Config.RangeInt
        public int HOT_TEMPERATURE = 450;
        @Config.Comment(value={"If false, the container will break when a hot fluid is placed inside,", "and the fluid will spawn in the world where the tank was.", "Default: true"})
        public boolean HOLDS_HOT_FLUIDS = false;
        @Config.Comment(value={"Multiplicative modifier applied to every recipe in this device.", "recipeDurationTicks = recipeDurationTicks * BASE_RECIPE_DURATION_MODIFIER", "Default: 1"})
        @Config.RangeDouble(min=0.0)
        public double BASE_RECIPE_DURATION_MODIFIER = 1.0;
    }

    public static class CompactingBin {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Any item with a tool class of shovel is automatically valid.", "Use this to add items that you want to be valid that don't have the", "shovel tool class. Items you add are assumed to have durability.", "", "The whitelist takes priority over the blacklist.", "", "String format is a resource location: (domain):(path)"})
        public String[] SHOVEL_WHITELIST = new String[0];
        @Config.Comment(value={"Any item with a tool class of shovel is automatically valid.", "Use this to remove items that you don't want to be valid.", "", "The whitelist takes priority over the blacklist.", "", "String format is a resource location: (domain):(path)"})
        public String[] SHOVEL_BLACKLIST = new String[0];
        @Config.Comment(value={"The number of output blocks the compacting bin can hold.", "Default: 4"})
        @Config.RangeInt(min=1)
        public int MAX_CAPACITY = 4;
        @Config.Comment(value={"The item displayed to represent each harvest level in JEI.", "The index into the array is the harvest level, the value at that index", "is the displayed item. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "String format is a resource location: (domain):(path)"})
        public String[] JEI_HARVEST_LEVEL_ITEM = new String[]{"pyrotech:crude_shovel", "minecraft:stone_shovel", "minecraft:iron_shovel", "minecraft:diamond_shovel"};
        @Config.Comment(value={"The number of uses required per harvest level of the tool used.", "The index into the array is the harvest level, the value at that index", "is the required number of uses. The array can be expanded as needed.", "If the harvest level of the tool used exceeds the array length, the", "last element in the array is used.", "", "ie. {wood, stone, iron, diamond}", "Valid values are in the range: [1,+int]", "Default: {4, 3, 2, 1}"})
        public int[] TOOL_USES_REQUIRED_PER_HARVEST_LEVEL = new int[]{4, 3, 2, 1};
        @Config.Comment(value={"The amount of damage applied to the tool when a craft completes.", "Default: 1"})
        public int TOOL_DAMAGE_PER_CRAFT = 1;
        @Config.Comment(value={"How much exhaustion to apply per hit.", "Default: 1"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_HIT = 1.0;
        @Config.Comment(value={"How much exhaustion to apply per completed craft.", "Default: 0"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_CRAFT_COMPLETE = 0.0;
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
    }

    public static class StoneWorktable {
        @Config.Comment(value={"The number of hammer hits required to complete a craft.", "Default: 2"})
        @Config.RangeInt(min=1)
        public int HITS_PER_CRAFT = 2;
        @Config.Comment(value={"The amount of damage applied to the tool per craft.", "Default: 1"})
        @Config.RangeInt(min=0)
        public int TOOL_DAMAGE_PER_CRAFT = 1;
        @Config.Comment(value={"The maximum stack size for each slot in the crafting grid.", "Default: 1"})
        @Config.RangeInt(min=1, max=64)
        public int GRID_MAX_STACK_SIZE = 32;
        @Config.Comment(value={"The maximum stack size for each slot in the shelf.", "Default: 64"})
        @Config.RangeInt(min=1, max=64)
        public int SHELF_MAX_STACK_SIZE = 64;
        @Config.Comment(value={"If true, the worktable has durability and will break after the configured", "number of crafts completed.", "Default: false"})
        public boolean USES_DURABILITY = false;
        @Config.Comment(value={"The number of crafts that the worktable can perform before it breaks.", "This is only relevant if the `USES_DURABILITY` flag is true.", "Default: 512"})
        @Config.RangeInt(min=1)
        public int DURABILITY = 512;
        @Config.Comment(value={"How much exhaustion to apply per hit.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_HIT = 0.5;
        @Config.Comment(value={"How much exhaustion to apply per completed craft.", "Default: 0"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_CRAFT_COMPLETE = 0.0;
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
    }

    public static class Worktable {
        @Config.Comment(value={"The number of hammer hits required to complete a craft.", "Default: 4"})
        @Config.RangeInt(min=1)
        public int HITS_PER_CRAFT = 4;
        @Config.Comment(value={"The amount of damage applied to the tool per craft.", "Default: 2"})
        @Config.RangeInt(min=0)
        public int TOOL_DAMAGE_PER_CRAFT = 2;
        @Config.Comment(value={"The maximum stack size for each slot in the crafting grid.", "Default: 1"})
        @Config.RangeInt(min=1, max=64)
        public int GRID_MAX_STACK_SIZE = 1;
        @Config.Comment(value={"The maximum stack size for each slot in the shelf.", "Default: 1"})
        @Config.RangeInt(min=1, max=64)
        public int SHELF_MAX_STACK_SIZE = 1;
        @Config.Comment(value={"If true, the worktable has durability and will break after the configured", "number of crafts completed.", "Default: true"})
        public boolean USES_DURABILITY = true;
        @Config.Comment(value={"The number of crafts that the worktable can perform before it breaks.", "This is only relevant if the `USES_DURABILITY` flag is true.", "Default: 64"})
        @Config.RangeInt(min=1)
        public int DURABILITY = 64;
        @Config.Comment(value={"How much exhaustion to apply per hit.", "Default: 1"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_HIT = 1.0;
        @Config.Comment(value={"How much exhaustion to apply per completed craft.", "Default: 0"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_CRAFT_COMPLETE = 0.0;
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
    }

    public static class WorktableCommon {
        @Config.Comment(value={"Any recipe that you can complete in a vanilla crafting table can also", "be completed in this mod's worktables.", "", "If this list is not empty, only the recipes listed here will be allowed.", "", "The whitelist takes priority over the blacklist.", "", "String format is a recipe resource location: (domain):(path) or (domain):*"})
        public String[] RECIPE_WHITELIST = new String[0];
        @Config.Comment(value={"Any recipe that you can complete in a vanilla crafting table can also", "be completed in this mod's worktables.", "", "If this list is not empty, recipes listed here will be disallowed.", "", "The whitelist takes priority over the blacklist.", "", "String format is a recipe resource location: (domain):(path) or (domain):*"})
        public String[] RECIPE_BLACKLIST = new String[0];
        @Config.Comment(value={"If this is true, a player will be allowed to sneak + click using an", "empty hand to remove all items from the worktable's crafting grid.", "The removed items will be placed into the player's inventory or on top", "of the worktable if the player's inventory is full.", "Default: false"})
        public boolean ALLOW_RECIPE_CLEAR = false;
        @Config.Comment(value={"If this is true, a player will be allowed to sneak + click using a", "hammer to automatically place items from their inventory into the", "worktable's crafting grid that match the ingredients for the last", "recipe completed. The hammer will be damaged, see RECIPE_REPEAT_TOOL_DAMAGE.", "Default: false"})
        public boolean ALLOW_RECIPE_REPEAT = false;
        @Config.Comment(value={"If ALLOW_RECIPE_REPEAT is enabled, this is the amount of damage that", "will be applied to the hammer. Set to zero to disable.", "Default: 1"})
        @Config.RangeInt(min=0)
        public int RECIPE_REPEAT_TOOL_DAMAGE = 1;
    }
}

